/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.transform.common;

import java.util.Objects;
import org.apache.seatunnel.api.common.PrepareFailException;
import org.apache.seatunnel.api.sink.SinkCommonOptions;
import org.apache.seatunnel.api.source.SourceCommonOptions;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.api.table.type.SeaTunnelRowType;
import org.apache.seatunnel.api.transform.SeaTunnelTransform;
import org.apache.seatunnel.shade.com.typesafe.config.Config;

public abstract class AbstractSeaTunnelTransform
implements SeaTunnelTransform<SeaTunnelRow> {
    private static final String RESULT_TABLE_NAME = SourceCommonOptions.RESULT_TABLE_NAME.key();
    private static final String SOURCE_TABLE_NAME = SinkCommonOptions.SOURCE_TABLE_NAME.key();
    private String inputTableName;
    private SeaTunnelRowType inputRowType;
    private String outputTableName;
    private SeaTunnelRowType outputRowType;

    public void prepare(Config pluginConfig) throws PrepareFailException {
        if (!pluginConfig.hasPath(SOURCE_TABLE_NAME)) {
            throw new IllegalArgumentException("The configuration missing key: " + SOURCE_TABLE_NAME);
        }
        if (!pluginConfig.hasPath(RESULT_TABLE_NAME)) {
            throw new IllegalArgumentException("The configuration missing key: " + RESULT_TABLE_NAME);
        }
        this.inputTableName = pluginConfig.getString(SOURCE_TABLE_NAME);
        this.outputTableName = pluginConfig.getString(RESULT_TABLE_NAME);
        if (Objects.equals(this.inputTableName, this.outputTableName)) {
            throw new IllegalArgumentException("source and result cannot be equals: " + this.inputTableName + ", " + this.outputTableName);
        }
        this.setConfig(pluginConfig);
    }

    public void setTypeInfo(SeaTunnelDataType<SeaTunnelRow> inputDataType) {
        this.inputRowType = (SeaTunnelRowType)inputDataType;
        this.outputRowType = this.transformRowType(AbstractSeaTunnelTransform.clone(this.inputRowType));
    }

    public SeaTunnelDataType<SeaTunnelRow> getProducedType() {
        return this.outputRowType;
    }

    public SeaTunnelRow map(SeaTunnelRow row) {
        return this.transformRow(row);
    }

    protected abstract void setConfig(Config var1);

    protected abstract SeaTunnelRowType transformRowType(SeaTunnelRowType var1);

    protected abstract SeaTunnelRow transformRow(SeaTunnelRow var1);

    private static SeaTunnelRowType clone(SeaTunnelRowType rowType) {
        String[] fieldNames = new String[rowType.getTotalFields()];
        System.arraycopy(rowType.getFieldNames(), 0, fieldNames, 0, fieldNames.length);
        SeaTunnelDataType[] fieldTypes = new SeaTunnelDataType[rowType.getTotalFields()];
        System.arraycopy(rowType.getFieldTypes(), 0, fieldTypes, 0, fieldTypes.length);
        return new SeaTunnelRowType(fieldNames, fieldTypes);
    }
}

