/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.builtin.CodecUtil;
import com.hazelcast.client.impl.protocol.codec.builtin.FixedSizeTypesCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.StringCodec;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import javax.annotation.Nullable;

public final class DynamicConfigAddDurableExecutorConfigCodec {
    public static final int REQUEST_MESSAGE_TYPE = 1771776;
    public static final int RESPONSE_MESSAGE_TYPE = 1771777;
    private static final int REQUEST_POOL_SIZE_FIELD_OFFSET = 16;
    private static final int REQUEST_DURABILITY_FIELD_OFFSET = 20;
    private static final int REQUEST_CAPACITY_FIELD_OFFSET = 24;
    private static final int REQUEST_STATISTICS_ENABLED_FIELD_OFFSET = 28;
    private static final int REQUEST_INITIAL_FRAME_SIZE = 29;
    private static final int RESPONSE_INITIAL_FRAME_SIZE = 13;

    private DynamicConfigAddDurableExecutorConfigCodec() {
    }

    public static ClientMessage encodeRequest(String name, int poolSize, int durability, int capacity, @Nullable String splitBrainProtectionName, boolean statisticsEnabled) {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        clientMessage.setRetryable(false);
        clientMessage.setOperationName("DynamicConfig.AddDurableExecutorConfig");
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[29], 49152);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 1771776);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 12, -1);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 16, poolSize);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 20, durability);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 24, capacity);
        FixedSizeTypesCodec.encodeBoolean(initialFrame.content, 28, statisticsEnabled);
        clientMessage.add(initialFrame);
        StringCodec.encode(clientMessage, name);
        CodecUtil.encodeNullable(clientMessage, splitBrainProtectionName, StringCodec::encode);
        return clientMessage;
    }

    public static RequestParameters decodeRequest(ClientMessage clientMessage) {
        ClientMessage.ForwardFrameIterator iterator2 = clientMessage.frameIterator();
        RequestParameters request = new RequestParameters();
        ClientMessage.Frame initialFrame = iterator2.next();
        request.poolSize = FixedSizeTypesCodec.decodeInt(initialFrame.content, 16);
        request.durability = FixedSizeTypesCodec.decodeInt(initialFrame.content, 20);
        request.capacity = FixedSizeTypesCodec.decodeInt(initialFrame.content, 24);
        if (initialFrame.content.length >= 29) {
            request.statisticsEnabled = FixedSizeTypesCodec.decodeBoolean(initialFrame.content, 28);
            request.isStatisticsEnabledExists = true;
        } else {
            request.isStatisticsEnabledExists = false;
        }
        request.name = StringCodec.decode(iterator2);
        request.splitBrainProtectionName = CodecUtil.decodeNullable(iterator2, StringCodec::decode);
        return request;
    }

    public static ClientMessage encodeResponse() {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[13], 49152);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 1771777);
        clientMessage.add(initialFrame);
        return clientMessage;
    }

    @SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
    public static class RequestParameters {
        public String name;
        public int poolSize;
        public int durability;
        public int capacity;
        @Nullable
        public String splitBrainProtectionName;
        public boolean statisticsEnabled;
        public boolean isStatisticsEnabledExists;
    }
}

