/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cp.internal.datastructures.atomiclong.proxy;

import com.hazelcast.core.IFunction;
import com.hazelcast.cp.CPGroupId;
import com.hazelcast.cp.IAtomicLong;
import com.hazelcast.cp.internal.RaftGroupId;
import com.hazelcast.cp.internal.RaftInvocationManager;
import com.hazelcast.cp.internal.RaftService;
import com.hazelcast.cp.internal.datastructures.atomiclong.operation.AddAndGetOp;
import com.hazelcast.cp.internal.datastructures.atomiclong.operation.AlterOp;
import com.hazelcast.cp.internal.datastructures.atomiclong.operation.ApplyOp;
import com.hazelcast.cp.internal.datastructures.atomiclong.operation.CompareAndSetOp;
import com.hazelcast.cp.internal.datastructures.atomiclong.operation.GetAndAddOp;
import com.hazelcast.cp.internal.datastructures.atomiclong.operation.GetAndSetOp;
import com.hazelcast.cp.internal.datastructures.atomiclong.operation.LocalGetOp;
import com.hazelcast.cp.internal.datastructures.spi.operation.DestroyRaftObjectOp;
import com.hazelcast.cp.internal.raft.QueryPolicy;
import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.spi.impl.InternalCompletableFuture;
import com.hazelcast.spi.impl.NodeEngine;

public class AtomicLongProxy
implements IAtomicLong {
    private final RaftInvocationManager invocationManager;
    private final RaftGroupId groupId;
    private final String proxyName;
    private final String objectName;

    public AtomicLongProxy(NodeEngine nodeEngine, RaftGroupId groupId, String proxyName, String objectName) {
        RaftService service = (RaftService)nodeEngine.getService("hz:core:raft");
        this.invocationManager = service.getInvocationManager();
        this.groupId = groupId;
        this.proxyName = proxyName;
        this.objectName = objectName;
    }

    @Override
    public long addAndGet(long delta) {
        return (Long)((InternalCompletableFuture)this.addAndGetAsync(delta)).joinInternal();
    }

    @Override
    public long incrementAndGet() {
        return this.addAndGet(1L);
    }

    @Override
    public long decrementAndGet() {
        return this.addAndGet(-1L);
    }

    @Override
    public boolean compareAndSet(long expect, long update2) {
        return (Boolean)((InternalCompletableFuture)this.compareAndSetAsync(expect, update2)).joinInternal();
    }

    @Override
    public long getAndAdd(long delta) {
        return (Long)((InternalCompletableFuture)this.getAndAddAsync(delta)).joinInternal();
    }

    @Override
    public long get() {
        return this.getAndAdd(0L);
    }

    @Override
    public long getAndIncrement() {
        return this.getAndAdd(1L);
    }

    @Override
    public long getAndDecrement() {
        return this.getAndAdd(-1L);
    }

    @Override
    public long getAndSet(long newValue) {
        return (Long)((InternalCompletableFuture)this.getAndSetAsync(newValue)).joinInternal();
    }

    @Override
    public void set(long newValue) {
        this.getAndSet(newValue);
    }

    public InternalCompletableFuture<Long> addAndGetAsync(long delta) {
        AddAndGetOp op = new AddAndGetOp(this.objectName, delta);
        return delta == 0L ? this.invocationManager.query(this.groupId, op, QueryPolicy.LINEARIZABLE) : this.invocationManager.invoke(this.groupId, op);
    }

    public InternalCompletableFuture<Long> incrementAndGetAsync() {
        return this.addAndGetAsync(1L);
    }

    public InternalCompletableFuture<Long> decrementAndGetAsync() {
        return this.addAndGetAsync(-1L);
    }

    public InternalCompletableFuture<Boolean> compareAndSetAsync(long expect, long update2) {
        return this.invocationManager.invoke(this.groupId, new CompareAndSetOp(this.objectName, expect, update2));
    }

    public InternalCompletableFuture<Long> getAndAddAsync(long delta) {
        GetAndAddOp op = new GetAndAddOp(this.objectName, delta);
        return delta == 0L ? this.invocationManager.query(this.groupId, op, QueryPolicy.LINEARIZABLE) : this.invocationManager.invoke(this.groupId, op);
    }

    public InternalCompletableFuture<Long> getAsync() {
        return this.getAndAddAsync(0L);
    }

    public InternalCompletableFuture<Long> getAndIncrementAsync() {
        return this.getAndAddAsync(1L);
    }

    public InternalCompletableFuture<Long> getAndDecrementAsync() {
        return this.getAndAddAsync(-1L);
    }

    public InternalCompletableFuture<Long> getAndSetAsync(long newValue) {
        return this.invocationManager.invoke(this.groupId, new GetAndSetOp(this.objectName, newValue));
    }

    public InternalCompletableFuture<Void> setAsync(long newValue) {
        return this.getAndSetAsync(newValue);
    }

    @Override
    public void alter(IFunction<Long, Long> function) {
        this.doAlter(function, AlterOp.AlterResultType.NEW_VALUE);
    }

    @Override
    public long alterAndGet(IFunction<Long, Long> function) {
        return this.doAlter(function, AlterOp.AlterResultType.NEW_VALUE);
    }

    @Override
    public long getAndAlter(IFunction<Long, Long> function) {
        return this.doAlter(function, AlterOp.AlterResultType.OLD_VALUE);
    }

    private long doAlter(IFunction<Long, Long> function, AlterOp.AlterResultType alterResultType) {
        return this.doAlterAsync(function, alterResultType).joinInternal();
    }

    private InternalCompletableFuture<Long> doAlterAsync(IFunction<Long, Long> function, AlterOp.AlterResultType alterResultType) {
        return this.invocationManager.invoke(this.groupId, new AlterOp(this.objectName, function, alterResultType));
    }

    @Override
    public <R> R apply(IFunction<Long, R> function) {
        return (R)((InternalCompletableFuture)this.applyAsync((IFunction)function)).joinInternal();
    }

    public InternalCompletableFuture<Void> alterAsync(IFunction<Long, Long> function) {
        return this.doAlterAsync(function, AlterOp.AlterResultType.NEW_VALUE);
    }

    public InternalCompletableFuture<Long> alterAndGetAsync(IFunction<Long, Long> function) {
        return this.doAlterAsync(function, AlterOp.AlterResultType.NEW_VALUE);
    }

    public InternalCompletableFuture<Long> getAndAlterAsync(IFunction<Long, Long> function) {
        return this.doAlterAsync(function, AlterOp.AlterResultType.OLD_VALUE);
    }

    public <R> InternalCompletableFuture<R> applyAsync(IFunction<Long, R> function) {
        return this.invocationManager.query(this.groupId, new ApplyOp<R>(this.objectName, function), QueryPolicy.LINEARIZABLE);
    }

    public long localGet(QueryPolicy queryPolicy) {
        InternalCompletableFuture<Long> f = this.localGetAsync(queryPolicy);
        try {
            return (Long)f.get();
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow(e);
        }
    }

    public InternalCompletableFuture<Long> localGetAsync(QueryPolicy queryPolicy) {
        InternalCompletableFuture<Long> resultFuture = new InternalCompletableFuture<Long>();
        InternalCompletableFuture localFuture = this.invocationManager.queryLocally(this.groupId, new LocalGetOp(this.objectName), queryPolicy);
        localFuture.whenCompleteAsync((response, throwable) -> {
            if (throwable == null) {
                resultFuture.complete(response);
            } else {
                InternalCompletableFuture future = this.invocationManager.query(this.groupId, new LocalGetOp(this.objectName), queryPolicy);
                future.whenCompleteAsync(InternalCompletableFuture.completingCallback(resultFuture));
            }
        });
        return resultFuture;
    }

    @Override
    public String getPartitionKey() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getName() {
        return this.proxyName;
    }

    @Override
    public String getServiceName() {
        return "hz:raft:atomicLongService";
    }

    @Override
    public void destroy() {
        this.invocationManager.invoke(this.groupId, new DestroyRaftObjectOp(this.getServiceName(), this.objectName)).joinInternal();
    }

    public CPGroupId getGroupId() {
        return this.groupId;
    }
}

