/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.operation;

import com.hazelcast.internal.nio.IOUtil;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.map.impl.operation.AbstractMapOperationFactory;
import com.hazelcast.map.impl.operation.LoadAllOperation;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.spi.impl.operationservice.Operation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class MapLoadAllOperationFactory
extends AbstractMapOperationFactory {
    private String name;
    private List<Data> keys;
    private boolean replaceExistingValues;

    public MapLoadAllOperationFactory() {
        this.keys = Collections.emptyList();
    }

    public MapLoadAllOperationFactory(String name, List<Data> keys, boolean replaceExistingValues) {
        this.name = name;
        this.keys = keys;
        this.replaceExistingValues = replaceExistingValues;
    }

    @Override
    public Operation createOperation() {
        return new LoadAllOperation(this.name, this.keys, this.replaceExistingValues);
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeString(this.name);
        int size2 = this.keys.size();
        out.writeInt(size2);
        for (Data key : this.keys) {
            IOUtil.writeData(out, key);
        }
        out.writeBoolean(this.replaceExistingValues);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.name = in.readString();
        int size2 = in.readInt();
        if (size2 > 0) {
            this.keys = new ArrayList<Data>(size2);
        }
        for (int i = 0; i < size2; ++i) {
            Data data = IOUtil.readData(in);
            this.keys.add(data);
        }
        this.replaceExistingValues = in.readBoolean();
    }

    @Override
    public int getClassId() {
        return 81;
    }
}

