/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.query;

import com.hazelcast.internal.iteration.IterationPointer;
import com.hazelcast.map.impl.MapDataSerializerHook;
import com.hazelcast.map.impl.query.Result;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;

public class ResultSegment
implements IdentifiedDataSerializable {
    private Result result;
    private IterationPointer[] pointers;

    public ResultSegment() {
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"}, justification="This is an internal class")
    public ResultSegment(Result result2, IterationPointer[] pointers) {
        this.result = result2;
        this.pointers = pointers;
    }

    public Result getResult() {
        return this.result;
    }

    public void setResult(Result result2) {
        this.result = result2;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="This is an internal class")
    public IterationPointer[] getPointers() {
        return this.pointers;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"}, justification="This is an internal class")
    public void setPointers(IterationPointer[] pointers) {
        this.pointers = pointers;
    }

    @Override
    public int getFactoryId() {
        return MapDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 128;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeObject(this.result);
        out.writeInt(this.pointers.length);
        for (IterationPointer pointer : this.pointers) {
            out.writeInt(pointer.getIndex());
            out.writeInt(pointer.getSize());
        }
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.result = (Result)in.readObject();
        int pointersCount = in.readInt();
        this.pointers = new IterationPointer[pointersCount];
        for (int i = 0; i < pointersCount; ++i) {
            this.pointers[i] = new IterationPointer(in.readInt(), in.readInt());
        }
    }
}

