/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.checkpoint.storage.common;

import io.protostuff.LinkedBuffer;
import io.protostuff.ProtostuffIOUtil;
import io.protostuff.Schema;
import io.protostuff.runtime.RuntimeSchema;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.seatunnel.engine.checkpoint.storage.common.Serializer;

public class ProtoStuffSerializer
implements Serializer {
    private static final Map<Class<?>, Schema<?>> SCHEMA_CACHE = new ConcurrentHashMap();

    private static <T> Schema<T> getSchema(Class<T> clazz) {
        return SCHEMA_CACHE.computeIfAbsent(clazz, RuntimeSchema::createFrom);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> byte[] serialize(T obj) {
        byte[] data;
        Class<?> clazz = obj.getClass();
        LinkedBuffer buffer = LinkedBuffer.allocate(512);
        Schema<?> schema = ProtoStuffSerializer.getSchema(clazz);
        try {
            data = ProtostuffIOUtil.toByteArray(obj, schema, buffer);
        }
        finally {
            buffer.clear();
        }
        return data;
    }

    @Override
    public <T> T deserialize(byte[] data, Class<T> clz) {
        Schema<T> schema = ProtoStuffSerializer.getSchema(clz);
        T obj = schema.newMessage();
        if (null == obj) {
            return null;
        }
        ProtostuffIOUtil.mergeFrom(data, obj, schema);
        return obj;
    }
}

