/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.server.checkpoint;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import org.apache.seatunnel.engine.server.checkpoint.ActionSubtaskState;

public class ActionState
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String actionId;
    private final List<ActionSubtaskState> subtaskStates;
    private ActionSubtaskState coordinatorState;
    private final int parallelism;

    public ActionState(String actionId, int parallelism) {
        this.actionId = actionId;
        this.subtaskStates = Arrays.asList(new ActionSubtaskState[parallelism]);
        this.parallelism = parallelism;
    }

    public String getActionId() {
        return this.actionId;
    }

    public List<ActionSubtaskState> getSubtaskStates() {
        return this.subtaskStates;
    }

    public ActionSubtaskState getCoordinatorState() {
        return this.coordinatorState;
    }

    public int getParallelism() {
        return this.parallelism;
    }

    public void reportState(int index, ActionSubtaskState state) {
        if (index < 0) {
            this.coordinatorState = state;
            return;
        }
        this.subtaskStates.set(index, state);
    }
}

