/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.server.task.flow;

import com.hazelcast.ringbuffer.Ringbuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.apache.seatunnel.api.table.type.Record;
import org.apache.seatunnel.api.transform.Collector;
import org.apache.seatunnel.engine.server.task.SeaTunnelTask;
import org.apache.seatunnel.engine.server.task.flow.AbstractFlowLifeCycle;
import org.apache.seatunnel.engine.server.task.flow.OneOutputFlowLifeCycle;
import org.apache.seatunnel.engine.server.task.record.Barrier;

public class PartitionTransformSourceFlowLifeCycle<T>
extends AbstractFlowLifeCycle
implements OneOutputFlowLifeCycle<T> {
    private Ringbuffer<T>[] ringbuffers;
    private final Map<Integer, Barrier> alignedBarriers = new HashMap<Integer, Barrier>();
    private long currentCheckpointId = Long.MAX_VALUE;
    private int alignedBarriersCounter = 0;

    public PartitionTransformSourceFlowLifeCycle(SeaTunnelTask runningTask, CompletableFuture<Void> completableFuture) {
        super(runningTask, completableFuture);
    }

    @Override
    public void collect(Collector<T> collector) throws Exception {
        for (int i = 0; i < this.ringbuffers.length; ++i) {
            Ringbuffer<T> ringbuffer = this.ringbuffers[i];
            if (ringbuffer.size() <= 0L || this.alignedBarriers.get(i) != null && this.alignedBarriers.get(i).getId() == this.currentCheckpointId) continue;
            T item = ringbuffer.readOne(ringbuffer.headSequence());
            Record record = (Record)item;
            if (record.getData() instanceof Barrier) {
                Barrier barrier = (Barrier)record.getData();
                this.alignedBarriers.put(i, barrier);
                ++this.alignedBarriersCounter;
                this.currentCheckpointId = barrier.getId();
                if (this.alignedBarriersCounter != this.ringbuffers.length) continue;
                this.runningTask.ack(barrier);
                if (barrier.prepareClose()) {
                    this.prepareClose = true;
                }
                collector.collect(item);
                this.alignedBarriersCounter = 0;
                continue;
            }
            if (this.prepareClose.booleanValue()) {
                return;
            }
            collector.collect(item);
        }
    }
}

