/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.transform.adaptsink;

import java.util.Map;
import java.util.stream.Collectors;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.api.table.catalog.Column;
import org.apache.seatunnel.api.table.catalog.TableIdentifier;
import org.apache.seatunnel.api.table.catalog.TableSchema;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.transform.adaptsink.DefineSinkTypeTransformConfig;
import org.apache.seatunnel.transform.common.AbstractCatalogSupportMapTransform;

public class DefineSinkTypeTransform
extends AbstractCatalogSupportMapTransform {
    private final Map<String, DefineSinkTypeTransformConfig.DefineColumnType> columnConfig;

    public DefineSinkTypeTransform(DefineSinkTypeTransformConfig config, CatalogTable inputCatalogTable) {
        super(inputCatalogTable);
        this.columnConfig = config.toMap();
        this.columnConfig.keySet().forEach(key -> {
            if (inputCatalogTable.getTableSchema().indexOf(key) < 0) {
                throw new IllegalArgumentException(String.format("Column %s not found in table %s rowtype : %s", key, inputCatalogTable.getTablePath(), inputCatalogTable.getSeaTunnelRowType()));
            }
        });
    }

    public String getPluginName() {
        return "DefineSinkType";
    }

    @Override
    protected TableIdentifier transformTableIdentifier() {
        return this.inputCatalogTable.getTableId();
    }

    @Override
    protected SeaTunnelRow transformRow(SeaTunnelRow inputRow) {
        return inputRow;
    }

    @Override
    protected TableSchema transformTableSchema() {
        return TableSchema.builder().primaryKey(this.inputCatalogTable.getTableSchema().getPrimaryKey()).constraintKey(this.inputCatalogTable.getTableSchema().getConstraintKeys()).columns(this.inputCatalogTable.getTableSchema().getColumns().stream().map((? super T column) -> {
            if (!this.columnConfig.containsKey(column.getName())) {
                return column;
            }
            DefineSinkTypeTransformConfig.DefineColumnType defineColumnType = this.columnConfig.get(column.getName());
            Column newColumn = column.copy();
            newColumn.setSinkType(defineColumnType.getType());
            return newColumn;
        }).collect(Collectors.toList())).build();
    }
}

