/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.circuitbreak.client.api;

import com.tencent.polaris.api.plugin.circuitbreaker.ResourceStat;
import com.tencent.polaris.api.plugin.circuitbreaker.entity.MethodResource;
import com.tencent.polaris.api.plugin.circuitbreaker.entity.ServiceResource;
import com.tencent.polaris.api.pojo.RetStatus;
import com.tencent.polaris.api.utils.StringUtils;
import com.tencent.polaris.circuitbreak.api.CircuitBreakAPI;
import com.tencent.polaris.circuitbreak.api.InvokeHandler;
import com.tencent.polaris.circuitbreak.api.pojo.CheckResult;
import com.tencent.polaris.circuitbreak.api.pojo.InvokeContext;
import com.tencent.polaris.circuitbreak.api.pojo.ResultToErrorCode;
import com.tencent.polaris.circuitbreak.client.exception.CallAbortedException;

public class DefaultInvokeHandler
implements InvokeHandler {
    private final CircuitBreakAPI circuitBreakAPI;
    private final InvokeContext.RequestContext requestContext;

    public DefaultInvokeHandler(InvokeContext.RequestContext requestContext, CircuitBreakAPI circuitBreakAPI) {
        this.requestContext = requestContext;
        this.circuitBreakAPI = circuitBreakAPI;
    }

    @Override
    public void acquirePermission() {
        CheckResult check2 = this.commonCheck(this.requestContext);
        if (check2 != null) {
            throw new CallAbortedException(check2.getRuleName(), check2.getFallbackInfo());
        }
    }

    @Override
    public void onSuccess(InvokeContext.ResponseContext responseContext) {
        long delay = responseContext.getDurationUnit().toMillis(responseContext.getDuration());
        ResultToErrorCode resultToErrorCode = this.requestContext.getResultToErrorCode();
        int code = 0;
        RetStatus retStatus = RetStatus.RetUnknown;
        if (null != resultToErrorCode) {
            code = resultToErrorCode.onSuccess(responseContext.getResult());
        }
        this.commonReport(this.requestContext, delay, code, retStatus);
    }

    @Override
    public void onError(InvokeContext.ResponseContext responseContext) {
        long delay = responseContext.getDurationUnit().toMillis(responseContext.getDuration());
        ResultToErrorCode resultToErrorCode = this.requestContext.getResultToErrorCode();
        int code = -1;
        RetStatus retStatus = RetStatus.RetUnknown;
        if (null != resultToErrorCode) {
            code = resultToErrorCode.onError(responseContext.getError());
        }
        if (responseContext.getError() instanceof CallAbortedException) {
            retStatus = RetStatus.RetReject;
        }
        this.commonReport(this.requestContext, delay, code, retStatus);
    }

    private CheckResult commonCheck(InvokeContext.RequestContext requestContext) {
        MethodResource methodResource;
        ServiceResource svcResource = new ServiceResource(requestContext.getService(), requestContext.getSourceService());
        CheckResult check2 = this.circuitBreakAPI.check(svcResource);
        if (!check2.isPass()) {
            return check2;
        }
        if (StringUtils.isNotBlank(requestContext.getMethod()) && !(check2 = this.circuitBreakAPI.check(methodResource = new MethodResource(requestContext.getService(), requestContext.getMethod(), requestContext.getSourceService()))).isPass()) {
            return check2;
        }
        return null;
    }

    private void commonReport(InvokeContext.RequestContext requestContext, long delayMills, int code, RetStatus retStatus) {
        ServiceResource svcResource = new ServiceResource(requestContext.getService(), requestContext.getSourceService());
        ResourceStat resourceStat = new ResourceStat(svcResource, code, delayMills, retStatus);
        this.circuitBreakAPI.report(resourceStat);
        if (StringUtils.isNotBlank(requestContext.getMethod())) {
            MethodResource methodResource = new MethodResource(requestContext.getService(), requestContext.getMethod(), requestContext.getSourceService());
            resourceStat = new ResourceStat(methodResource, code, delayMills, retStatus);
            this.circuitBreakAPI.report(resourceStat);
        }
    }
}

