/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metrics.model;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.dubbo.common.utils.ConfigUtils;
import org.apache.dubbo.common.utils.NetUtils;
import org.apache.dubbo.metrics.model.Metric;

public class ThreadPoolMetric
implements Metric {
    private String applicationName;
    private String threadPoolName;
    private ThreadPoolExecutor threadPoolExecutor;

    public ThreadPoolMetric(String applicationName, String threadPoolName, ThreadPoolExecutor threadPoolExecutor) {
        this.applicationName = applicationName;
        this.threadPoolExecutor = threadPoolExecutor;
        this.threadPoolName = threadPoolName;
    }

    public String getThreadPoolName() {
        return this.threadPoolName;
    }

    public void setThreadPoolName(String threadPoolName) {
        this.threadPoolName = threadPoolName;
    }

    public ThreadPoolExecutor getThreadPoolExecutor() {
        return this.threadPoolExecutor;
    }

    public void setThreadPoolExecutor(ThreadPoolExecutor threadPoolExecutor) {
        this.threadPoolExecutor = threadPoolExecutor;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ThreadPoolMetric that = (ThreadPoolMetric)o;
        return Objects.equals(this.applicationName, that.applicationName) && Objects.equals(this.threadPoolName, that.threadPoolName);
    }

    public int hashCode() {
        return Objects.hash(this.applicationName, this.threadPoolName);
    }

    @Override
    public Map<String, String> getTags() {
        HashMap<String, String> tags = new HashMap<String, String>();
        tags.put("ip", NetUtils.getLocalHost());
        tags.put("pid", ConfigUtils.getPid() + "");
        tags.put("hostname", NetUtils.getLocalHostName());
        tags.put("application.name", this.applicationName);
        tags.put("thread.pool.name", this.threadPoolName);
        return tags;
    }

    public double getCorePoolSize() {
        return this.threadPoolExecutor.getCorePoolSize();
    }

    public double getLargestPoolSize() {
        return this.threadPoolExecutor.getLargestPoolSize();
    }

    public double getMaximumPoolSize() {
        return this.threadPoolExecutor.getMaximumPoolSize();
    }

    public double getActiveCount() {
        return this.threadPoolExecutor.getActiveCount();
    }

    public double getPoolSize() {
        return this.threadPoolExecutor.getPoolSize();
    }

    public double getQueueSize() {
        return this.threadPoolExecutor.getQueue().size();
    }
}

