/*
 * Decompiled with CFR 0.152.
 */
package com.github.victools.jsonschema.generator.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.victools.jsonschema.generator.FieldScope;
import com.github.victools.jsonschema.generator.MethodScope;
import com.github.victools.jsonschema.generator.SchemaGenerationContext;
import com.github.victools.jsonschema.generator.SchemaGeneratorConfig;
import com.github.victools.jsonschema.generator.SchemaKeyword;
import com.github.victools.jsonschema.generator.SchemaVersion;
import com.github.victools.jsonschema.generator.TypeScope;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AttributeCollector {
    private static final Logger logger = LoggerFactory.getLogger(AttributeCollector.class);
    private final ObjectMapper objectMapper;

    public AttributeCollector(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public static ObjectNode collectFieldAttributes(FieldScope field, SchemaGenerationContext generationContext) {
        SchemaGeneratorConfig config = generationContext.getGeneratorConfig();
        ObjectNode node = config.createObjectNode();
        AttributeCollector collector = new AttributeCollector(config.getObjectMapper());
        collector.setTitle(node, config.resolveTitle(field), generationContext);
        collector.setDescription(node, config.resolveDescription(field), generationContext);
        collector.setDefault(node, config.resolveDefault(field), generationContext);
        collector.setEnum(node, config.resolveEnum(field), generationContext);
        collector.setReadOnly(node, config.isReadOnly(field), generationContext);
        collector.setWriteOnly(node, config.isWriteOnly(field), generationContext);
        collector.setAdditionalProperties(node, config.resolveAdditionalProperties(field, generationContext), generationContext);
        collector.setPatternProperties(node, config.resolvePatternProperties(field, generationContext), generationContext);
        collector.setStringMinLength(node, config.resolveStringMinLength(field), generationContext);
        collector.setStringMaxLength(node, config.resolveStringMaxLength(field), generationContext);
        collector.setStringFormat(node, config.resolveStringFormat(field), generationContext);
        collector.setStringPattern(node, config.resolveStringPattern(field), generationContext);
        collector.setNumberInclusiveMinimum(node, config.resolveNumberInclusiveMinimum(field), generationContext);
        collector.setNumberExclusiveMinimum(node, config.resolveNumberExclusiveMinimum(field), generationContext);
        collector.setNumberInclusiveMaximum(node, config.resolveNumberInclusiveMaximum(field), generationContext);
        collector.setNumberExclusiveMaximum(node, config.resolveNumberExclusiveMaximum(field), generationContext);
        collector.setNumberMultipleOf(node, config.resolveNumberMultipleOf(field), generationContext);
        collector.setArrayMinItems(node, config.resolveArrayMinItems(field), generationContext);
        collector.setArrayMaxItems(node, config.resolveArrayMaxItems(field), generationContext);
        collector.setArrayUniqueItems(node, config.resolveArrayUniqueItems(field), generationContext);
        config.getFieldAttributeOverrides().forEach(override -> override.overrideInstanceAttributes(node, field, generationContext));
        return node;
    }

    public static ObjectNode collectMethodAttributes(MethodScope method, SchemaGenerationContext generationContext) {
        SchemaGeneratorConfig config = generationContext.getGeneratorConfig();
        ObjectNode node = config.createObjectNode();
        AttributeCollector collector = new AttributeCollector(config.getObjectMapper());
        collector.setTitle(node, config.resolveTitle(method), generationContext);
        collector.setDescription(node, config.resolveDescription(method), generationContext);
        collector.setDefault(node, config.resolveDefault(method), generationContext);
        collector.setEnum(node, config.resolveEnum(method), generationContext);
        collector.setReadOnly(node, config.isReadOnly(method), generationContext);
        collector.setWriteOnly(node, config.isWriteOnly(method), generationContext);
        collector.setAdditionalProperties(node, config.resolveAdditionalProperties(method, generationContext), generationContext);
        collector.setPatternProperties(node, config.resolvePatternProperties(method, generationContext), generationContext);
        collector.setStringMinLength(node, config.resolveStringMinLength(method), generationContext);
        collector.setStringMaxLength(node, config.resolveStringMaxLength(method), generationContext);
        collector.setStringFormat(node, config.resolveStringFormat(method), generationContext);
        collector.setStringPattern(node, config.resolveStringPattern(method), generationContext);
        collector.setNumberInclusiveMinimum(node, config.resolveNumberInclusiveMinimum(method), generationContext);
        collector.setNumberExclusiveMinimum(node, config.resolveNumberExclusiveMinimum(method), generationContext);
        collector.setNumberInclusiveMaximum(node, config.resolveNumberInclusiveMaximum(method), generationContext);
        collector.setNumberExclusiveMaximum(node, config.resolveNumberExclusiveMaximum(method), generationContext);
        collector.setNumberMultipleOf(node, config.resolveNumberMultipleOf(method), generationContext);
        collector.setArrayMinItems(node, config.resolveArrayMinItems(method), generationContext);
        collector.setArrayMaxItems(node, config.resolveArrayMaxItems(method), generationContext);
        collector.setArrayUniqueItems(node, config.resolveArrayUniqueItems(method), generationContext);
        config.getMethodAttributeOverrides().forEach(override -> override.overrideInstanceAttributes(node, method, generationContext));
        return node;
    }

    public static ObjectNode collectTypeAttributes(TypeScope scope, SchemaGenerationContext generationContext, Set<String> allowedSchemaTypes) {
        SchemaGeneratorConfig config = generationContext.getGeneratorConfig();
        ObjectNode node = config.createObjectNode();
        AttributeCollector collector = new AttributeCollector(config.getObjectMapper());
        collector.setId(node, config.resolveIdForType(scope), generationContext);
        collector.setAnchor(node, config.resolveAnchorForType(scope), generationContext);
        collector.setTitle(node, config.resolveTitleForType(scope), generationContext);
        collector.setDescription(node, config.resolveDescriptionForType(scope), generationContext);
        collector.setDefault(node, config.resolveDefaultForType(scope), generationContext);
        collector.setEnum(node, config.resolveEnumForType(scope), generationContext);
        if (AttributeCollector.isListEmptyOrContainingAtLeastOne(allowedSchemaTypes, config, SchemaKeyword.TAG_TYPE_OBJECT)) {
            collector.setAdditionalProperties(node, config.resolveAdditionalPropertiesForType(scope, generationContext), generationContext);
            collector.setPatternProperties(node, config.resolvePatternPropertiesForType(scope, generationContext), generationContext);
        }
        if (AttributeCollector.isListEmptyOrContainingAtLeastOne(allowedSchemaTypes, config, SchemaKeyword.TAG_TYPE_STRING)) {
            collector.setStringMinLength(node, config.resolveStringMinLengthForType(scope), generationContext);
            collector.setStringMaxLength(node, config.resolveStringMaxLengthForType(scope), generationContext);
            collector.setStringFormat(node, config.resolveStringFormatForType(scope), generationContext);
            collector.setStringPattern(node, config.resolveStringPatternForType(scope), generationContext);
        }
        if (AttributeCollector.isListEmptyOrContainingAtLeastOne(allowedSchemaTypes, config, SchemaKeyword.TAG_TYPE_INTEGER, SchemaKeyword.TAG_TYPE_NUMBER)) {
            collector.setNumberInclusiveMinimum(node, config.resolveNumberInclusiveMinimumForType(scope), generationContext);
            collector.setNumberExclusiveMinimum(node, config.resolveNumberExclusiveMinimumForType(scope), generationContext);
            collector.setNumberInclusiveMaximum(node, config.resolveNumberInclusiveMaximumForType(scope), generationContext);
            collector.setNumberExclusiveMaximum(node, config.resolveNumberExclusiveMaximumForType(scope), generationContext);
            collector.setNumberMultipleOf(node, config.resolveNumberMultipleOfForType(scope), generationContext);
        }
        if (AttributeCollector.isListEmptyOrContainingAtLeastOne(allowedSchemaTypes, config, SchemaKeyword.TAG_TYPE_ARRAY)) {
            collector.setArrayMinItems(node, config.resolveArrayMinItemsForType(scope), generationContext);
            collector.setArrayMaxItems(node, config.resolveArrayMaxItemsForType(scope), generationContext);
            collector.setArrayUniqueItems(node, config.resolveArrayUniqueItemsForType(scope), generationContext);
        }
        return node;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isListEmptyOrContainingAtLeastOne(Set<String> values, SchemaGeneratorConfig config, SchemaKeyword ... keywords) {
        if (values.isEmpty()) return true;
        if (!Stream.of(keywords).map(config::getKeyword).anyMatch(values::contains)) return false;
        return true;
    }

    public static void mergeMissingAttributes(ObjectNode targetNode, ObjectNode attributeContainer) {
        if (attributeContainer == null) {
            return;
        }
        Iterator attributeIterator = attributeContainer.fields();
        while (attributeIterator.hasNext()) {
            Map.Entry attribute = (Map.Entry)attributeIterator.next();
            if (targetNode.has((String)attribute.getKey())) continue;
            targetNode.set((String)attribute.getKey(), (JsonNode)attribute.getValue());
        }
    }

    public AttributeCollector setId(ObjectNode node, String id, SchemaGenerationContext generationContext) {
        if (id != null) {
            node.put(generationContext.getKeyword(SchemaKeyword.TAG_ID), id);
        }
        return this;
    }

    public AttributeCollector setAnchor(ObjectNode node, String anchor, SchemaGenerationContext generationContext) {
        if (anchor != null) {
            node.put(generationContext.getKeyword(SchemaKeyword.TAG_ANCHOR), anchor);
        }
        return this;
    }

    @Deprecated
    public AttributeCollector setTitle(ObjectNode node, String title) {
        if (title != null) {
            node.put(SchemaKeyword.TAG_TITLE.forVersion(SchemaVersion.DRAFT_7), title);
        }
        return this;
    }

    public AttributeCollector setTitle(ObjectNode node, String title, SchemaGenerationContext generationContext) {
        if (title != null) {
            node.put(generationContext.getKeyword(SchemaKeyword.TAG_TITLE), title);
        }
        return this;
    }

    @Deprecated
    public AttributeCollector setDescription(ObjectNode node, String description) {
        if (description != null) {
            node.put(SchemaKeyword.TAG_DESCRIPTION.forVersion(SchemaVersion.DRAFT_7), description);
        }
        return this;
    }

    public AttributeCollector setDescription(ObjectNode node, String description, SchemaGenerationContext generationContext) {
        if (description != null) {
            node.put(generationContext.getKeyword(SchemaKeyword.TAG_DESCRIPTION), description);
        }
        return this;
    }

    @Deprecated
    public AttributeCollector setDefault(ObjectNode node, Object defaultValue) {
        if (defaultValue != null) {
            String defaultTag = SchemaKeyword.TAG_DEFAULT.forVersion(SchemaVersion.DRAFT_7);
            this.addRawPropertyValue(node, defaultTag, defaultValue);
        }
        return this;
    }

    public AttributeCollector setDefault(ObjectNode node, Object defaultValue, SchemaGenerationContext generationContext) {
        if (defaultValue != null) {
            String defaultTag = generationContext.getKeyword(SchemaKeyword.TAG_DEFAULT);
            this.addRawPropertyValue(node, defaultTag, defaultValue);
        }
        return this;
    }

    @Deprecated
    public AttributeCollector setEnum(ObjectNode node, Collection<?> enumValues) {
        if (enumValues != null) {
            SchemaVersion schemaVersion = SchemaVersion.DRAFT_7;
            List<Object> values = enumValues.stream().filter(this::isSupportedEnumValue).filter(this::canBeConvertedToString).collect(Collectors.toList());
            if (values.size() == 1) {
                this.addRawPropertyValue(node, SchemaKeyword.TAG_CONST.forVersion(schemaVersion), values.get(0));
            } else if (!values.isEmpty()) {
                ArrayNode array = node.arrayNode();
                values.forEach(singleValue -> this.addRawArrayItem(array, singleValue));
                node.set(SchemaKeyword.TAG_ENUM.forVersion(schemaVersion), (JsonNode)array);
            }
        }
        return this;
    }

    public AttributeCollector setEnum(ObjectNode node, Collection<?> enumValues, SchemaGenerationContext generationContext) {
        if (enumValues == null) {
            return this;
        }
        List<Object> values = enumValues.stream().filter(this::isSupportedEnumValue).filter(this::canBeConvertedToString).collect(Collectors.toList());
        if (values.size() == 1 && generationContext.getGeneratorConfig().shouldRepresentSingleAllowedValueAsConst()) {
            this.addRawPropertyValue(node, generationContext.getKeyword(SchemaKeyword.TAG_CONST), values.get(0));
        } else if (!values.isEmpty()) {
            ArrayNode array = node.arrayNode();
            values.forEach(singleValue -> this.addRawArrayItem(array, singleValue));
            node.set(generationContext.getKeyword(SchemaKeyword.TAG_ENUM), (JsonNode)array);
        }
        return this;
    }

    private void addRawPropertyValue(ObjectNode node, String propertyName, Object value) {
        if (value instanceof String) {
            node.put(propertyName, (String)value);
        } else if (value instanceof BigDecimal) {
            node.put(propertyName, (BigDecimal)value);
        } else if (value instanceof BigInteger) {
            node.put(propertyName, (BigInteger)value);
        } else if (value instanceof Boolean) {
            node.put(propertyName, (Boolean)value);
        } else if (value instanceof Double) {
            node.put(propertyName, (Double)value);
        } else if (value instanceof Float) {
            node.put(propertyName, (Float)value);
        } else if (value instanceof Integer) {
            node.put(propertyName, (Integer)value);
        } else {
            node.putPOJO(propertyName, value);
        }
    }

    private void addRawArrayItem(ArrayNode node, Object value) {
        if (value instanceof String) {
            node.add((String)value);
        } else if (value instanceof BigDecimal) {
            node.add((BigDecimal)value);
        } else if (value instanceof BigInteger) {
            node.add((BigInteger)value);
        } else if (value instanceof Boolean) {
            node.add((Boolean)value);
        } else if (value instanceof Double) {
            node.add((Double)value);
        } else if (value instanceof Float) {
            node.add((Float)value);
        } else if (value instanceof Integer) {
            node.add((Integer)value);
        } else {
            node.addPOJO(value);
        }
    }

    private boolean isSupportedEnumValue(Object target) {
        if (target == null) {
            return true;
        }
        Class<?> targetType = target.getClass();
        return targetType.isPrimitive() || Boolean.class.isAssignableFrom(targetType) || Number.class.isAssignableFrom(targetType) || CharSequence.class.isAssignableFrom(targetType) || Enum.class.isAssignableFrom(targetType);
    }

    private boolean canBeConvertedToString(Object target) {
        try {
            return target == null || this.objectMapper.writeValueAsString(target) != null;
        }
        catch (JsonProcessingException ex) {
            logger.warn("Failed to convert value to string via ObjectMapper: {}", target, (Object)ex);
            return false;
        }
    }

    public AttributeCollector setReadOnly(ObjectNode node, boolean readOnly, SchemaGenerationContext generationContext) {
        if (readOnly) {
            node.put(generationContext.getKeyword(SchemaKeyword.TAG_READ_ONLY), true);
        }
        return this;
    }

    public AttributeCollector setWriteOnly(ObjectNode node, boolean writeOnly, SchemaGenerationContext generationContext) {
        if (writeOnly) {
            node.put(generationContext.getKeyword(SchemaKeyword.TAG_WRITE_ONLY), true);
        }
        return this;
    }

    public AttributeCollector setAdditionalProperties(ObjectNode node, JsonNode additionalProperties, SchemaGenerationContext generationContext) {
        if (!this.isNullOrTrue(additionalProperties)) {
            node.set(generationContext.getKeyword(SchemaKeyword.TAG_ADDITIONAL_PROPERTIES), additionalProperties);
        }
        return this;
    }

    private boolean isNullOrTrue(JsonNode nodeToCheck) {
        return nodeToCheck == null || nodeToCheck.isNull() || nodeToCheck.isBoolean() && nodeToCheck.asBoolean();
    }

    public AttributeCollector setPatternProperties(ObjectNode node, Map<String, JsonNode> patternProperties, SchemaGenerationContext generationContext) {
        if (patternProperties != null && !patternProperties.isEmpty()) {
            ObjectNode patternPropertiesNode = this.objectMapper.createObjectNode();
            patternPropertiesNode.setAll(patternProperties);
            node.set(generationContext.getKeyword(SchemaKeyword.TAG_PATTERN_PROPERTIES), (JsonNode)patternPropertiesNode);
        }
        return this;
    }

    @Deprecated
    public AttributeCollector setStringMinLength(ObjectNode node, Integer minLength) {
        if (minLength != null) {
            node.put(SchemaKeyword.TAG_LENGTH_MIN.forVersion(SchemaVersion.DRAFT_7), minLength);
        }
        return this;
    }

    public AttributeCollector setStringMinLength(ObjectNode node, Integer minLength, SchemaGenerationContext generationContext) {
        if (minLength != null) {
            node.put(generationContext.getKeyword(SchemaKeyword.TAG_LENGTH_MIN), minLength);
        }
        return this;
    }

    @Deprecated
    public AttributeCollector setStringMaxLength(ObjectNode node, Integer maxLength) {
        if (maxLength != null) {
            node.put(SchemaKeyword.TAG_LENGTH_MAX.forVersion(SchemaVersion.DRAFT_7), maxLength);
        }
        return this;
    }

    public AttributeCollector setStringMaxLength(ObjectNode node, Integer maxLength, SchemaGenerationContext generationContext) {
        if (maxLength != null) {
            node.put(generationContext.getKeyword(SchemaKeyword.TAG_LENGTH_MAX), maxLength);
        }
        return this;
    }

    @Deprecated
    public AttributeCollector setStringFormat(ObjectNode node, String format) {
        if (format != null) {
            node.put(SchemaKeyword.TAG_FORMAT.forVersion(SchemaVersion.DRAFT_7), format);
        }
        return this;
    }

    public AttributeCollector setStringFormat(ObjectNode node, String format, SchemaGenerationContext generationContext) {
        if (format != null) {
            node.put(generationContext.getKeyword(SchemaKeyword.TAG_FORMAT), format);
        }
        return this;
    }

    @Deprecated
    public AttributeCollector setStringPattern(ObjectNode node, String pattern) {
        if (pattern != null) {
            node.put(SchemaKeyword.TAG_PATTERN.forVersion(SchemaVersion.DRAFT_7), pattern);
        }
        return this;
    }

    public AttributeCollector setStringPattern(ObjectNode node, String pattern, SchemaGenerationContext generationContext) {
        if (pattern != null) {
            node.put(generationContext.getKeyword(SchemaKeyword.TAG_PATTERN), pattern);
        }
        return this;
    }

    @Deprecated
    public AttributeCollector setNumberInclusiveMinimum(ObjectNode node, BigDecimal inclusiveMinimum) {
        if (inclusiveMinimum != null) {
            node.put(SchemaKeyword.TAG_MINIMUM.forVersion(SchemaVersion.DRAFT_7), inclusiveMinimum);
        }
        return this;
    }

    public AttributeCollector setNumberInclusiveMinimum(ObjectNode node, BigDecimal inclusiveMinimum, SchemaGenerationContext generationContext) {
        if (inclusiveMinimum != null) {
            node.put(generationContext.getKeyword(SchemaKeyword.TAG_MINIMUM), inclusiveMinimum);
        }
        return this;
    }

    @Deprecated
    public AttributeCollector setNumberExclusiveMinimum(ObjectNode node, BigDecimal exclusiveMinimum) {
        if (exclusiveMinimum != null) {
            node.put(SchemaKeyword.TAG_MINIMUM_EXCLUSIVE.forVersion(SchemaVersion.DRAFT_7), exclusiveMinimum);
        }
        return this;
    }

    public AttributeCollector setNumberExclusiveMinimum(ObjectNode node, BigDecimal exclusiveMinimum, SchemaGenerationContext generationContext) {
        if (exclusiveMinimum != null) {
            node.put(generationContext.getKeyword(SchemaKeyword.TAG_MINIMUM_EXCLUSIVE), exclusiveMinimum);
        }
        return this;
    }

    @Deprecated
    public AttributeCollector setNumberInclusiveMaximum(ObjectNode node, BigDecimal inclusiveMaximum) {
        if (inclusiveMaximum != null) {
            node.put(SchemaKeyword.TAG_MAXIMUM.forVersion(SchemaVersion.DRAFT_7), inclusiveMaximum);
        }
        return this;
    }

    public AttributeCollector setNumberInclusiveMaximum(ObjectNode node, BigDecimal inclusiveMaximum, SchemaGenerationContext generationContext) {
        if (inclusiveMaximum != null) {
            node.put(generationContext.getKeyword(SchemaKeyword.TAG_MAXIMUM), inclusiveMaximum);
        }
        return this;
    }

    @Deprecated
    public AttributeCollector setNumberExclusiveMaximum(ObjectNode node, BigDecimal exclusiveMaximum) {
        if (exclusiveMaximum != null) {
            node.put(SchemaKeyword.TAG_MAXIMUM_EXCLUSIVE.forVersion(SchemaVersion.DRAFT_7), exclusiveMaximum);
        }
        return this;
    }

    public AttributeCollector setNumberExclusiveMaximum(ObjectNode node, BigDecimal exclusiveMaximum, SchemaGenerationContext generationContext) {
        if (exclusiveMaximum != null) {
            node.put(generationContext.getKeyword(SchemaKeyword.TAG_MAXIMUM_EXCLUSIVE), exclusiveMaximum);
        }
        return this;
    }

    @Deprecated
    public AttributeCollector setNumberMultipleOf(ObjectNode node, BigDecimal multipleOf) {
        if (multipleOf != null) {
            node.put(SchemaKeyword.TAG_MULTIPLE_OF.forVersion(SchemaVersion.DRAFT_7), multipleOf);
        }
        return this;
    }

    public AttributeCollector setNumberMultipleOf(ObjectNode node, BigDecimal multipleOf, SchemaGenerationContext generationContext) {
        if (multipleOf != null) {
            node.put(generationContext.getKeyword(SchemaKeyword.TAG_MULTIPLE_OF), multipleOf);
        }
        return this;
    }

    @Deprecated
    public AttributeCollector setArrayMinItems(ObjectNode node, Integer minItemCount) {
        if (minItemCount != null) {
            node.put(SchemaKeyword.TAG_ITEMS_MIN.forVersion(SchemaVersion.DRAFT_7), minItemCount);
        }
        return this;
    }

    public AttributeCollector setArrayMinItems(ObjectNode node, Integer minItemCount, SchemaGenerationContext generationContext) {
        if (minItemCount != null) {
            node.put(generationContext.getKeyword(SchemaKeyword.TAG_ITEMS_MIN), minItemCount);
        }
        return this;
    }

    @Deprecated
    public AttributeCollector setArrayMaxItems(ObjectNode node, Integer maxItemCount) {
        if (maxItemCount != null) {
            node.put(SchemaKeyword.TAG_ITEMS_MAX.forVersion(SchemaVersion.DRAFT_7), maxItemCount);
        }
        return this;
    }

    public AttributeCollector setArrayMaxItems(ObjectNode node, Integer maxItemCount, SchemaGenerationContext generationContext) {
        if (maxItemCount != null) {
            node.put(generationContext.getKeyword(SchemaKeyword.TAG_ITEMS_MAX), maxItemCount);
        }
        return this;
    }

    @Deprecated
    public AttributeCollector setArrayUniqueItems(ObjectNode node, Boolean uniqueItems) {
        if (uniqueItems != null) {
            node.put(SchemaKeyword.TAG_ITEMS_UNIQUE.forVersion(SchemaVersion.DRAFT_7), uniqueItems);
        }
        return this;
    }

    public AttributeCollector setArrayUniqueItems(ObjectNode node, Boolean uniqueItems, SchemaGenerationContext generationContext) {
        if (uniqueItems != null) {
            node.put(generationContext.getKeyword(SchemaKeyword.TAG_ITEMS_UNIQUE), uniqueItems);
        }
        return this;
    }
}

