/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.crs;

import java.time.temporal.Temporal;
import org.apache.sis.io.wkt.FormattableObject;
import org.apache.sis.io.wkt.Formatter;
import org.apache.sis.referencing.datum.DefaultGeodeticDatum;
import org.apache.sis.referencing.datum.DefaultVerticalDatum;
import org.apache.sis.referencing.internal.Epoch;
import org.opengis.referencing.datum.Datum;

final class DynamicCRS
extends FormattableObject {
    private final Temporal epoch;

    private DynamicCRS(Temporal epoch) {
        this.epoch = epoch;
    }

    static DynamicCRS createIfDynamic(Datum datum) {
        if (datum instanceof DefaultGeodeticDatum.Dynamic) {
            return new DynamicCRS(((DefaultGeodeticDatum.Dynamic)datum).getFrameReferenceEpoch());
        }
        if (datum instanceof DefaultVerticalDatum.Dynamic) {
            return new DynamicCRS(((DefaultVerticalDatum.Dynamic)datum).getFrameReferenceEpoch());
        }
        return null;
    }

    @Override
    protected String formatTo(Formatter formatter) {
        formatter.append(new Epoch(this.epoch, "FrameEpoch"));
        return "Dynamic";
    }
}

