/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.style.se1;

import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import org.apache.sis.filter.Expression;
import org.apache.sis.style.se1.Stroke;
import org.apache.sis.style.se1.StyleFactory;
import org.apache.sis.style.se1.Symbolizer;

@XmlType(name="LineSymbolizerType", propOrder={"stroke", "perpendicularOffset"})
@XmlRootElement(name="LineSymbolizer")
public class LineSymbolizer<R>
extends Symbolizer<R> {
    @XmlElement(name="Stroke")
    protected Stroke<R> stroke;
    @XmlElement(name="PerpendicularOffset")
    protected Expression<R, ? extends Number> perpendicularOffset;

    private LineSymbolizer() {
    }

    public LineSymbolizer(StyleFactory<R> factory) {
        super(factory);
    }

    public LineSymbolizer(LineSymbolizer<R> source) {
        super(source);
        this.stroke = source.stroke;
        this.perpendicularOffset = source.perpendicularOffset;
    }

    public Stroke<R> getStroke() {
        if (this.stroke == null) {
            this.stroke = this.factory.createStroke();
        }
        return this.stroke;
    }

    public void setStroke(Stroke<R> value) {
        this.stroke = value;
    }

    public Expression<R, ? extends Number> getPerpendicularOffset() {
        return this.defaultToZero(this.perpendicularOffset);
    }

    public void setPerpendicularOffset(Expression<R, ? extends Number> value) {
        this.perpendicularOffset = value;
    }

    @Override
    final Object[] properties() {
        return new Object[]{this.perpendicularOffset, this.stroke};
    }

    @Override
    public LineSymbolizer<R> clone() {
        LineSymbolizer clone = (LineSymbolizer)super.clone();
        clone.selfClone();
        return clone;
    }

    private void selfClone() {
        this.stroke = this.stroke.clone();
    }
}

