/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.cs;

import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import javax.measure.Unit;
import javax.measure.UnitConverter;
import javax.measure.quantity.Angle;
import org.apache.sis.io.wkt.Convention;
import org.apache.sis.io.wkt.ElementKind;
import org.apache.sis.io.wkt.FormattableObject;
import org.apache.sis.io.wkt.Formatter;
import org.apache.sis.measure.Units;
import org.apache.sis.metadata.internal.shared.ImplementationHelper;
import org.apache.sis.referencing.AbstractIdentifiedObject;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.referencing.cs.DirectionAlongMeridian;
import org.apache.sis.referencing.internal.shared.AxisDirections;
import org.apache.sis.referencing.internal.shared.NilReferencingObject;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.Utilities;
import org.apache.sis.util.collection.Containers;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.xml.bind.Context;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.RangeMeaning;
import org.opengis.referencing.cs.SphericalCS;
import org.opengis.util.CodeList;

@XmlType(name="CoordinateSystemAxisType", propOrder={"abbreviation", "direction", "minimum", "maximum", "rangeMeaning"})
@XmlRootElement(name="CoordinateSystemAxis")
public class DefaultCoordinateSystemAxis
extends AbstractIdentifiedObject
implements CoordinateSystemAxis {
    private static final long serialVersionUID = -7883614853277827689L;
    public static final String MINIMUM_VALUE_KEY = "minimumValue";
    public static final String MAXIMUM_VALUE_KEY = "maximumValue";
    public static final String RANGE_MEANING_KEY = "rangeMeaning";
    private static final Map<String, Object> ALIASES = Map.of("lat", Boolean.TRUE, "latitude", Boolean.TRUE, "geodetic latitude", Boolean.TRUE, "lon", Boolean.FALSE, "long", Boolean.FALSE, "longitude", Boolean.FALSE, "geodetic longitude", Boolean.FALSE);
    private static final String[] ALIASES_XY = new String[]{"Easting", "Northing", "Westing", "Southing"};
    private String abbreviation;
    private AxisDirection direction;
    private Unit<?> unit;
    private double minimumValue;
    private double maximumValue;
    private RangeMeaning rangeMeaning;

    private static Object getAliasType(String name) {
        return ALIASES.get(name.strip().toLowerCase(Locale.US));
    }

    public DefaultCoordinateSystemAxis(Map<String, ?> properties, String abbreviation, AxisDirection direction, Unit<?> unit) {
        super(properties);
        this.abbreviation = abbreviation;
        this.direction = direction;
        this.unit = unit;
        ArgumentChecks.ensureNonEmpty((String)"abbreviation", (CharSequence)abbreviation);
        ArgumentChecks.ensureNonNull((String)"direction", (Object)direction);
        ArgumentChecks.ensureNonNull((String)"unit", unit);
        Number minimum = (Number)Containers.property(properties, (Object)MINIMUM_VALUE_KEY, Number.class);
        Number maximum = (Number)Containers.property(properties, (Object)MAXIMUM_VALUE_KEY, Number.class);
        RangeMeaning rm = (RangeMeaning)Containers.property(properties, (Object)RANGE_MEANING_KEY, RangeMeaning.class);
        if (minimum == null && maximum == null && rm == null) {
            double min = Double.NEGATIVE_INFINITY;
            double max = Double.POSITIVE_INFINITY;
            if (Units.isAngular(unit)) {
                UnitConverter fromDegrees = Units.DEGREE.getConverterTo(unit.asType(Angle.class));
                AxisDirection dir = AxisDirections.absolute(direction);
                if (dir.equals((Object)AxisDirection.NORTH)) {
                    min = fromDegrees.convert(-90.0);
                    max = fromDegrees.convert(90.0);
                    rm = RangeMeaning.EXACT;
                } else if (dir.equals((Object)AxisDirection.EAST)) {
                    min = fromDegrees.convert(-180.0);
                    max = fromDegrees.convert(180.0);
                    rm = RangeMeaning.WRAPAROUND;
                }
                if (min > max) {
                    double t = min;
                    min = max;
                    max = t;
                }
            }
            this.minimumValue = min;
            this.maximumValue = max;
        } else {
            this.minimumValue = minimum != null ? minimum.doubleValue() : Double.NEGATIVE_INFINITY;
            double d = this.maximumValue = maximum != null ? maximum.doubleValue() : Double.POSITIVE_INFINITY;
            if (!(this.minimumValue < this.maximumValue)) {
                throw new IllegalArgumentException(Errors.forProperties(properties).getString((short)76, (Object)this.minimumValue, (Object)this.maximumValue));
            }
            if (this.minimumValue != Double.NEGATIVE_INFINITY || this.maximumValue != Double.POSITIVE_INFINITY) {
                ArgumentChecks.ensureNonNull((String)RANGE_MEANING_KEY, (Object)rm);
            } else {
                rm = null;
            }
        }
        this.rangeMeaning = rm;
    }

    protected DefaultCoordinateSystemAxis(CoordinateSystemAxis axis) {
        super((IdentifiedObject)axis);
        this.abbreviation = axis.getAbbreviation();
        this.direction = axis.getDirection();
        this.unit = axis.getUnit();
        this.minimumValue = axis.getMinimumValue();
        this.maximumValue = axis.getMaximumValue();
        this.rangeMeaning = axis.getRangeMeaning();
    }

    public static DefaultCoordinateSystemAxis castOrCopy(CoordinateSystemAxis object) {
        return object == null || object instanceof DefaultCoordinateSystemAxis ? (DefaultCoordinateSystemAxis)object : new DefaultCoordinateSystemAxis(object);
    }

    public Class<? extends CoordinateSystemAxis> getInterface() {
        return CoordinateSystemAxis.class;
    }

    @XmlElement(name="axisDirection", required=true)
    public AxisDirection getDirection() {
        return this.direction;
    }

    @XmlElement(name="axisAbbrev", required=true)
    public String getAbbreviation() {
        return this.abbreviation;
    }

    @XmlAttribute(name="uom", required=true)
    public Unit<?> getUnit() {
        return this.unit;
    }

    public double getMinimumValue() {
        return this.minimumValue;
    }

    public double getMaximumValue() {
        return this.maximumValue;
    }

    private static void outOfRange(String name, Double value) {
        Context.warningOccured((Context)Context.current(), DefaultCoordinateSystemAxis.class, (String)name, Errors.class, (short)85, (Object[])new Object[]{name, value});
    }

    @XmlElement(name="rangeMeaning")
    public RangeMeaning getRangeMeaning() {
        return this.rangeMeaning;
    }

    @Override
    public boolean isHeuristicMatchForName(String name) {
        if (super.isHeuristicMatchForName(name)) {
            return true;
        }
        Object type = DefaultCoordinateSystemAxis.getAliasType(name);
        return type != null && type == DefaultCoordinateSystemAxis.getAliasType(this.getName().getCode());
    }

    private static boolean isHeuristicMatchForNameXY(String xy, String name) {
        int i;
        if ((xy = xy.strip()).length() == 1 && (i = Character.toLowerCase(xy.charAt(0)) - 120) >= 0 && i <= 1 && !(name = name.strip()).isEmpty()) {
            do {
                if (!name.regionMatches(true, 0, ALIASES_XY[i], 0, name.length())) continue;
                return true;
            } while ((i += 2) < ALIASES_XY.length);
        }
        return false;
    }

    private boolean equalsIgnoreMetadata(CoordinateSystemAxis that, ComparisonMode mode, boolean cr) {
        return Objects.equals(this.getDirection(), that.getDirection()) && Utilities.deepEquals(this.getUnit(), (Object)that.getUnit(), (ComparisonMode)mode) && (!cr || Double.doubleToLongBits(this.getMinimumValue()) == Double.doubleToLongBits(that.getMinimumValue()) && Double.doubleToLongBits(this.getMaximumValue()) == Double.doubleToLongBits(that.getMaximumValue()));
    }

    @Override
    public boolean equals(Object object, ComparisonMode mode) {
        String thisCode;
        String thatCode;
        if (object == this) {
            return true;
        }
        if (!super.equals(object, mode)) {
            return false;
        }
        switch (mode) {
            case STRICT: {
                DefaultCoordinateSystemAxis that = (DefaultCoordinateSystemAxis)object;
                return Objects.equals(this.unit, that.unit) && Objects.equals(this.direction, that.direction) && Objects.equals(this.abbreviation, that.abbreviation) && Objects.equals(this.rangeMeaning, that.rangeMeaning) && Double.doubleToLongBits(this.minimumValue) == Double.doubleToLongBits(that.minimumValue) && Double.doubleToLongBits(this.maximumValue) == Double.doubleToLongBits(that.maximumValue);
            }
            case BY_CONTRACT: {
                CoordinateSystemAxis that = (CoordinateSystemAxis)object;
                return this.equalsIgnoreMetadata(that, mode, true) && Objects.equals(this.getAbbreviation(), that.getAbbreviation()) && Objects.equals(this.getRangeMeaning(), that.getRangeMeaning());
            }
        }
        CoordinateSystemAxis that = (CoordinateSystemAxis)object;
        if (!this.equalsIgnoreMetadata(that, mode, this.getRangeMeaning() == RangeMeaning.WRAPAROUND && that.getRangeMeaning() == RangeMeaning.WRAPAROUND)) {
            return false;
        }
        ReferenceIdentifier name = that.getName();
        return name == NilReferencingObject.UNNAMED || this.isHeuristicMatchForName(thatCode = name.getCode()) || (name = this.getName()) == NilReferencingObject.UNNAMED || IdentifiedObjects.isHeuristicMatchForName((IdentifiedObject)that, thisCode = name.getCode()) || DefaultCoordinateSystemAxis.isHeuristicMatchForNameXY(thatCode, thisCode) || DefaultCoordinateSystemAxis.isHeuristicMatchForNameXY(thisCode, thatCode);
    }

    @Override
    protected long computeHashCode() {
        return super.computeHashCode() + (long)Objects.hashCode(this.unit) + (long)Objects.hashCode(this.direction) + Double.doubleToLongBits(this.minimumValue) + 31L * Double.doubleToLongBits(this.maximumValue);
    }

    private static CoordinateSystem getEnclosingCS(Formatter formatter) {
        FormattableObject e = formatter.getEnclosingElement(1);
        if (e instanceof CoordinateReferenceSystem) {
            return ((CoordinateReferenceSystem)e).getCoordinateSystem();
        }
        if (e instanceof CoordinateSystem) {
            return (CoordinateSystem)e;
        }
        return null;
    }

    @Override
    protected String formatTo(Formatter formatter) {
        String a;
        Convention convention = formatter.getConvention();
        boolean isWKT1 = convention.majorVersion() == 1;
        boolean isInternal = convention == Convention.INTERNAL;
        CoordinateSystem cs = DefaultCoordinateSystemAxis.getEnclosingCS(formatter);
        AxisDirection dir = this.getDirection();
        String name = IdentifiedObjects.getName(this, formatter.getNameAuthority());
        if (name == null) {
            name = IdentifiedObjects.getName(this, null);
        }
        if (name != null && !isInternal) {
            String old = name;
            name = formatter.getTransliterator().toShortAxisName(cs, dir, name);
            if (name == null && isWKT1) {
                name = old;
            }
        }
        if (!isWKT1 && (a = formatter.getTransliterator().toLatinAbbreviation(cs, dir, this.getAbbreviation())) != null && !a.equals(name)) {
            StringBuilder buffer = new StringBuilder();
            if (name != null) {
                buffer.append(name).append(' ');
            }
            name = buffer.append('(').append(a).append(')').toString();
        }
        formatter.append(name, ElementKind.AXIS);
        DirectionAlongMeridian meridian = null;
        if (AxisDirections.isUserDefined(dir) && (meridian = DirectionAlongMeridian.parse(dir)) != null) {
            dir = meridian.baseDirection;
            if (isWKT1) {
                formatter.setInvalidWKT(this, null);
            }
        }
        formatter.append((CodeList<?>)dir);
        formatter.append(meridian);
        if (!isWKT1) {
            if (cs != null && !convention.isSimplified()) {
                Child order = Child.order(cs, this);
                if (order != null) {
                    formatter.append(order);
                } else {
                    formatter.setInvalidWKT((IdentifiedObject)cs, null);
                }
            }
            if (!formatter.hasContextualUnit(1)) {
                formatter.append(this.getUnit());
            }
            if (convention.supports(Convention.WKT2_2019)) {
                boolean standard = false;
                if (convention.isSimplified()) {
                    dir = AxisDirections.absolute(dir);
                    if (Units.DEGREE.equals(this.unit)) {
                        if (dir.equals((Object)AxisDirection.NORTH)) {
                            standard = this.minimumValue == -90.0 && this.maximumValue == 90.0 && this.rangeMeaning == RangeMeaning.EXACT;
                        } else if (dir.equals((Object)AxisDirection.EAST)) {
                            standard = this.minimumValue == -180.0 && this.maximumValue == 180.0 && this.rangeMeaning == RangeMeaning.WRAPAROUND;
                        }
                    } else if (Units.isLinear(this.unit) && cs instanceof SphericalCS && dir.equals((Object)AxisDirection.UP)) {
                        boolean bl = standard = this.minimumValue == 0.0 && this.maximumValue == Double.POSITIVE_INFINITY && this.rangeMeaning == RangeMeaning.EXACT;
                    }
                }
                if (!standard) {
                    Child min = Child.range(this.getMinimumValue(), false);
                    Child max = Child.range(this.getMaximumValue(), true);
                    if (min != null || max != null) {
                        formatter.append(min);
                        formatter.append(max);
                        formatter.append(Child.range(this.getRangeMeaning()));
                    }
                }
            }
        }
        return "Axis";
    }

    private DefaultCoordinateSystemAxis() {
        super((IdentifiedObject)NilReferencingObject.INSTANCE);
        this.minimumValue = Double.NEGATIVE_INFINITY;
        this.maximumValue = Double.POSITIVE_INFINITY;
    }

    private void setAbbreviation(String value) {
        if (this.abbreviation == null) {
            this.abbreviation = value;
        } else {
            ImplementationHelper.propertyAlreadySet(DefaultCoordinateSystemAxis.class, (String)"setAbbreviation", (String)"abbreviation");
        }
    }

    private void setDirection(AxisDirection value) {
        if (this.direction == null) {
            this.direction = value;
        } else {
            ImplementationHelper.propertyAlreadySet(DefaultCoordinateSystemAxis.class, (String)"setDirection", (String)"direction");
        }
    }

    private void setUnit(Unit<?> value) {
        if (this.unit == null) {
            this.unit = value;
        } else {
            ImplementationHelper.propertyAlreadySet(DefaultCoordinateSystemAxis.class, (String)"setUnit", (String)"unit");
        }
    }

    private void setRangeMeaning(RangeMeaning value) {
        if (this.rangeMeaning == null) {
            this.rangeMeaning = value;
        } else {
            ImplementationHelper.propertyAlreadySet(DefaultCoordinateSystemAxis.class, (String)"setRangeMeaning", (String)RANGE_MEANING_KEY);
        }
    }

    @XmlElement(name="minimumValue")
    private Double getMinimum() {
        return this.minimumValue != Double.NEGATIVE_INFINITY ? Double.valueOf(this.minimumValue) : null;
    }

    private void setMinimum(Double value) {
        if (this.minimumValue == Double.NEGATIVE_INFINITY) {
            double min = value;
            if (min < this.maximumValue) {
                this.minimumValue = min;
            } else {
                DefaultCoordinateSystemAxis.outOfRange(MINIMUM_VALUE_KEY, value);
            }
        } else {
            ImplementationHelper.propertyAlreadySet(DefaultCoordinateSystemAxis.class, (String)"setMinimum", (String)MINIMUM_VALUE_KEY);
        }
    }

    @XmlElement(name="maximumValue")
    private Double getMaximum() {
        return this.maximumValue != Double.POSITIVE_INFINITY ? Double.valueOf(this.maximumValue) : null;
    }

    private void setMaximum(Double value) {
        if (this.maximumValue == Double.POSITIVE_INFINITY) {
            double max = value;
            if (max > this.minimumValue) {
                this.maximumValue = max;
            } else {
                DefaultCoordinateSystemAxis.outOfRange(MAXIMUM_VALUE_KEY, value);
            }
        } else {
            ImplementationHelper.propertyAlreadySet(DefaultCoordinateSystemAxis.class, (String)"setMaximum", (String)MAXIMUM_VALUE_KEY);
        }
    }

    private static final class Child
    extends FormattableObject {
        private final String keyword;
        private final Object value;

        static Child order(CoordinateSystem cs, DefaultCoordinateSystemAxis axis) {
            Child order = null;
            int dimension = cs.getDimension();
            int i = 0;
            while (i < dimension) {
                if (cs.getAxis(i++) != axis) continue;
                if (order == null) {
                    order = new Child("Order", i);
                    continue;
                }
                return null;
            }
            return order;
        }

        static Child range(double value, boolean isMax) {
            if (Double.isFinite(value)) {
                return new Child(isMax ? "AxisMaxValue" : "AxisMinValue", value);
            }
            return null;
        }

        static Child range(RangeMeaning value) {
            return value != null ? new Child("RangeMeaning", value) : null;
        }

        private Child(String keyword, Object value) {
            this.keyword = keyword;
            this.value = value;
        }

        @Override
        protected String formatTo(Formatter formatter) {
            formatter.appendAny(this.value);
            return this.keyword;
        }
    }
}

