/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.autoscaling.v2;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.autoscaling.v2.HorizontalPodAutoscalerCondition;
import io.fabric8.kubernetes.api.model.autoscaling.v2.HorizontalPodAutoscalerConditionBuilder;
import io.fabric8.kubernetes.api.model.autoscaling.v2.HorizontalPodAutoscalerConditionFluentImpl;
import io.fabric8.kubernetes.api.model.autoscaling.v2.HorizontalPodAutoscalerStatus;
import io.fabric8.kubernetes.api.model.autoscaling.v2.HorizontalPodAutoscalerStatusFluent;
import io.fabric8.kubernetes.api.model.autoscaling.v2.MetricStatus;
import io.fabric8.kubernetes.api.model.autoscaling.v2.MetricStatusBuilder;
import io.fabric8.kubernetes.api.model.autoscaling.v2.MetricStatusFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class HorizontalPodAutoscalerStatusFluentImpl<A extends HorizontalPodAutoscalerStatusFluent<A>>
extends BaseFluent<A>
implements HorizontalPodAutoscalerStatusFluent<A> {
    private ArrayList<HorizontalPodAutoscalerConditionBuilder> conditions = new ArrayList();
    private ArrayList<MetricStatusBuilder> currentMetrics = new ArrayList();
    private Integer currentReplicas;
    private Integer desiredReplicas;
    private String lastScaleTime;
    private Long observedGeneration;
    private Map<String, Object> additionalProperties;

    public HorizontalPodAutoscalerStatusFluentImpl() {
    }

    public HorizontalPodAutoscalerStatusFluentImpl(HorizontalPodAutoscalerStatus instance) {
        if (instance != null) {
            this.withConditions(instance.getConditions());
            this.withCurrentMetrics(instance.getCurrentMetrics());
            this.withCurrentReplicas(instance.getCurrentReplicas());
            this.withDesiredReplicas(instance.getDesiredReplicas());
            this.withLastScaleTime(instance.getLastScaleTime());
            this.withObservedGeneration(instance.getObservedGeneration());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    @Override
    public A addToConditions(int index, HorizontalPodAutoscalerCondition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        HorizontalPodAutoscalerConditionBuilder builder = new HorizontalPodAutoscalerConditionBuilder(item);
        if (index < 0 || index >= this.conditions.size()) {
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(builder);
        } else {
            this._visitables.get((Object)"conditions").add(index, builder);
            this.conditions.add(index, builder);
        }
        return (A)this;
    }

    @Override
    public A setToConditions(int index, HorizontalPodAutoscalerCondition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        HorizontalPodAutoscalerConditionBuilder builder = new HorizontalPodAutoscalerConditionBuilder(item);
        if (index < 0 || index >= this.conditions.size()) {
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(builder);
        } else {
            this._visitables.get((Object)"conditions").set(index, builder);
            this.conditions.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToConditions(HorizontalPodAutoscalerCondition ... items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        for (HorizontalPodAutoscalerCondition item : items) {
            HorizontalPodAutoscalerConditionBuilder builder = new HorizontalPodAutoscalerConditionBuilder(item);
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToConditions(Collection<HorizontalPodAutoscalerCondition> items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        for (HorizontalPodAutoscalerCondition item : items) {
            HorizontalPodAutoscalerConditionBuilder builder = new HorizontalPodAutoscalerConditionBuilder(item);
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromConditions(HorizontalPodAutoscalerCondition ... items) {
        for (HorizontalPodAutoscalerCondition item : items) {
            HorizontalPodAutoscalerConditionBuilder builder = new HorizontalPodAutoscalerConditionBuilder(item);
            this._visitables.get((Object)"conditions").remove(builder);
            if (this.conditions == null) continue;
            this.conditions.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromConditions(Collection<HorizontalPodAutoscalerCondition> items) {
        for (HorizontalPodAutoscalerCondition item : items) {
            HorizontalPodAutoscalerConditionBuilder builder = new HorizontalPodAutoscalerConditionBuilder(item);
            this._visitables.get((Object)"conditions").remove(builder);
            if (this.conditions == null) continue;
            this.conditions.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromConditions(Predicate<HorizontalPodAutoscalerConditionBuilder> predicate) {
        if (this.conditions == null) {
            return (A)this;
        }
        Iterator<HorizontalPodAutoscalerConditionBuilder> each = this.conditions.iterator();
        List visitables = this._visitables.get((Object)"conditions");
        while (each.hasNext()) {
            HorizontalPodAutoscalerConditionBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<HorizontalPodAutoscalerCondition> getConditions() {
        return this.conditions != null ? HorizontalPodAutoscalerStatusFluentImpl.build(this.conditions) : null;
    }

    @Override
    public List<HorizontalPodAutoscalerCondition> buildConditions() {
        return this.conditions != null ? HorizontalPodAutoscalerStatusFluentImpl.build(this.conditions) : null;
    }

    @Override
    public HorizontalPodAutoscalerCondition buildCondition(int index) {
        return this.conditions.get(index).build();
    }

    @Override
    public HorizontalPodAutoscalerCondition buildFirstCondition() {
        return this.conditions.get(0).build();
    }

    @Override
    public HorizontalPodAutoscalerCondition buildLastCondition() {
        return this.conditions.get(this.conditions.size() - 1).build();
    }

    @Override
    public HorizontalPodAutoscalerCondition buildMatchingCondition(Predicate<HorizontalPodAutoscalerConditionBuilder> predicate) {
        for (HorizontalPodAutoscalerConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingCondition(Predicate<HorizontalPodAutoscalerConditionBuilder> predicate) {
        for (HorizontalPodAutoscalerConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withConditions(List<HorizontalPodAutoscalerCondition> conditions) {
        if (this.conditions != null) {
            this._visitables.get((Object)"conditions").clear();
        }
        if (conditions != null) {
            this.conditions = new ArrayList();
            for (HorizontalPodAutoscalerCondition item : conditions) {
                this.addToConditions(item);
            }
        } else {
            this.conditions = null;
        }
        return (A)this;
    }

    @Override
    public A withConditions(HorizontalPodAutoscalerCondition ... conditions) {
        if (this.conditions != null) {
            this.conditions.clear();
            this._visitables.remove((Object)"conditions");
        }
        if (conditions != null) {
            for (HorizontalPodAutoscalerCondition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasConditions() {
        return this.conditions != null && !this.conditions.isEmpty();
    }

    @Override
    public A addNewCondition(String lastTransitionTime, String message, String reason, String status, String type) {
        return this.addToConditions(new HorizontalPodAutoscalerCondition(lastTransitionTime, message, reason, status, type));
    }

    @Override
    public HorizontalPodAutoscalerStatusFluent.ConditionsNested<A> addNewCondition() {
        return new ConditionsNestedImpl();
    }

    @Override
    public HorizontalPodAutoscalerStatusFluent.ConditionsNested<A> addNewConditionLike(HorizontalPodAutoscalerCondition item) {
        return new ConditionsNestedImpl(-1, item);
    }

    @Override
    public HorizontalPodAutoscalerStatusFluent.ConditionsNested<A> setNewConditionLike(int index, HorizontalPodAutoscalerCondition item) {
        return new ConditionsNestedImpl(index, item);
    }

    @Override
    public HorizontalPodAutoscalerStatusFluent.ConditionsNested<A> editCondition(int index) {
        if (this.conditions.size() <= index) {
            throw new RuntimeException("Can't edit conditions. Index exceeds size.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    @Override
    public HorizontalPodAutoscalerStatusFluent.ConditionsNested<A> editFirstCondition() {
        if (this.conditions.size() == 0) {
            throw new RuntimeException("Can't edit first conditions. The list is empty.");
        }
        return this.setNewConditionLike(0, this.buildCondition(0));
    }

    @Override
    public HorizontalPodAutoscalerStatusFluent.ConditionsNested<A> editLastCondition() {
        int index = this.conditions.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last conditions. The list is empty.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    @Override
    public HorizontalPodAutoscalerStatusFluent.ConditionsNested<A> editMatchingCondition(Predicate<HorizontalPodAutoscalerConditionBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.conditions.size(); ++i) {
            if (!predicate.test(this.conditions.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching conditions. No match found.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    @Override
    public A addToCurrentMetrics(int index, MetricStatus item) {
        if (this.currentMetrics == null) {
            this.currentMetrics = new ArrayList();
        }
        MetricStatusBuilder builder = new MetricStatusBuilder(item);
        if (index < 0 || index >= this.currentMetrics.size()) {
            this._visitables.get((Object)"currentMetrics").add(builder);
            this.currentMetrics.add(builder);
        } else {
            this._visitables.get((Object)"currentMetrics").add(index, builder);
            this.currentMetrics.add(index, builder);
        }
        return (A)this;
    }

    @Override
    public A setToCurrentMetrics(int index, MetricStatus item) {
        if (this.currentMetrics == null) {
            this.currentMetrics = new ArrayList();
        }
        MetricStatusBuilder builder = new MetricStatusBuilder(item);
        if (index < 0 || index >= this.currentMetrics.size()) {
            this._visitables.get((Object)"currentMetrics").add(builder);
            this.currentMetrics.add(builder);
        } else {
            this._visitables.get((Object)"currentMetrics").set(index, builder);
            this.currentMetrics.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToCurrentMetrics(MetricStatus ... items) {
        if (this.currentMetrics == null) {
            this.currentMetrics = new ArrayList();
        }
        for (MetricStatus item : items) {
            MetricStatusBuilder builder = new MetricStatusBuilder(item);
            this._visitables.get((Object)"currentMetrics").add(builder);
            this.currentMetrics.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToCurrentMetrics(Collection<MetricStatus> items) {
        if (this.currentMetrics == null) {
            this.currentMetrics = new ArrayList();
        }
        for (MetricStatus item : items) {
            MetricStatusBuilder builder = new MetricStatusBuilder(item);
            this._visitables.get((Object)"currentMetrics").add(builder);
            this.currentMetrics.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromCurrentMetrics(MetricStatus ... items) {
        for (MetricStatus item : items) {
            MetricStatusBuilder builder = new MetricStatusBuilder(item);
            this._visitables.get((Object)"currentMetrics").remove(builder);
            if (this.currentMetrics == null) continue;
            this.currentMetrics.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromCurrentMetrics(Collection<MetricStatus> items) {
        for (MetricStatus item : items) {
            MetricStatusBuilder builder = new MetricStatusBuilder(item);
            this._visitables.get((Object)"currentMetrics").remove(builder);
            if (this.currentMetrics == null) continue;
            this.currentMetrics.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromCurrentMetrics(Predicate<MetricStatusBuilder> predicate) {
        if (this.currentMetrics == null) {
            return (A)this;
        }
        Iterator<MetricStatusBuilder> each = this.currentMetrics.iterator();
        List visitables = this._visitables.get((Object)"currentMetrics");
        while (each.hasNext()) {
            MetricStatusBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<MetricStatus> getCurrentMetrics() {
        return this.currentMetrics != null ? HorizontalPodAutoscalerStatusFluentImpl.build(this.currentMetrics) : null;
    }

    @Override
    public List<MetricStatus> buildCurrentMetrics() {
        return this.currentMetrics != null ? HorizontalPodAutoscalerStatusFluentImpl.build(this.currentMetrics) : null;
    }

    @Override
    public MetricStatus buildCurrentMetric(int index) {
        return this.currentMetrics.get(index).build();
    }

    @Override
    public MetricStatus buildFirstCurrentMetric() {
        return this.currentMetrics.get(0).build();
    }

    @Override
    public MetricStatus buildLastCurrentMetric() {
        return this.currentMetrics.get(this.currentMetrics.size() - 1).build();
    }

    @Override
    public MetricStatus buildMatchingCurrentMetric(Predicate<MetricStatusBuilder> predicate) {
        for (MetricStatusBuilder item : this.currentMetrics) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingCurrentMetric(Predicate<MetricStatusBuilder> predicate) {
        for (MetricStatusBuilder item : this.currentMetrics) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withCurrentMetrics(List<MetricStatus> currentMetrics) {
        if (this.currentMetrics != null) {
            this._visitables.get((Object)"currentMetrics").clear();
        }
        if (currentMetrics != null) {
            this.currentMetrics = new ArrayList();
            for (MetricStatus item : currentMetrics) {
                this.addToCurrentMetrics(item);
            }
        } else {
            this.currentMetrics = null;
        }
        return (A)this;
    }

    @Override
    public A withCurrentMetrics(MetricStatus ... currentMetrics) {
        if (this.currentMetrics != null) {
            this.currentMetrics.clear();
            this._visitables.remove((Object)"currentMetrics");
        }
        if (currentMetrics != null) {
            for (MetricStatus item : currentMetrics) {
                this.addToCurrentMetrics(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasCurrentMetrics() {
        return this.currentMetrics != null && !this.currentMetrics.isEmpty();
    }

    @Override
    public HorizontalPodAutoscalerStatusFluent.CurrentMetricsNested<A> addNewCurrentMetric() {
        return new CurrentMetricsNestedImpl();
    }

    @Override
    public HorizontalPodAutoscalerStatusFluent.CurrentMetricsNested<A> addNewCurrentMetricLike(MetricStatus item) {
        return new CurrentMetricsNestedImpl(-1, item);
    }

    @Override
    public HorizontalPodAutoscalerStatusFluent.CurrentMetricsNested<A> setNewCurrentMetricLike(int index, MetricStatus item) {
        return new CurrentMetricsNestedImpl(index, item);
    }

    @Override
    public HorizontalPodAutoscalerStatusFluent.CurrentMetricsNested<A> editCurrentMetric(int index) {
        if (this.currentMetrics.size() <= index) {
            throw new RuntimeException("Can't edit currentMetrics. Index exceeds size.");
        }
        return this.setNewCurrentMetricLike(index, this.buildCurrentMetric(index));
    }

    @Override
    public HorizontalPodAutoscalerStatusFluent.CurrentMetricsNested<A> editFirstCurrentMetric() {
        if (this.currentMetrics.size() == 0) {
            throw new RuntimeException("Can't edit first currentMetrics. The list is empty.");
        }
        return this.setNewCurrentMetricLike(0, this.buildCurrentMetric(0));
    }

    @Override
    public HorizontalPodAutoscalerStatusFluent.CurrentMetricsNested<A> editLastCurrentMetric() {
        int index = this.currentMetrics.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last currentMetrics. The list is empty.");
        }
        return this.setNewCurrentMetricLike(index, this.buildCurrentMetric(index));
    }

    @Override
    public HorizontalPodAutoscalerStatusFluent.CurrentMetricsNested<A> editMatchingCurrentMetric(Predicate<MetricStatusBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.currentMetrics.size(); ++i) {
            if (!predicate.test(this.currentMetrics.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching currentMetrics. No match found.");
        }
        return this.setNewCurrentMetricLike(index, this.buildCurrentMetric(index));
    }

    @Override
    public Integer getCurrentReplicas() {
        return this.currentReplicas;
    }

    @Override
    public A withCurrentReplicas(Integer currentReplicas) {
        this.currentReplicas = currentReplicas;
        return (A)this;
    }

    @Override
    public Boolean hasCurrentReplicas() {
        return this.currentReplicas != null;
    }

    @Override
    public Integer getDesiredReplicas() {
        return this.desiredReplicas;
    }

    @Override
    public A withDesiredReplicas(Integer desiredReplicas) {
        this.desiredReplicas = desiredReplicas;
        return (A)this;
    }

    @Override
    public Boolean hasDesiredReplicas() {
        return this.desiredReplicas != null;
    }

    @Override
    public String getLastScaleTime() {
        return this.lastScaleTime;
    }

    @Override
    public A withLastScaleTime(String lastScaleTime) {
        this.lastScaleTime = lastScaleTime;
        return (A)this;
    }

    @Override
    public Boolean hasLastScaleTime() {
        return this.lastScaleTime != null;
    }

    @Override
    public Long getObservedGeneration() {
        return this.observedGeneration;
    }

    @Override
    public A withObservedGeneration(Long observedGeneration) {
        this.observedGeneration = observedGeneration;
        return (A)this;
    }

    @Override
    public Boolean hasObservedGeneration() {
        return this.observedGeneration != null;
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        HorizontalPodAutoscalerStatusFluentImpl that = (HorizontalPodAutoscalerStatusFluentImpl)o;
        if (!Objects.equals(this.conditions, that.conditions)) {
            return false;
        }
        if (!Objects.equals(this.currentMetrics, that.currentMetrics)) {
            return false;
        }
        if (!Objects.equals(this.currentReplicas, that.currentReplicas)) {
            return false;
        }
        if (!Objects.equals(this.desiredReplicas, that.desiredReplicas)) {
            return false;
        }
        if (!Objects.equals(this.lastScaleTime, that.lastScaleTime)) {
            return false;
        }
        if (!Objects.equals(this.observedGeneration, that.observedGeneration)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.conditions, this.currentMetrics, this.currentReplicas, this.desiredReplicas, this.lastScaleTime, this.observedGeneration, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.conditions != null) {
            sb.append("conditions:");
            sb.append(this.conditions + ",");
        }
        if (this.currentMetrics != null) {
            sb.append("currentMetrics:");
            sb.append(this.currentMetrics + ",");
        }
        if (this.currentReplicas != null) {
            sb.append("currentReplicas:");
            sb.append(this.currentReplicas + ",");
        }
        if (this.desiredReplicas != null) {
            sb.append("desiredReplicas:");
            sb.append(this.desiredReplicas + ",");
        }
        if (this.lastScaleTime != null) {
            sb.append("lastScaleTime:");
            sb.append(this.lastScaleTime + ",");
        }
        if (this.observedGeneration != null) {
            sb.append("observedGeneration:");
            sb.append(this.observedGeneration + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    class CurrentMetricsNestedImpl<N>
    extends MetricStatusFluentImpl<HorizontalPodAutoscalerStatusFluent.CurrentMetricsNested<N>>
    implements HorizontalPodAutoscalerStatusFluent.CurrentMetricsNested<N>,
    Nested<N> {
        MetricStatusBuilder builder;
        int index;

        CurrentMetricsNestedImpl(int index, MetricStatus item) {
            this.index = index;
            this.builder = new MetricStatusBuilder(this, item);
        }

        CurrentMetricsNestedImpl() {
            this.index = -1;
            this.builder = new MetricStatusBuilder(this);
        }

        @Override
        public N and() {
            return (N)HorizontalPodAutoscalerStatusFluentImpl.this.setToCurrentMetrics(this.index, this.builder.build());
        }

        @Override
        public N endCurrentMetric() {
            return this.and();
        }
    }

    class ConditionsNestedImpl<N>
    extends HorizontalPodAutoscalerConditionFluentImpl<HorizontalPodAutoscalerStatusFluent.ConditionsNested<N>>
    implements HorizontalPodAutoscalerStatusFluent.ConditionsNested<N>,
    Nested<N> {
        HorizontalPodAutoscalerConditionBuilder builder;
        int index;

        ConditionsNestedImpl(int index, HorizontalPodAutoscalerCondition item) {
            this.index = index;
            this.builder = new HorizontalPodAutoscalerConditionBuilder(this, item);
        }

        ConditionsNestedImpl() {
            this.index = -1;
            this.builder = new HorizontalPodAutoscalerConditionBuilder(this);
        }

        @Override
        public N and() {
            return (N)HorizontalPodAutoscalerStatusFluentImpl.this.setToConditions(this.index, this.builder.build());
        }

        @Override
        public N endCondition() {
            return this.and();
        }
    }
}

