/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server;

import com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import java.net.InetSocketAddress;
import java.util.List;
import java.util.Objects;

public final class ProxiedAddresses {
    private final InetSocketAddress sourceAddress;
    private final List<InetSocketAddress> destinationAddresses;

    public static ProxiedAddresses of(InetSocketAddress sourceAddress) {
        return new ProxiedAddresses(sourceAddress, ImmutableList.of());
    }

    public static ProxiedAddresses of(InetSocketAddress sourceAddress, InetSocketAddress destinationAddress) {
        Objects.requireNonNull(destinationAddress, "destinationAddress");
        return new ProxiedAddresses(sourceAddress, ImmutableList.of(destinationAddress));
    }

    public static ProxiedAddresses of(InetSocketAddress sourceAddress, Iterable<? extends InetSocketAddress> destinationAddresses) {
        Objects.requireNonNull(destinationAddresses, "destinationAddresses");
        return new ProxiedAddresses(sourceAddress, ImmutableList.copyOf(destinationAddresses));
    }

    private ProxiedAddresses(InetSocketAddress sourceAddress, List<InetSocketAddress> destinationAddresses) {
        this.sourceAddress = Objects.requireNonNull(sourceAddress, "sourceAddress");
        this.destinationAddresses = Objects.requireNonNull(destinationAddresses, "destinationAddresses");
    }

    public InetSocketAddress sourceAddress() {
        return this.sourceAddress;
    }

    public List<InetSocketAddress> destinationAddresses() {
        return this.destinationAddresses;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ProxiedAddresses)) {
            return false;
        }
        ProxiedAddresses that = (ProxiedAddresses)o;
        return this.sourceAddress.equals(that.sourceAddress) && this.destinationAddresses.equals(that.destinationAddresses);
    }

    public int hashCode() {
        return this.sourceAddress.hashCode() * 31 + this.destinationAddresses.hashCode();
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("sourceAddress", this.sourceAddress).add("destinationAddress", this.destinationAddresses).toString();
    }
}

