/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.resource.internal;

import java.util.Collections;
import java.util.HashSet;
import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.NodeType;
import org.apache.jackrabbit.api.JackrabbitNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class NodeUtil {
    private NodeUtil() {
    }

    public static void handleMixinTypes(@NotNull Node node, @Nullable String[] mixinTypes) throws RepositoryException {
        HashSet newTypes = new HashSet();
        if (mixinTypes != null) {
            Collections.addAll(newTypes, mixinTypes);
        }
        HashSet<String> oldTypes = new HashSet<String>();
        for (NodeType mixinType : node.getMixinNodeTypes()) {
            oldTypes.add(mixinType.getName());
        }
        for (String name : oldTypes) {
            if (!newTypes.contains(name)) {
                node.removeMixin(name);
                continue;
            }
            newTypes.remove(name);
        }
        for (String name : newTypes) {
            node.addMixin(name);
        }
    }

    @NotNull
    public static Property getPrimaryProperty(@NotNull Node node) throws RepositoryException {
        Property data;
        Node content = node.isNodeType("{http://www.jcp.org/jcr/nt/1.0}file") || node.isNodeType("{http://www.jcp.org/jcr/nt/1.0}frozenNode") && node.getProperty("{http://www.jcp.org/jcr/1.0}frozenPrimaryType").getString().equals("{http://www.jcp.org/jcr/nt/1.0}file") ? node.getNode("{http://www.jcp.org/jcr/1.0}content") : (node.isNodeType("{http://www.jcp.org/jcr/nt/1.0}linkedFile") ? node.getProperty("{http://www.jcp.org/jcr/1.0}content").getNode() : node);
        Property property = NodeUtil.getPropertyOrNull(content, "{http://www.jcp.org/jcr/1.0}data");
        if (property != null) {
            data = property;
        } else {
            Item item = content.getPrimaryItem();
            while (item.isNode()) {
                item = ((Node)item).getPrimaryItem();
            }
            data = (Property)item;
        }
        return data;
    }

    @Nullable
    public static Property getPropertyOrNull(@NotNull Node node, @NotNull String propertyName) throws RepositoryException {
        if (node instanceof JackrabbitNode) {
            JackrabbitNode jnode = (JackrabbitNode)node;
            return jnode.getPropertyOrNull(propertyName);
        }
        if (node.hasProperty(propertyName)) {
            return node.getProperty(propertyName);
        }
        return null;
    }

    @Nullable
    public static Node getNodeOrNull(@NotNull Node node, @NotNull String childNode) throws RepositoryException {
        if (node instanceof JackrabbitNode) {
            JackrabbitNode jnode = (JackrabbitNode)node;
            return jnode.getNodeOrNull(childNode);
        }
        if (node.hasNode(childNode)) {
            return node.getNode(childNode);
        }
        return null;
    }
}

