/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hive.execution;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFUtils;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDTF;
import org.apache.hadoop.hive.serde2.objectinspector.ConstantObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.io.IntWritable;

@Description(name="stack", value="_FUNC_(n, cols...) - turns k columns into n rows of size k/n each")
public class UDTFStack2
extends GenericUDTF {
    private transient List<ObjectInspector> argOIs = new ArrayList<ObjectInspector>();
    private transient Object[] forwardObj = null;
    private transient ArrayList<GenericUDFUtils.ReturnObjectInspectorResolver> returnOIResolvers = new ArrayList();
    IntWritable numRows = null;
    Integer numCols = null;

    public void close() throws HiveException {
    }

    public StructObjectInspector initialize(StructObjectInspector argOIs) throws UDFArgumentException {
        List inputFields = argOIs.getAllStructFieldRefs();
        ObjectInspector[] udtfInputOIs = new ObjectInspector[inputFields.size()];
        for (int i = 0; i < inputFields.size(); ++i) {
            udtfInputOIs[i] = ((StructField)inputFields.get(i)).getFieldObjectInspector();
        }
        return this.initialize2(udtfInputOIs);
    }

    public StructObjectInspector initialize2(ObjectInspector[] args) throws UDFArgumentException {
        if (args.length < 2) {
            throw new UDFArgumentException("STACK() expects at least two arguments.");
        }
        if (!(args[0] instanceof ConstantObjectInspector)) {
            throw new UDFArgumentException("The first argument to STACK() must be a constant integer (got " + args[0].getTypeName() + " instead).");
        }
        this.numRows = (IntWritable)((ConstantObjectInspector)args[0]).getWritableConstantValue();
        if (this.numRows == null || this.numRows.get() < 1) {
            throw new UDFArgumentException("STACK() expects its first argument to be >= 1.");
        }
        this.numCols = (args.length - 1 + this.numRows.get() - 1) / this.numRows.get();
        for (int jj = 0; jj < this.numCols; ++jj) {
            this.returnOIResolvers.add(new GenericUDFUtils.ReturnObjectInspectorResolver());
            for (int ii = 0; ii < this.numRows.get(); ++ii) {
                int index = ii * this.numCols + jj + 1;
                if (index >= args.length || this.returnOIResolvers.get(jj).update(args[index])) continue;
                throw new UDFArgumentException("Argument " + (jj + 1) + "'s type (" + args[jj + 1].getTypeName() + ") should be equal to argument " + index + "'s type (" + args[index].getTypeName() + ")");
            }
        }
        this.forwardObj = new Object[this.numCols.intValue()];
        for (int ii = 0; ii < args.length; ++ii) {
            this.argOIs.add(args[ii]);
        }
        ArrayList<String> fieldNames = new ArrayList<String>();
        ArrayList<ObjectInspector> fieldOIs = new ArrayList<ObjectInspector>();
        for (int ii = 0; ii < this.numCols; ++ii) {
            fieldNames.add("col" + ii);
            fieldOIs.add(this.returnOIResolvers.get(ii).get());
        }
        return ObjectInspectorFactory.getStandardStructObjectInspector(fieldNames, fieldOIs);
    }

    public void process(Object[] args) throws HiveException, UDFArgumentException {
        for (int ii = 0; ii < this.numRows.get(); ++ii) {
            for (int jj = 0; jj < this.numCols; ++jj) {
                int index = ii * this.numCols + jj + 1;
                if (index < args.length) {
                    this.forwardObj[jj] = this.returnOIResolvers.get(jj).convertIfNecessary(args[index], this.argOIs.get(index));
                    continue;
                }
                this.forwardObj[ii] = null;
            }
            this.forward(this.forwardObj);
        }
    }

    public String toString() {
        return "stack";
    }
}

