/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connect.client.jdbc.util;

import java.sql.SQLFeatureNotSupportedException;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;

public final class JdbcTypeUtils$ {
    public static final JdbcTypeUtils$ MODULE$ = new JdbcTypeUtils$();

    public int getColumnType(StructField field) {
        DataType dataType = field.dataType();
        if (NullType$.MODULE$.equals(dataType)) {
            return 0;
        }
        if (BooleanType$.MODULE$.equals(dataType)) {
            return 16;
        }
        if (ByteType$.MODULE$.equals(dataType)) {
            return -6;
        }
        if (ShortType$.MODULE$.equals(dataType)) {
            return 5;
        }
        if (IntegerType$.MODULE$.equals(dataType)) {
            return 4;
        }
        if (LongType$.MODULE$.equals(dataType)) {
            return -5;
        }
        if (FloatType$.MODULE$.equals(dataType)) {
            return 6;
        }
        if (DoubleType$.MODULE$.equals(dataType)) {
            return 8;
        }
        if (StringType$.MODULE$.equals(dataType)) {
            return 12;
        }
        throw new SQLFeatureNotSupportedException("DataType " + dataType + " is not supported yet.");
    }

    public String getColumnTypeClassName(StructField field) {
        DataType dataType = field.dataType();
        if (NullType$.MODULE$.equals(dataType)) {
            return "null";
        }
        if (BooleanType$.MODULE$.equals(dataType)) {
            return Boolean.class.getName();
        }
        if (ByteType$.MODULE$.equals(dataType)) {
            return Byte.class.getName();
        }
        if (ShortType$.MODULE$.equals(dataType)) {
            return Short.class.getName();
        }
        if (IntegerType$.MODULE$.equals(dataType)) {
            return Integer.class.getName();
        }
        if (LongType$.MODULE$.equals(dataType)) {
            return Long.class.getName();
        }
        if (FloatType$.MODULE$.equals(dataType)) {
            return Float.class.getName();
        }
        if (DoubleType$.MODULE$.equals(dataType)) {
            return Double.class.getName();
        }
        if (StringType$.MODULE$.equals(dataType)) {
            return String.class.getName();
        }
        throw new SQLFeatureNotSupportedException("DataType " + dataType + " is not supported yet.");
    }

    public boolean isSigned(StructField field) {
        DataType dataType = field.dataType();
        if (ByteType$.MODULE$.equals(dataType) ? true : (ShortType$.MODULE$.equals(dataType) ? true : (IntegerType$.MODULE$.equals(dataType) ? true : (LongType$.MODULE$.equals(dataType) ? true : (FloatType$.MODULE$.equals(dataType) ? true : DoubleType$.MODULE$.equals(dataType)))))) {
            return true;
        }
        if (NullType$.MODULE$.equals(dataType) ? true : (BooleanType$.MODULE$.equals(dataType) ? true : StringType$.MODULE$.equals(dataType))) {
            return false;
        }
        throw new SQLFeatureNotSupportedException("DataType " + dataType + " is not supported yet.");
    }

    public int getPrecision(StructField field) {
        DataType dataType = field.dataType();
        if (NullType$.MODULE$.equals(dataType)) {
            return 0;
        }
        if (BooleanType$.MODULE$.equals(dataType)) {
            return 1;
        }
        if (ByteType$.MODULE$.equals(dataType)) {
            return 3;
        }
        if (ShortType$.MODULE$.equals(dataType)) {
            return 5;
        }
        if (IntegerType$.MODULE$.equals(dataType)) {
            return 10;
        }
        if (LongType$.MODULE$.equals(dataType)) {
            return 19;
        }
        if (FloatType$.MODULE$.equals(dataType)) {
            return 7;
        }
        if (DoubleType$.MODULE$.equals(dataType)) {
            return 15;
        }
        if (StringType$.MODULE$.equals(dataType)) {
            return 255;
        }
        throw new SQLFeatureNotSupportedException("DataType " + dataType + " is not supported yet.");
    }

    public int getScale(StructField field) {
        DataType dataType = field.dataType();
        if (FloatType$.MODULE$.equals(dataType)) {
            return 7;
        }
        if (DoubleType$.MODULE$.equals(dataType)) {
            return 15;
        }
        if (NullType$.MODULE$.equals(dataType) ? true : (BooleanType$.MODULE$.equals(dataType) ? true : (ByteType$.MODULE$.equals(dataType) ? true : (ShortType$.MODULE$.equals(dataType) ? true : (IntegerType$.MODULE$.equals(dataType) ? true : (LongType$.MODULE$.equals(dataType) ? true : StringType$.MODULE$.equals(dataType))))))) {
            return 0;
        }
        throw new SQLFeatureNotSupportedException("DataType " + dataType + " is not supported yet.");
    }

    public int getDisplaySize(StructField field) {
        DataType dataType = field.dataType();
        if (NullType$.MODULE$.equals(dataType)) {
            return 4;
        }
        if (BooleanType$.MODULE$.equals(dataType)) {
            return 5;
        }
        if (ByteType$.MODULE$.equals(dataType) ? true : (ShortType$.MODULE$.equals(dataType) ? true : (IntegerType$.MODULE$.equals(dataType) ? true : LongType$.MODULE$.equals(dataType)))) {
            return this.getPrecision(field) + 1;
        }
        if (FloatType$.MODULE$.equals(dataType)) {
            return 14;
        }
        if (DoubleType$.MODULE$.equals(dataType)) {
            return 24;
        }
        if (StringType$.MODULE$.equals(dataType)) {
            return this.getPrecision(field);
        }
        throw new SQLFeatureNotSupportedException("DataType " + dataType + " is not supported yet.");
    }

    private JdbcTypeUtils$() {
    }
}

