/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.theta;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.datasketches.common.ResizeFactor;
import org.apache.datasketches.common.SuppressFBWarnings;
import org.apache.datasketches.theta.ConcurrentBackgroundThetaPropagation;
import org.apache.datasketches.theta.ConcurrentPropagationService;
import org.apache.datasketches.theta.ConcurrentSharedThetaSketch;
import org.apache.datasketches.theta.HeapQuickSelectSketch;
import org.apache.datasketches.theta.Sketch;
import org.apache.datasketches.theta.UpdateReturnState;
import org.apache.datasketches.theta.UpdateSketch;

final class ConcurrentHeapQuickSelectSketch
extends HeapQuickSelectSketch
implements ConcurrentSharedThetaSketch {
    private volatile ExecutorService executorService_;
    private final AtomicBoolean sharedPropagationInProgress_;
    private volatile long volatileThetaLong_;
    private volatile double volatileEstimate_;
    private final long exactLimit_;
    private volatile long epoch_;

    ConcurrentHeapQuickSelectSketch(int lgNomLongs, long seed, double maxConcurrencyError) {
        super(lgNomLongs, seed, 1.0f, ResizeFactor.X1, false);
        this.volatileThetaLong_ = Long.MAX_VALUE;
        this.volatileEstimate_ = 0.0;
        this.exactLimit_ = ConcurrentSharedThetaSketch.computeExactLimit(1L << this.getLgNomLongs(), maxConcurrencyError);
        this.sharedPropagationInProgress_ = new AtomicBoolean(false);
        this.epoch_ = 0L;
        this.initBgPropagationService();
    }

    ConcurrentHeapQuickSelectSketch(UpdateSketch sketch, long seed, double maxConcurrencyError) {
        super(sketch.getLgNomLongs(), seed, 1.0f, ResizeFactor.X1, false);
        this.exactLimit_ = ConcurrentSharedThetaSketch.computeExactLimit(1L << this.getLgNomLongs(), maxConcurrencyError);
        this.sharedPropagationInProgress_ = new AtomicBoolean(false);
        this.epoch_ = 0L;
        this.initBgPropagationService();
        for (long hashIn : sketch.getCache()) {
            this.propagate(hashIn);
        }
        this.thetaLong_ = sketch.getThetaLong();
        this.updateVolatileTheta();
        this.updateEstimationSnapshot();
    }

    @Override
    public double getEstimate() {
        return this.volatileEstimate_;
    }

    @Override
    public boolean isEstimationMode() {
        return (long)this.getRetainedEntries(false) > this.exactLimit_ || super.isEstimationMode();
    }

    @Override
    public byte[] toByteArray() {
        while (!this.sharedPropagationInProgress_.compareAndSet(false, true)) {
        }
        byte[] res = super.toByteArray();
        this.sharedPropagationInProgress_.set(false);
        return res;
    }

    @Override
    public UpdateSketch rebuild() {
        super.rebuild();
        this.updateEstimationSnapshot();
        return this;
    }

    @Override
    public void reset() {
        this.advanceEpoch();
        super.reset();
        this.volatileThetaLong_ = Long.MAX_VALUE;
        this.volatileEstimate_ = 0.0;
    }

    @Override
    UpdateReturnState hashUpdate(long hash) {
        String msg = "No update method should be called directly to a shared theta sketch. Updating the shared sketch is only permitted through propagation from local sketches.";
        throw new UnsupportedOperationException("No update method should be called directly to a shared theta sketch. Updating the shared sketch is only permitted through propagation from local sketches.");
    }

    @Override
    public long getExactLimit() {
        return this.exactLimit_;
    }

    @Override
    public boolean startEagerPropagation() {
        while (!this.sharedPropagationInProgress_.compareAndSet(false, true)) {
        }
        return !this.isEstimationMode();
    }

    @Override
    public void endPropagation(AtomicBoolean localPropagationInProgress, boolean isEager) {
        this.updateVolatileTheta();
        this.updateEstimationSnapshot();
        if (isEager) {
            this.sharedPropagationInProgress_.set(false);
        }
        if (localPropagationInProgress != null) {
            localPropagationInProgress.set(false);
        }
    }

    @Override
    public long getVolatileTheta() {
        return this.volatileThetaLong_;
    }

    @Override
    public void awaitBgPropagationTermination() {
        try {
            this.executorService_.shutdown();
            while (!this.executorService_.awaitTermination(1L, TimeUnit.MILLISECONDS)) {
                Thread.sleep(1L);
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void initBgPropagationService() {
        this.executorService_ = ConcurrentPropagationService.getExecutorService(Thread.currentThread().getId());
    }

    @Override
    public boolean propagate(AtomicBoolean localPropagationInProgress, Sketch sketchIn, long singleHash) {
        long epoch = this.epoch_;
        if (singleHash != -1L && (long)this.getRetainedEntries(false) < this.exactLimit_) {
            if (!this.startEagerPropagation()) {
                this.endPropagation(localPropagationInProgress, true);
                return false;
            }
            if (!this.validateEpoch(epoch)) {
                this.endPropagation(null, true);
                return true;
            }
            this.propagate(singleHash);
            this.endPropagation(localPropagationInProgress, true);
            return true;
        }
        ConcurrentBackgroundThetaPropagation job = new ConcurrentBackgroundThetaPropagation(this, localPropagationInProgress, sketchIn, singleHash, epoch);
        this.executorService_.execute(job);
        return true;
    }

    @Override
    public void propagate(long singleHash) {
        super.hashUpdate(singleHash);
    }

    @Override
    public void updateEstimationSnapshot() {
        this.volatileEstimate_ = super.getEstimate();
    }

    @Override
    public void updateVolatileTheta() {
        this.volatileThetaLong_ = this.getThetaLong();
    }

    @Override
    public boolean validateEpoch(long epoch) {
        return this.epoch_ == epoch;
    }

    @SuppressFBWarnings(value={"VO_VOLATILE_INCREMENT"}, justification="Likely False Positive, Fix Later")
    private void advanceEpoch() {
        this.awaitBgPropagationTermination();
        this.startEagerPropagation();
        ConcurrentPropagationService.resetExecutorService(Thread.currentThread().getId());
        ++this.epoch_;
        this.endPropagation(null, true);
        this.initBgPropagationService();
    }
}

