/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming.checkpointing;

import java.io.Serializable;
import scala.Function0;
import scala.Option;
import scala.Predef$;
import scala.collection.immutable.NumericRange;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong;

public final class HDFSMetadataLog$ {
    public static final HDFSMetadataLog$ MODULE$ = new HDFSMetadataLog$();

    public void verifyBatchIds(Seq<Object> batchIds, Option<Object> startId, Option<Object> endId) {
        if (startId.isDefined() || endId.isDefined()) {
            if (batchIds.isEmpty()) {
                throw new IllegalStateException("batch " + startId.orElse((Function0 & Serializable)() -> endId).get() + " doesn't exist");
            }
            if (startId.isDefined()) {
                long minBatchId = BoxesRunTime.unboxToLong((Object)batchIds.head());
                Predef$.MODULE$.assert(minBatchId >= BoxesRunTime.unboxToLong((Object)startId.get()));
                if (minBatchId != BoxesRunTime.unboxToLong((Object)startId.get())) {
                    NumericRange.Inclusive missingBatchIds = new RichLong(Predef$.MODULE$.longWrapper(BoxesRunTime.unboxToLong((Object)startId.get()))).to((Object)BoxesRunTime.boxToLong((long)minBatchId));
                    throw new IllegalStateException("batches (" + missingBatchIds.mkString(", ") + ") don't exist (startId: " + startId + ", endId: " + endId + ")");
                }
            }
            if (endId.isDefined()) {
                long maxBatchId = BoxesRunTime.unboxToLong((Object)batchIds.last());
                Predef$.MODULE$.assert(maxBatchId <= BoxesRunTime.unboxToLong((Object)endId.get()));
                if (maxBatchId != BoxesRunTime.unboxToLong((Object)endId.get())) {
                    NumericRange.Inclusive missingBatchIds = new RichLong(Predef$.MODULE$.longWrapper(maxBatchId)).to(endId.get());
                    throw new IllegalStateException("batches (" + missingBatchIds.mkString(", ") + ") don't  exist (startId: " + startId + ", endId: " + endId + ")");
                }
            }
        }
        if (batchIds.nonEmpty()) {
            long minBatchId = BoxesRunTime.unboxToLong((Object)batchIds.head());
            long maxBatchId = BoxesRunTime.unboxToLong((Object)batchIds.last());
            Set missingBatchIds = (Set)new RichLong(Predef$.MODULE$.longWrapper(minBatchId)).to((Object)BoxesRunTime.boxToLong((long)maxBatchId)).toSet().$minus$minus(batchIds);
            if (missingBatchIds.nonEmpty()) {
                throw new IllegalStateException("batches (" + missingBatchIds.mkString(", ") + ") don't exist (startId: " + startId + ", endId: " + endId + ")");
            }
            return;
        }
    }

    private HDFSMetadataLog$() {
    }
}

