/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.datasketches.theta.CompactSketch;
import org.apache.datasketches.theta.SetOperation;
import org.apache.datasketches.theta.Sketch;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ThetaDifference$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenFallback;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.util.ThetaSketchUtils$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.DataType;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="\n    _FUNC_(first, second) - Subtracts two binary representations of\n    Datasketches ThetaSketch objects from two input columns using a\n    ThetaSketch AnotB object. ", examples="\n    Examples:\n      > SELECT theta_sketch_estimate(_FUNC_(theta_sketch_agg(col1), theta_sketch_agg(col2))) FROM VALUES (5, 4), (1, 4), (2, 5), (2, 5), (3, 1) tab(col1, col2);\n       2\n  ", group="misc_funcs", since="4.1.0")
@ScalaSignature(bytes="\u0006\u0005\u0005\u0015h\u0001B\u0010!\u00016B\u0001\"\u0014\u0001\u0003\u0016\u0004%\tA\u0014\u0005\t%\u0002\u0011\t\u0012)A\u0005\u001f\"A1\u000b\u0001BK\u0002\u0013\u0005a\n\u0003\u0005U\u0001\tE\t\u0015!\u0003P\u0011\u0015)\u0006\u0001\"\u0001W\u0011\u0015Q\u0006\u0001\"\u0011\\\u0011\u0015y\u0006\u0001\"\u0011O\u0011\u0015\u0001\u0007\u0001\"\u0011O\u0011\u0015\t\u0007\u0001\"\u0015c\u0011\u00159\u0007\u0001\"\u0011i\u0011\u0015\t\b\u0001\"\u0011s\u0011\u0015a\b\u0001\"\u0011~\u0011\u001d\t\u0019\u0001\u0001C!\u0003\u000bA\u0011\"!\u0006\u0001\u0003\u0003%\t!a\u0006\t\u0013\u0005u\u0001!%A\u0005\u0002\u0005}\u0001\"CA\u001b\u0001E\u0005I\u0011AA\u0010\u0011%\t9\u0004AA\u0001\n\u0003\nI\u0004C\u0005\u0002J\u0001\t\t\u0011\"\u0001\u0002L!I\u00111\u000b\u0001\u0002\u0002\u0013\u0005\u0011Q\u000b\u0005\n\u00037\u0002\u0011\u0011!C!\u0003;B\u0011\"a\u001b\u0001\u0003\u0003%\t!!\u001c\t\u0013\u0005E\u0004!!A\u0005B\u0005M\u0004\"CA<\u0001\u0005\u0005I\u0011IA=\u000f%\ti\nIA\u0001\u0012\u0003\tyJ\u0002\u0005 A\u0005\u0005\t\u0012AAQ\u0011\u0019)\u0016\u0004\"\u0001\u0002:\"I\u00111X\r\u0002\u0002\u0013\u0015\u0013Q\u0018\u0005\n\u0003\u007fK\u0012\u0011!CA\u0003\u0003D\u0011\"a2\u001a\u0003\u0003%\t)!3\t\u0013\u0005m\u0017$!A\u0005\n\u0005u'a\u0004+iKR\fG)\u001b4gKJ,gnY3\u000b\u0005\u0005\u0012\u0013aC3yaJ,7o]5p]NT!a\t\u0013\u0002\u0011\r\fG/\u00197zgRT!!\n\u0014\u0002\u0007M\fHN\u0003\u0002(Q\u0005)1\u000f]1sW*\u0011\u0011FK\u0001\u0007CB\f7\r[3\u000b\u0003-\n1a\u001c:h\u0007\u0001\u0019b\u0001\u0001\u00183qm\n\u0005CA\u00181\u001b\u0005\u0001\u0013BA\u0019!\u0005A\u0011\u0015N\\1ss\u0016C\bO]3tg&|g\u000e\u0005\u00024m5\tAG\u0003\u00026A\u000591m\u001c3fO\u0016t\u0017BA\u001c5\u0005=\u0019u\u000eZ3hK:4\u0015\r\u001c7cC\u000e\\\u0007CA\u0018:\u0013\tQ\u0004EA\tFqB,7\r^:J]B,H\u000fV=qKN\u0004\"\u0001P \u000e\u0003uR\u0011AP\u0001\u0006g\u000e\fG.Y\u0005\u0003\u0001v\u0012q\u0001\u0015:pIV\u001cG\u000f\u0005\u0002C\u0015:\u00111\t\u0013\b\u0003\t\u001ek\u0011!\u0012\u0006\u0003\r2\na\u0001\u0010:p_Rt\u0014\"\u0001 \n\u0005%k\u0014a\u00029bG.\fw-Z\u0005\u0003\u00172\u0013AbU3sS\u0006d\u0017N_1cY\u0016T!!S\u001f\u0002\u000b\u0019L'o\u001d;\u0016\u0003=\u0003\"a\f)\n\u0005E\u0003#AC#yaJ,7o]5p]\u00061a-\u001b:ti\u0002\naa]3d_:$\u0017aB:fG>tG\rI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007]C\u0016\f\u0005\u00020\u0001!)Q*\u0002a\u0001\u001f\")1+\u0002a\u0001\u001f\u0006qa.\u001e7m\u0013:$x\u000e\\3sC:$X#\u0001/\u0011\u0005qj\u0016B\u00010>\u0005\u001d\u0011un\u001c7fC:\fA\u0001\\3gi\u0006)!/[4ii\u00069r/\u001b;i\u001d\u0016<8\t[5mIJ,g.\u00138uKJt\u0017\r\u001c\u000b\u0004/\u000e,\u0007\"\u00023\n\u0001\u0004y\u0015\u0001\u00038fo\u001aK'o\u001d;\t\u000b\u0019L\u0001\u0019A(\u0002\u00139,woU3d_:$\u0017A\u00039sKR$\u0018PT1nKV\t\u0011\u000e\u0005\u0002k]:\u00111\u000e\u001c\t\u0003\tvJ!!\\\u001f\u0002\rA\u0013X\rZ3g\u0013\ty\u0007O\u0001\u0004TiJLgn\u001a\u0006\u0003[v\n!\"\u001b8qkR$\u0016\u0010]3t+\u0005\u0019\bc\u0001\"um&\u0011Q\u000f\u0014\u0002\u0004'\u0016\f\bCA<{\u001b\u0005A(BA=%\u0003\u0015!\u0018\u0010]3t\u0013\tY\bP\u0001\tBEN$(/Y2u\t\u0006$\u0018\rV=qK\u0006AA-\u0019;b)f\u0004X-F\u0001\u007f!\t9x0C\u0002\u0002\u0002a\u0014\u0001\u0002R1uCRK\b/Z\u0001\r]VdGnU1gK\u00163\u0018\r\u001c\u000b\u0007\u0003\u000f\ti!!\u0005\u0011\u0007q\nI!C\u0002\u0002\fu\u00121!\u00118z\u0011\u001d\ty!\u0004a\u0001\u0003\u000f\taA^1mk\u0016\f\u0004bBA\n\u001b\u0001\u0007\u0011qA\u0001\u0007m\u0006dW/\u001a\u001a\u0002\t\r|\u0007/\u001f\u000b\u0006/\u0006e\u00111\u0004\u0005\b\u001b:\u0001\n\u00111\u0001P\u0011\u001d\u0019f\u0002%AA\u0002=\u000babY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002\")\u001aq*a\t,\u0005\u0005\u0015\u0002\u0003BA\u0014\u0003ci!!!\u000b\u000b\t\u0005-\u0012QF\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a\f>\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003g\tICA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fabY8qs\u0012\"WMZ1vYR$#'A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0003w\u0001B!!\u0010\u0002H5\u0011\u0011q\b\u0006\u0005\u0003\u0003\n\u0019%\u0001\u0003mC:<'BAA#\u0003\u0011Q\u0017M^1\n\u0007=\fy$\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u0002NA\u0019A(a\u0014\n\u0007\u0005ESHA\u0002J]R\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0002\b\u0005]\u0003\"CA-'\u0005\u0005\t\u0019AA'\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u0011q\f\t\u0007\u0003C\n9'a\u0002\u000e\u0005\u0005\r$bAA3{\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005%\u00141\r\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000eF\u0002]\u0003_B\u0011\"!\u0017\u0016\u0003\u0003\u0005\r!a\u0002\u0002%A\u0014x\u000eZ;di\u0016cW-\\3oi:\u000bW.\u001a\u000b\u0005\u0003w\t)\bC\u0005\u0002ZY\t\t\u00111\u0001\u0002N\u00051Q-];bYN$2\u0001XA>\u0011%\tIfFA\u0001\u0002\u0004\t9\u0001K\n\u0001\u0003\u007f\n))a\"\u0002\f\u00065\u0015\u0011SAJ\u0003/\u000bI\nE\u00020\u0003\u0003K1!a!!\u0005U)\u0005\u0010\u001d:fgNLwN\u001c#fg\u000e\u0014\u0018\u000e\u001d;j_:\fQ!^:bO\u0016\f#!!#\u0002\u0003\u001fR\u0001\u0005\t\u0011!?\u001a+fjQ0)M&\u00148\u000f\u001e\u0017!g\u0016\u001cwN\u001c3*A5\u00023+\u001e2ue\u0006\u001cGo\u001d\u0011uo>\u0004#-\u001b8bef\u0004#/\u001a9sKN,g\u000e^1uS>t7\u000fI8g\u0015\u0001\u0002\u0003\u0005\t#bi\u0006\u001c8.\u001a;dQ\u0016\u001c\b\u0005\u00165fi\u0006\u001c6.\u001a;dQ\u0002z'M[3diN\u0004cM]8nAQ<x\u000eI5oaV$\beY8mk6t7\u000fI;tS:<\u0007%\u0019\u0006!A\u0001\u0002C\u000b[3uCN[W\r^2iA\u0005sw\u000e\u001e\"!_\nTWm\u0019;/A\u0005AQ\r_1na2,7/\t\u0002\u0002\u0010\u0006\t9H\u0003\u0011!A\u0001*\u00050Y7qY\u0016\u001c(H\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011uQ\u0016$\u0018mX:lKR\u001c\u0007nX3ti&l\u0017\r^3)?\u001a+fjQ0)i\",G/Y0tW\u0016$8\r[0bO\u001eD3m\u001c72S1\u0002C\u000f[3uC~\u001b8.\u001a;dQ~\u000bwm\u001a\u0015d_2\u0014\u0014&K\u0015!\rJ{U\n\t,B\u0019V+5\u000b\t\u00156Y\u0001\"\u0014\u0006\f\u0011)c1\u0002C'\u000b\u0017!QIb\u0003%N\u0015-A!\u0012D\u0006I\u001b*Y\u0001B3\u0007\f\u00112S\u0001\"\u0018M\u0019\u0015d_2\fD\u0006I2pYJJ3H\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u001a\u000bA\u0001\nQa\u001a:pkB\f#!!&\u0002\u00155L7oY0gk:\u001c7/A\u0003tS:\u001cW-\t\u0002\u0002\u001c\u0006)AGL\u0019/a\u0005yA\u000b[3uC\u0012KgMZ3sK:\u001cW\r\u0005\u000203M)\u0011$a)\u00020B9\u0011QUAV\u001f>;VBAAT\u0015\r\tI+P\u0001\beVtG/[7f\u0013\u0011\ti+a*\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t'\u0007\u0005\u0003\u00022\u0006]VBAAZ\u0015\u0011\t),a\u0011\u0002\u0005%|\u0017bA&\u00024R\u0011\u0011qT\u0001\ti>\u001cFO]5oOR\u0011\u00111H\u0001\u0006CB\u0004H.\u001f\u000b\u0006/\u0006\r\u0017Q\u0019\u0005\u0006\u001br\u0001\ra\u0014\u0005\u0006'r\u0001\raT\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\tY-a6\u0011\u000bq\ni-!5\n\u0007\u0005=WH\u0001\u0004PaRLwN\u001c\t\u0006y\u0005MwjT\u0005\u0004\u0003+l$A\u0002+va2,'\u0007\u0003\u0005\u0002Zv\t\t\u00111\u0001X\u0003\rAH\u0005M\u0001\roJLG/\u001a*fa2\f7-\u001a\u000b\u0003\u0003?\u0004B!!\u0010\u0002b&!\u00111]A \u0005\u0019y%M[3di\u0002")
public class ThetaDifference
extends BinaryExpression
implements CodegenFallback,
ExpectsInputTypes,
Serializable {
    private final Expression first;
    private final Expression second;

    public static Option<Tuple2<Expression, Expression>> unapply(ThetaDifference x$0) {
        return ThetaDifference$.MODULE$.unapply(x$0);
    }

    public static Function1<Tuple2<Expression, Expression>, ThetaDifference> tupled() {
        return ThetaDifference$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, ThetaDifference>> curried() {
        return ThetaDifference$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return CodegenFallback.doGenCode$(this, ctx, ev);
    }

    public Expression first() {
        return this.first;
    }

    public Expression second() {
        return this.second;
    }

    @Override
    public boolean nullIntolerant() {
        return true;
    }

    @Override
    public Expression left() {
        return this.first();
    }

    @Override
    public Expression right() {
        return this.second();
    }

    @Override
    public ThetaDifference withNewChildrenInternal(Expression newFirst, Expression newSecond) {
        return this.copy(newFirst, newSecond);
    }

    @Override
    public String prettyName() {
        return "theta_difference";
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return new .colon.colon((Object)BinaryType$.MODULE$, (List)new .colon.colon((Object)BinaryType$.MODULE$, (List)Nil$.MODULE$));
    }

    @Override
    public DataType dataType() {
        return BinaryType$.MODULE$;
    }

    @Override
    public Object nullSafeEval(Object value1, Object value2) {
        byte[] sketch1Bytes = (byte[])value1;
        CompactSketch sketch1 = ThetaSketchUtils$.MODULE$.wrapCompactSketch(sketch1Bytes, this.prettyName());
        byte[] sketch2Bytes = (byte[])value2;
        CompactSketch sketch2 = ThetaSketchUtils$.MODULE$.wrapCompactSketch(sketch2Bytes, this.prettyName());
        CompactSketch difference = SetOperation.builder().buildANotB().aNotB((Sketch)sketch1, (Sketch)sketch2);
        return difference.toByteArrayCompressed();
    }

    public ThetaDifference copy(Expression first, Expression second) {
        return new ThetaDifference(first, second);
    }

    public Expression copy$default$1() {
        return this.first();
    }

    public Expression copy$default$2() {
        return this.second();
    }

    @Override
    public String productPrefix() {
        return "ThetaDifference";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.first();
            }
            case 1: {
                return this.second();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ThetaDifference;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "first";
            }
            case 1: {
                return "second";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ThetaDifference)) return false;
        boolean bl = true;
        if (!bl) return false;
        ThetaDifference thetaDifference = (ThetaDifference)x$1;
        Expression expression = this.first();
        Expression expression2 = thetaDifference.first();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.second();
        Expression expression4 = thetaDifference.second();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!thetaDifference.canEqual(this)) return false;
        return true;
    }

    public ThetaDifference(Expression first, Expression second) {
        this.first = first;
        this.second = second;
        CodegenFallback.$init$(this);
        ExpectsInputTypes.$init$(this);
    }
}

