/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming.operators.stateful.transformwithstate;

import java.io.Serializable;
import org.apache.spark.sql.Encoder;
import org.apache.spark.sql.catalyst.encoders.ExpressionEncoder;
import org.apache.spark.sql.execution.streaming.operators.stateful.transformwithstate.TransformWithStateKeyValueRowSchemaUtils$;
import org.apache.spark.sql.execution.streaming.operators.stateful.transformwithstate.TransformWithStateVariableUtils$;
import org.apache.spark.sql.execution.streaming.state.KeyStateEncoderSpec;
import org.apache.spark.sql.execution.streaming.state.NoPrefixKeyStateEncoderSpec;
import org.apache.spark.sql.execution.streaming.state.PrefixKeyScanStateEncoderSpec;
import org.apache.spark.sql.execution.streaming.state.RangeKeyScanStateEncoderSpec;
import org.apache.spark.sql.execution.streaming.state.StateStoreColFamilySchema;
import org.apache.spark.sql.execution.streaming.state.StateStoreColFamilySchema$;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType;
import org.apache.spark.sql.types.ByteType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType;
import org.apache.spark.sql.types.FloatType;
import org.apache.spark.sql.types.IntegerType;
import org.apache.spark.sql.types.LongType;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.ShortType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.Map$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class StateStoreColumnFamilySchemaUtils$ {
    public static final StateStoreColumnFamilySchemaUtils$ MODULE$ = new StateStoreColumnFamilySchemaUtils$();

    public StructType convertForRangeScan(StructType schema, Seq<Object> ordinals) {
        Set ordinalSet = ordinals.toSet();
        return new StructType((StructField[])ArrayOps$.MODULE$.flatMap$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zipWithIndex$extension(Predef$.MODULE$.refArrayOps((Object[])schema.fields()))), (Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                StructField field = (StructField)tuple2._1();
                int idx = tuple2._2$mcI$sp();
                if ((ordinals.isEmpty() || ordinalSet.contains((Object)BoxesRunTime.boxToInteger((int)idx))) && MODULE$.isFixedSize(field.dataType())) {
                    return new .colon.colon((Object)new StructField(field.name() + "_marker", (DataType)BinaryType$.MODULE$, true, StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)field.copy(field.name() + "_value", (DataType)BinaryType$.MODULE$, field.copy$default$3(), field.copy$default$4()), (List)Nil$.MODULE$));
                }
                return new .colon.colon((Object)field, (List)Nil$.MODULE$);
            }
            throw new MatchError((Object)tuple2);
        }, ClassTag$.MODULE$.apply(StructField.class)));
    }

    public Seq<Object> convertForRangeScan$default$2() {
        return (Seq)package$.MODULE$.Seq().empty();
    }

    private boolean isFixedSize(DataType dataType) {
        DataType dataType2 = dataType;
        return dataType2 instanceof ByteType ? true : (dataType2 instanceof BooleanType ? true : (dataType2 instanceof ShortType ? true : (dataType2 instanceof IntegerType ? true : (dataType2 instanceof LongType ? true : (dataType2 instanceof FloatType ? true : dataType2 instanceof DoubleType)))));
    }

    public String getTtlColFamilyName(String stateName) {
        return "$ttl_" + stateName;
    }

    public <T> Map<String, StateStoreColFamilySchema> getValueStateSchema(String stateName, ExpressionEncoder<Object> keyEncoder, Encoder<T> valEncoder, boolean hasTtl) {
        scala.collection.mutable.Map schemas = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        schemas.put((Object)stateName, (Object)new StateStoreColFamilySchema(stateName, 0, keyEncoder.schema(), 0, TransformWithStateKeyValueRowSchemaUtils$.MODULE$.getValueSchemaWithTTL(valEncoder.schema(), hasTtl), (Option<KeyStateEncoderSpec>)new Some((Object)new NoPrefixKeyStateEncoderSpec(keyEncoder.schema())), StateStoreColFamilySchema$.MODULE$.apply$default$7()));
        if (hasTtl) {
            StateStoreColFamilySchema ttlIndexSchema = new StateStoreColFamilySchema(this.getTtlColFamilyName(stateName), 0, TransformWithStateKeyValueRowSchemaUtils$.MODULE$.getTTLRowKeySchema(keyEncoder.schema()), 0, new StructType((StructField[])((Object[])new StructField[]{new StructField("__empty__", (DataType)NullType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())})), (Option<KeyStateEncoderSpec>)new Some((Object)new RangeKeyScanStateEncoderSpec(TransformWithStateKeyValueRowSchemaUtils$.MODULE$.getTTLRowKeySchema(keyEncoder.schema()), (Seq<Object>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0}))))), StateStoreColFamilySchema$.MODULE$.apply$default$7());
            v0 = schemas.put((Object)ttlIndexSchema.colFamilyName(), (Object)ttlIndexSchema);
        } else {
            v0 = BoxedUnit.UNIT;
        }
        return schemas.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public <T> Map<String, StateStoreColFamilySchema> getListStateSchema(String stateName, ExpressionEncoder<Object> keyEncoder, Encoder<T> valEncoder, boolean hasTtl) {
        scala.collection.mutable.Map schemas = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        schemas.put((Object)stateName, (Object)new StateStoreColFamilySchema(stateName, 0, keyEncoder.schema(), 0, TransformWithStateKeyValueRowSchemaUtils$.MODULE$.getValueSchemaWithTTL(valEncoder.schema(), hasTtl), (Option<KeyStateEncoderSpec>)new Some((Object)new NoPrefixKeyStateEncoderSpec(keyEncoder.schema())), StateStoreColFamilySchema$.MODULE$.apply$default$7()));
        StateStoreColFamilySchema counterSchema = new StateStoreColFamilySchema(TransformWithStateVariableUtils$.MODULE$.getRowCounterCFName(stateName), 0, keyEncoder.schema(), 0, StructType$.MODULE$.apply((Seq)new .colon.colon((Object)new StructField("count", (DataType)LongType$.MODULE$, true, StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$)), (Option<KeyStateEncoderSpec>)new Some((Object)new NoPrefixKeyStateEncoderSpec(keyEncoder.schema())), StateStoreColFamilySchema$.MODULE$.apply$default$7());
        schemas.put((Object)counterSchema.colFamilyName(), (Object)counterSchema);
        if (hasTtl) {
            StateStoreColFamilySchema ttlIndexSchema = new StateStoreColFamilySchema(this.getTtlColFamilyName(stateName), 0, TransformWithStateKeyValueRowSchemaUtils$.MODULE$.getTTLRowKeySchema(keyEncoder.schema()), 0, new StructType((StructField[])((Object[])new StructField[]{new StructField("__empty__", (DataType)NullType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())})), (Option<KeyStateEncoderSpec>)new Some((Object)new RangeKeyScanStateEncoderSpec(TransformWithStateKeyValueRowSchemaUtils$.MODULE$.getTTLRowKeySchema(keyEncoder.schema()), (Seq<Object>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0}))))), StateStoreColFamilySchema$.MODULE$.apply$default$7());
            schemas.put((Object)ttlIndexSchema.colFamilyName(), (Object)ttlIndexSchema);
            StateStoreColFamilySchema minIndexSchema = new StateStoreColFamilySchema("$min_" + stateName, 0, keyEncoder.schema(), 0, TransformWithStateKeyValueRowSchemaUtils$.MODULE$.getExpirationMsRowSchema(), (Option<KeyStateEncoderSpec>)new Some((Object)new NoPrefixKeyStateEncoderSpec(keyEncoder.schema())), StateStoreColFamilySchema$.MODULE$.apply$default$7());
            schemas.put((Object)minIndexSchema.colFamilyName(), (Object)minIndexSchema);
            StateStoreColFamilySchema countSchema = new StateStoreColFamilySchema("$count_" + stateName, 0, keyEncoder.schema(), 0, StructType$.MODULE$.apply((Seq)new .colon.colon((Object)new StructField("count", (DataType)LongType$.MODULE$, true, StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$)), (Option<KeyStateEncoderSpec>)new Some((Object)new NoPrefixKeyStateEncoderSpec(keyEncoder.schema())), StateStoreColFamilySchema$.MODULE$.apply$default$7());
            v0 = schemas.put((Object)countSchema.colFamilyName(), (Object)countSchema);
        } else {
            v0 = BoxedUnit.UNIT;
        }
        return schemas.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public <K, V> Map<String, StateStoreColFamilySchema> getMapStateSchema(String stateName, ExpressionEncoder<Object> keyEncoder, Encoder<K> userKeyEnc, Encoder<V> valEncoder, boolean hasTtl) {
        scala.collection.mutable.Map schemas = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        StructType compositeKeySchema = TransformWithStateKeyValueRowSchemaUtils$.MODULE$.getCompositeKeySchema(keyEncoder.schema(), userKeyEnc.schema());
        schemas.put((Object)stateName, (Object)new StateStoreColFamilySchema(stateName, 0, compositeKeySchema, 0, TransformWithStateKeyValueRowSchemaUtils$.MODULE$.getValueSchemaWithTTL(valEncoder.schema(), hasTtl), (Option<KeyStateEncoderSpec>)new Some((Object)new PrefixKeyScanStateEncoderSpec(compositeKeySchema, 1)), (Option<StructType>)new Some((Object)userKeyEnc.schema())));
        if (hasTtl) {
            StateStoreColFamilySchema ttlIndexSchema = new StateStoreColFamilySchema(this.getTtlColFamilyName(stateName), 0, TransformWithStateKeyValueRowSchemaUtils$.MODULE$.getTTLRowKeySchema(compositeKeySchema), 0, new StructType((StructField[])((Object[])new StructField[]{new StructField("__empty__", (DataType)NullType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())})), (Option<KeyStateEncoderSpec>)new Some((Object)new RangeKeyScanStateEncoderSpec(TransformWithStateKeyValueRowSchemaUtils$.MODULE$.getTTLRowKeySchema(compositeKeySchema), (Seq<Object>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0}))))), StateStoreColFamilySchema$.MODULE$.apply$default$7());
            v0 = schemas.put((Object)ttlIndexSchema.colFamilyName(), (Object)ttlIndexSchema);
        } else {
            v0 = BoxedUnit.UNIT;
        }
        return schemas.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public StateStoreColFamilySchema getTimerStateSchema(String stateName, StructType keySchema, StructType valSchema) {
        return new StateStoreColFamilySchema(stateName, 0, keySchema, 0, valSchema, (Option<KeyStateEncoderSpec>)new Some((Object)new PrefixKeyScanStateEncoderSpec(keySchema, 1)), StateStoreColFamilySchema$.MODULE$.apply$default$7());
    }

    public StateStoreColFamilySchema getSecIndexTimerStateSchema(String stateName, StructType keySchema, StructType valSchema) {
        return new StateStoreColFamilySchema(stateName, 0, keySchema, 0, valSchema, (Option<KeyStateEncoderSpec>)new Some((Object)new RangeKeyScanStateEncoderSpec(keySchema, (Seq<Object>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0}))))), StateStoreColFamilySchema$.MODULE$.apply$default$7());
    }

    private StateStoreColumnFamilySchemaUtils$() {
    }
}

