/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.network.protocol;

import io.netty.buffer.ByteBuf;
import java.util.Objects;
import org.apache.spark.network.buffer.ManagedBuffer;
import org.apache.spark.network.buffer.NettyManagedBuffer;
import org.apache.spark.network.protocol.AbstractResponseMessage;
import org.apache.spark.network.protocol.Message;
import org.apache.spark.network.protocol.ResponseMessage;
import org.apache.spark.network.protocol.RpcFailure;

public final class RpcResponse
extends AbstractResponseMessage {
    public final long requestId;

    public RpcResponse(long requestId, ManagedBuffer message) {
        super(message, true);
        this.requestId = requestId;
    }

    @Override
    public Message.Type type() {
        return Message.Type.RpcResponse;
    }

    @Override
    public int encodedLength() {
        return 12;
    }

    @Override
    public void encode(ByteBuf buf) {
        buf.writeLong(this.requestId);
        buf.writeInt((int)this.body().size());
    }

    @Override
    public ResponseMessage createFailureResponse(String error) {
        return new RpcFailure(this.requestId, error);
    }

    public static RpcResponse decode(ByteBuf buf) {
        long requestId = buf.readLong();
        buf.readInt();
        return new RpcResponse(requestId, new NettyManagedBuffer(buf.retain()));
    }

    public int hashCode() {
        return Objects.hash(this.requestId, this.body());
    }

    public boolean equals(Object other) {
        if (other instanceof RpcResponse) {
            RpcResponse o = (RpcResponse)other;
            return this.requestId == o.requestId && super.equals(o);
        }
        return false;
    }

    public String toString() {
        return "RpcResponse[requestId=" + this.requestId + ",body=" + String.valueOf(this.body()) + "]";
    }
}

