/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.console.core.controller;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.apache.streampark.common.util.Utils;
import org.apache.streampark.console.base.domain.RestResponse;
import org.apache.streampark.console.core.entity.ExternalLink;
import org.apache.streampark.console.core.service.ExternalLinkService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="FLINK_EXTERNAL_LINK_TAG")
@Validated
@RestController
@RequestMapping(value={"/flink/externalLink"})
public class ExternalLinkController {
    private static final Logger log = LoggerFactory.getLogger(ExternalLinkController.class);
    @Autowired
    private ExternalLinkService externalLinkService;

    @Operation(summary="List external link")
    @PostMapping(value={"/list"})
    @RequiresPermissions(value={"externalLink:view"})
    public RestResponse list() {
        List externalLink = this.externalLinkService.list();
        return RestResponse.success(externalLink);
    }

    @Operation(summary="Get the application external links", description="Render external link by app id")
    @Parameters(value={@Parameter(name="appId", required=true, example="100000")})
    @PostMapping(value={"/render"})
    public RestResponse render(@NotNull(message="The flink app id cannot be null") @RequestParam(value="appId") @NotNull(message="The flink app id cannot be null") Long appId) {
        List<ExternalLink> renderedExternalLink = this.externalLinkService.render(appId);
        return RestResponse.success(renderedExternalLink);
    }

    @Operation(summary="Create external link")
    @PostMapping(value={"/create"})
    @RequiresPermissions(value={"externalLink:create"})
    public RestResponse create(@Valid ExternalLink externalLink) {
        this.externalLinkService.create(externalLink);
        return RestResponse.success();
    }

    @Operation(summary="Update external link")
    @PostMapping(value={"/update"})
    @RequiresPermissions(value={"externalLink:update"})
    public RestResponse update(@Valid ExternalLink externalLink) {
        Utils.notNull((Object)externalLink.getId(), (String)"The link id cannot be null");
        this.externalLinkService.update(externalLink);
        return RestResponse.success();
    }

    @Operation(summary="Delete external link")
    @Parameters(value={@Parameter(name="appId", required=true, example="100000")})
    @DeleteMapping(value={"/delete"})
    @RequiresPermissions(value={"externalLink:delete"})
    public RestResponse delete(@NotNull(message="The link id cannot be null") @RequestParam(value="id") @NotNull(message="The link id cannot be null") Long id) {
        this.externalLinkService.delete(id);
        return RestResponse.success();
    }
}

