/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.console.base.mybatis.pager;

import com.baomidou.mybatisplus.core.metadata.OrderItem;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.apache.streampark.console.base.domain.RestRequest;
import org.apache.streampark.console.base.util.WebUtils;

public final class MybatisPager<T> {
    public Page<T> getDefaultPage(RestRequest request) {
        return this.getPage(request, "create_time", "desc");
    }

    public Page<T> getPage(RestRequest request, String defaultSort, String defaultOrder) {
        Page page = new Page();
        page.setCurrent((long)request.getPageNum());
        page.setSize((long)request.getPageSize());
        ArrayList<OrderItem> orderItems = new ArrayList<OrderItem>(0);
        if (StringUtils.isNotBlank((CharSequence)request.getSortField()) && StringUtils.isNotBlank((CharSequence)request.getSortOrder())) {
            String sortField = WebUtils.camelToUnderscore(request.getSortField());
            if (StringUtils.equals((CharSequence)request.getSortOrder(), (CharSequence)"desc")) {
                orderItems.add(OrderItem.desc((String)sortField));
            } else {
                orderItems.add(OrderItem.asc((String)sortField));
            }
        } else if (StringUtils.isNotBlank((CharSequence)defaultSort)) {
            if (StringUtils.equals((CharSequence)defaultOrder, (CharSequence)"desc")) {
                orderItems.add(OrderItem.desc((String)defaultSort));
            } else {
                orderItems.add(OrderItem.asc((String)defaultSort));
            }
        }
        if (!orderItems.isEmpty()) {
            page.setOrders(orderItems);
        }
        return page;
    }
}

