/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.operators.collect;

import org.apache.flink.annotation.Internal;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.DataStreamSink;
import org.apache.flink.streaming.api.operators.ChainingStrategy;
import org.apache.flink.streaming.api.operators.collect.CollectSinkOperator;
import org.apache.flink.streaming.api.operators.collect.CollectSinkOperatorFactory;
import org.apache.flink.streaming.api.transformations.LegacySinkTransformation;
import org.apache.flink.streaming.api.transformations.PhysicalTransformation;

@Internal
public class CollectStreamSink<T>
extends DataStreamSink<T> {
    private final PhysicalTransformation<T> transformation;

    public CollectStreamSink(DataStream<T> inputStream, CollectSinkOperatorFactory<T> factory) {
        super(inputStream, (CollectSinkOperator)factory.getOperator());
        this.transformation = new LegacySinkTransformation<T>(inputStream.getTransformation(), "Collect Stream Sink", factory, 1);
    }

    @Override
    public Transformation<T> getTransformation() {
        return this.transformation;
    }

    @Override
    public DataStreamSink<T> name(String name) {
        this.transformation.setName(name);
        return this;
    }

    @Override
    public DataStreamSink<T> uid(String uid) {
        this.transformation.setUid(uid);
        return this;
    }

    @Override
    public DataStreamSink<T> setUidHash(String uidHash) {
        this.transformation.setUidHash(uidHash);
        return this;
    }

    @Override
    public DataStreamSink<T> setParallelism(int parallelism) {
        this.transformation.setParallelism(parallelism);
        return this;
    }

    @Override
    public DataStreamSink<T> disableChaining() {
        this.transformation.setChainingStrategy(ChainingStrategy.NEVER);
        return this;
    }

    @Override
    public DataStreamSink<T> slotSharingGroup(String slotSharingGroup) {
        this.transformation.setSlotSharingGroup(slotSharingGroup);
        return this;
    }
}

