/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.flink.kubernetes.ingress;

import io.fabric8.kubernetes.api.model.OwnerReference;
import io.fabric8.kubernetes.api.model.OwnerReferenceBuilder;
import io.fabric8.kubernetes.api.model.OwnerReferenceFluentImpl;
import io.fabric8.kubernetes.api.model.apps.Deployment;
import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.dsl.Gettable;
import io.fabric8.kubernetes.client.dsl.Nameable;
import java.io.File;
import java.io.Serializable;
import org.apache.commons.io.FileUtils;
import org.apache.flink.client.program.ClusterClient;
import org.apache.streampark.common.conf.InternalConfigHolder$;
import org.apache.streampark.common.conf.K8sFlinkConfig$;
import scala.Function0;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001m4q!\u0003\u0006\u0011\u0002\u0007\u0005q\u0003C\u0003\u001f\u0001\u0011\u0005q\u0004\u0003\u0005$\u0001!\u0015\r\u0011\"\u0001%\u0011\u0015\u0001\u0004A\"\u00012\u0011\u0015i\u0005A\"\u0001O\u0011\u0015\u0019\u0006\u0001\"\u0001U\u0011\u0015I\u0006\u0001\"\u0001[\u0011\u0015\t\u0007\u0001\"\u0001c\u0011\u0015!\u0007\u0001\"\u0001f\u0005=Ien\u001a:fgN\u001cFO]1uK\u001eL(BA\u0006\r\u0003\u001dIgn\u001a:fgNT!!\u0004\b\u0002\u0015-,(-\u001a:oKR,7O\u0003\u0002\u0010!\u0005)a\r\\5oW*\u0011\u0011CE\u0001\u000bgR\u0014X-Y7qCJ\\'BA\n\u0015\u0003\u0019\t\u0007/Y2iK*\tQ#A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u00011A\u0011\u0011\u0004H\u0007\u00025)\t1$A\u0003tG\u0006d\u0017-\u0003\u0002\u001e5\t1\u0011I\\=SK\u001a\fa\u0001J5oSR$C#\u0001\u0011\u0011\u0005e\t\u0013B\u0001\u0012\u001b\u0005\u0011)f.\u001b;\u0002\u0019%twM]3tg\u000ec\u0017m]:\u0016\u0003\u0015\u0002\"AJ\u0017\u000f\u0005\u001dZ\u0003C\u0001\u0015\u001b\u001b\u0005I#B\u0001\u0016\u0017\u0003\u0019a$o\\8u}%\u0011AFG\u0001\u0007!J,G-\u001a4\n\u00059z#AB*ue&twM\u0003\u0002-5\u0005iq-\u001a;J]\u001e\u0014Xm]:Ve2$B!\n\u001a5m!)1g\u0001a\u0001K\u0005Ia.Y7f'B\f7-\u001a\u0005\u0006k\r\u0001\r!J\u0001\nG2,8\u000f^3s\u0013\u0012DQaN\u0002A\u0002a\nQb\u00197vgR,'o\u00117jK:$\bGA\u001dE!\rQ\u0004IQ\u0007\u0002w)\u0011A(P\u0001\baJ|wM]1n\u0015\tqt(\u0001\u0004dY&,g\u000e\u001e\u0006\u0003\u001fII!!Q\u001e\u0003\u001b\rcWo\u001d;fe\u000ec\u0017.\u001a8u!\t\u0019E\t\u0004\u0001\u0005\u0013\u00153\u0014\u0011!A\u0001\u0006\u00031%aA0%cE\u0011qI\u0013\t\u00033!K!!\u0013\u000e\u0003\u000f9{G\u000f[5oOB\u0011\u0011dS\u0005\u0003\u0019j\u00111!\u00118z\u0003A\u0019wN\u001c4jOV\u0014X-\u00138he\u0016\u001c8\u000f\u0006\u0003!\u001fF\u0013\u0006\"\u0002)\u0005\u0001\u0004)\u0013A\u00033p[\u0006LgNT1nK\")Q\u0007\u0002a\u0001K!)1\u0007\u0002a\u0001K\u0005Y\u0002O]3qCJ,\u0017J\\4sKN\u001cH+Z7qY\u0006$XMR5mKN$2!J+X\u0011\u00151V\u00011\u0001&\u00039\u0011W/\u001b7e/>\u00148n\u001d9bG\u0016DQ\u0001W\u0003A\u0002\u0015\n\u0001#\u001b8he\u0016\u001c8\u000fV3na2\fG/Z:\u0002/\t,\u0018\u000e\u001c3J]\u001e\u0014Xm]:B]:|G/\u0019;j_:\u001cHcA._?B!a\u0005X\u0013&\u0013\tivFA\u0002NCBDQ!\u000e\u0004A\u0002\u0015BQ\u0001\u0019\u0004A\u0002\u0015\n\u0011B\\1nKN\u0004\u0018mY3\u0002%\t,\u0018\u000e\u001c3J]\u001e\u0014Xm]:MC\n,Gn\u001d\u000b\u00037\u000eDQ!N\u0004A\u0002\u0015\n\u0011cZ3u\u001f^tWM\u001d*fM\u0016\u0014XM\\2f)\u001117\u000f^;\u0011\u0005\u001d\fX\"\u00015\u000b\u0005%T\u0017!B7pI\u0016d'BA6m\u0003\r\t\u0007/\u001b\u0006\u0003\u001b5T!A\\8\u0002\u000f\u0019\f'M]5dq)\t\u0001/\u0001\u0002j_&\u0011!\u000f\u001b\u0002\u000f\u001f^tWM\u001d*fM\u0016\u0014XM\\2f\u0011\u0015\u0019\u0004\u00021\u0001&\u0011\u0015)\u0004\u00021\u0001&\u0011\u0015q\u0004\u00021\u0001w!\t9\u00180D\u0001y\u0015\tqD.\u0003\u0002{q\n9B)\u001a4bk2$8*\u001e2fe:,G/Z:DY&,g\u000e\u001e")
public interface IngressStrategy {
    public static /* synthetic */ String ingressClass$(IngressStrategy $this) {
        return $this.ingressClass();
    }

    default public String ingressClass() {
        return (String)InternalConfigHolder$.MODULE$.get(K8sFlinkConfig$.MODULE$.ingressClass());
    }

    public String getIngressUrl(String var1, String var2, ClusterClient<?> var3);

    public void configureIngress(String var1, String var2, String var3);

    public static /* synthetic */ String prepareIngressTemplateFiles$(IngressStrategy $this, String buildWorkspace, String ingressTemplates) {
        return $this.prepareIngressTemplateFiles(buildWorkspace, ingressTemplates);
    }

    default public String prepareIngressTemplateFiles(String buildWorkspace, String ingressTemplates) {
        String string;
        File workspaceDir = new File(buildWorkspace);
        Object object = !workspaceDir.exists() ? BoxesRunTime.boxToBoolean((boolean)workspaceDir.mkdir()) : BoxedUnit.UNIT;
        if (ingressTemplates.isEmpty()) {
            string = null;
        } else {
            String outputPath = new StringBuilder(13).append(buildWorkspace).append("/ingress.yaml").toString();
            File outputFile = new File(outputPath);
            FileUtils.write((File)outputFile, (CharSequence)ingressTemplates, (String)"UTF-8");
            string = outputPath;
        }
        return string;
    }

    public static /* synthetic */ Map buildIngressAnnotations$(IngressStrategy $this, String clusterId, String namespace) {
        return $this.buildIngressAnnotations(clusterId, namespace);
    }

    default public Map<String, String> buildIngressAnnotations(String clusterId, String namespace) {
        return (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"nginx.ingress.kubernetes.io/rewrite-target"), (Object)"/$2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"nginx.ingress.kubernetes.io/proxy-body-size"), (Object)"1024m"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"nginx.ingress.kubernetes.io/configuration-snippet"), (Object)new StringBuilder(100).append("rewrite ^(/").append(clusterId).append(")$ $1/ permanent; sub_filter '<base href=\"./\">' '<base href=\"/").append(namespace).append("/").append(clusterId).append("/\">'; sub_filter_once off;").toString())}));
    }

    public static /* synthetic */ Map buildIngressLabels$(IngressStrategy $this, String clusterId) {
        return $this.buildIngressLabels(clusterId);
    }

    default public Map<String, String> buildIngressLabels(String clusterId) {
        return (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"app"), (Object)clusterId), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"type"), (Object)"flink-native-kubernetes"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"component"), (Object)"ingress")}));
    }

    public static /* synthetic */ OwnerReference getOwnerReference$(IngressStrategy $this, String nameSpace, String clusterId, DefaultKubernetesClient client) {
        return $this.getOwnerReference(nameSpace, clusterId, client);
    }

    default public OwnerReference getOwnerReference(String nameSpace, String clusterId, DefaultKubernetesClient client) {
        Deployment deployment = (Deployment)((Gettable)((Nameable)client.apps().deployments().inNamespace(nameSpace)).withName(clusterId)).get();
        Predef$.MODULE$.require(deployment != null, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(45).append("Deployment with name ").append(clusterId).append(" not found in namespace ").append(nameSpace).toString());
        return ((OwnerReferenceBuilder)((OwnerReferenceFluentImpl)((OwnerReferenceFluentImpl)((OwnerReferenceFluentImpl)((OwnerReferenceFluentImpl)((OwnerReferenceFluentImpl)new OwnerReferenceBuilder().withUid(deployment.getMetadata().getUid())).withApiVersion("apps/v1")).withKind("Deployment")).withName(clusterId)).withController(Predef$.MODULE$.boolean2Boolean(true))).withBlockOwnerDeletion(Predef$.MODULE$.boolean2Boolean(true))).build();
    }

    public static void $init$(IngressStrategy $this) {
    }
}

