/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint.channel;

import java.util.concurrent.atomic.AtomicReference;
import org.apache.flink.runtime.checkpoint.channel.ChannelStateCheckpointWriter;
import org.apache.flink.runtime.checkpoint.channel.ChannelStateWriteRequest;
import org.apache.flink.runtime.checkpoint.channel.CheckpointInProgressRequestState;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.function.ThrowingConsumer;

final class CheckpointInProgressRequest
implements ChannelStateWriteRequest {
    private final ThrowingConsumer<ChannelStateCheckpointWriter, Exception> action;
    private final ThrowingConsumer<Throwable, Exception> discardAction;
    private final long checkpointId;
    private final String name;
    private final boolean ignoreMissingWriter;
    private final AtomicReference<CheckpointInProgressRequestState> state = new AtomicReference<CheckpointInProgressRequestState>(CheckpointInProgressRequestState.NEW);

    CheckpointInProgressRequest(String name, long checkpointId, ThrowingConsumer<ChannelStateCheckpointWriter, Exception> action, boolean ignoreMissingWriter) {
        this(name, checkpointId, action, (ThrowingConsumer<Throwable, Exception>)((ThrowingConsumer)unused -> {}), ignoreMissingWriter);
    }

    CheckpointInProgressRequest(String name, long checkpointId, ThrowingConsumer<ChannelStateCheckpointWriter, Exception> action, ThrowingConsumer<Throwable, Exception> discardAction, boolean ignoreMissingWriter) {
        this.checkpointId = checkpointId;
        this.action = (ThrowingConsumer)Preconditions.checkNotNull(action);
        this.discardAction = (ThrowingConsumer)Preconditions.checkNotNull(discardAction);
        this.name = (String)Preconditions.checkNotNull((Object)name);
        this.ignoreMissingWriter = ignoreMissingWriter;
    }

    @Override
    public long getCheckpointId() {
        return this.checkpointId;
    }

    @Override
    public void cancel(Throwable cause) throws Exception {
        if (this.state.compareAndSet(CheckpointInProgressRequestState.NEW, CheckpointInProgressRequestState.CANCELLED) || this.state.compareAndSet(CheckpointInProgressRequestState.FAILED, CheckpointInProgressRequestState.CANCELLED)) {
            this.discardAction.accept((Object)cause);
        }
    }

    void execute(ChannelStateCheckpointWriter channelStateCheckpointWriter) throws Exception {
        Preconditions.checkState((boolean)this.state.compareAndSet(CheckpointInProgressRequestState.NEW, CheckpointInProgressRequestState.EXECUTING));
        try {
            this.action.accept((Object)channelStateCheckpointWriter);
            this.state.set(CheckpointInProgressRequestState.COMPLETED);
        }
        catch (Exception e) {
            this.state.set(CheckpointInProgressRequestState.FAILED);
            throw e;
        }
    }

    void onWriterMissing() {
        if (!this.ignoreMissingWriter) {
            throw new IllegalArgumentException("writer not found while processing request: " + this.toString());
        }
    }

    public String toString() {
        return this.name + " " + this.checkpointId;
    }
}

