/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.csp;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import org.apache.wicket.csp.CSPDirectiveSandboxValue;
import org.apache.wicket.csp.CSPDirectiveSrcValue;
import org.apache.wicket.csp.CSPRenderable;
import org.apache.wicket.csp.FixedCSPValue;
import org.apache.wicket.csp.RelativeURICSPValue;
import org.apache.wicket.util.string.Strings;

public enum CSPDirective {
    DEFAULT_SRC("default-src"),
    SCRIPT_SRC("script-src"),
    STYLE_SRC("style-src"),
    IMG_SRC("img-src"),
    CONNECT_SRC("connect-src"),
    FONT_SRC("font-src"),
    OBJECT_SRC("object-src"),
    MANIFEST_SRC("manifest-src"),
    MEDIA_SRC("media-src"),
    CHILD_SRC("child-src"),
    WORKER_SRC("worker-src"),
    FRAME_ANCESTORS("frame-ancestors"),
    BASE_URI("base-uri"),
    FRAME_SRC("frame-src"),
    FORM_ACTION("form-action"),
    SANDBOX("sandbox"){

        @Override
        public void checkValueForDirective(CSPRenderable value, List<CSPRenderable> existingDirectiveValues) {
            if (!existingDirectiveValues.isEmpty()) {
                if (CSPDirectiveSandboxValue.EMPTY.equals(value)) {
                    throw new IllegalArgumentException("A sandbox directive can't contain an empty string if it already contains other values: " + existingDirectiveValues);
                }
                if (existingDirectiveValues.contains(CSPDirectiveSandboxValue.EMPTY)) {
                    throw new IllegalArgumentException("A sandbox directive can't contain other values if it already contains an empty string, can't add " + value);
                }
            }
            if (!(value instanceof CSPDirectiveSandboxValue)) {
                throw new IllegalArgumentException("A sandbox directive can only contain values from CSPDirectiveSandboxValue or be empty, can't add " + value);
            }
        }
    }
    ,
    REPORT_URI("report-uri"){

        @Override
        public void checkValueForDirective(CSPRenderable value, List<CSPRenderable> existingDirectiveValues) {
            if (!existingDirectiveValues.isEmpty()) {
                throw new IllegalArgumentException("A report-uri directive can only contain one URI, it already contains " + existingDirectiveValues);
            }
            if (value instanceof RelativeURICSPValue) {
                return;
            }
            if (!(value instanceof FixedCSPValue)) {
                throw new IllegalArgumentException("A report-uri directive can only contain an URI, not " + value);
            }
            try {
                new URI(value.toString());
            }
            catch (URISyntaxException urise) {
                throw new IllegalArgumentException("Illegal URI for report-uri directive", urise);
            }
        }
    };

    private String value;

    private CSPDirective(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public void checkValueForDirective(CSPRenderable value, List<CSPRenderable> existingDirectiveValues) {
        if (!existingDirectiveValues.isEmpty()) {
            if (CSPDirectiveSrcValue.WILDCARD.equals(value) || CSPDirectiveSrcValue.NONE.equals(value)) {
                throw new IllegalArgumentException("A -src directive can't contain an * or a 'none' if it already contains other values: " + existingDirectiveValues);
            }
            if (existingDirectiveValues.contains(CSPDirectiveSrcValue.WILDCARD) || existingDirectiveValues.contains(CSPDirectiveSrcValue.NONE)) {
                throw new IllegalArgumentException("A -src directive can't contain other values if it already contains an * or a 'none', can't add " + value);
            }
        }
        if (value instanceof CSPDirectiveSandboxValue) {
            throw new IllegalArgumentException("A -src directive can't contain any of the sandbox directive values, like " + value);
        }
        value.checkValidityForSrc();
    }

    public static CSPDirective fromValue(String value) {
        if (Strings.isEmpty((String)value)) {
            return null;
        }
        for (int i = 0; i < CSPDirective.values().length; ++i) {
            if (!value.equals(CSPDirective.values()[i].getValue())) continue;
            return CSPDirective.values()[i];
        }
        return null;
    }
}

