/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.api.jexl;

import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Field;
import java.time.temporal.TemporalAccessor;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.jexl3.JexlBuilder;
import org.apache.commons.jexl3.JexlContext;
import org.apache.commons.jexl3.JexlEngine;
import org.apache.commons.jexl3.JexlException;
import org.apache.commons.jexl3.JexlExpression;
import org.apache.commons.jexl3.JxltEngine;
import org.apache.commons.jexl3.MapContext;
import org.apache.commons.jexl3.introspection.JexlPermissions;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.common.lib.Attr;
import org.apache.syncope.common.lib.to.AnyTO;
import org.apache.syncope.common.lib.to.RealmTO;
import org.apache.syncope.core.persistence.api.entity.Any;
import org.apache.syncope.core.persistence.api.entity.DerSchema;
import org.apache.syncope.core.persistence.api.entity.PlainAttr;
import org.apache.syncope.core.persistence.api.entity.Realm;
import org.apache.syncope.core.provisioning.api.DerAttrHandler;
import org.apache.syncope.core.provisioning.api.jexl.EmptyClassLoader;
import org.apache.syncope.core.provisioning.api.jexl.SyncopeJexlFunctions;
import org.apache.syncope.core.provisioning.api.utils.FormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ReflectionUtils;

public final class JexlUtils {
    private static final Logger LOG = LoggerFactory.getLogger(JexlUtils.class);
    private static final String[] IGNORE_FIELDS = new String[]{"password", "clearPassword", "serialVersionUID", "class"};
    private static final Map<Class<?>, Set<Pair<PropertyDescriptor, Field>>> FIELD_CACHE = Collections.synchronizedMap(new HashMap());
    private static JexlEngine JEXL_ENGINE;
    private static JxltEngine JXTL_ENGINE;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static JexlEngine getJexlEngine() {
        Logger logger = LOG;
        synchronized (logger) {
            if (JEXL_ENGINE == null) {
                JEXL_ENGINE = new JexlBuilder().loader((ClassLoader)new EmptyClassLoader()).permissions(JexlPermissions.RESTRICTED.compose(new String[]{"java.time.*", "org.apache.syncope.*"})).namespaces(Map.of("syncope", new SyncopeJexlFunctions())).cache(512).silent(false).strict(false).create();
            }
        }
        return JEXL_ENGINE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static JxltEngine getJxltEngine() {
        Logger logger = LOG;
        synchronized (logger) {
            if (JXTL_ENGINE == null) {
                JXTL_ENGINE = JexlUtils.getJexlEngine().createJxltEngine(false);
            }
        }
        return JXTL_ENGINE;
    }

    public static boolean isExpressionValid(String expression) {
        boolean result;
        try {
            JexlUtils.getJexlEngine().createExpression(expression);
            result = true;
        }
        catch (JexlException e) {
            LOG.error("Invalid JEXL expression: " + expression, (Throwable)e);
            result = false;
        }
        return result;
    }

    public static Object evaluateExpr(String expression, JexlContext jexlContext) {
        Object result = null;
        if (StringUtils.isNotBlank((CharSequence)expression) && jexlContext != null) {
            try {
                JexlExpression jexlExpression = JexlUtils.getJexlEngine().createExpression(expression);
                result = jexlExpression.evaluate(jexlContext);
            }
            catch (Exception e) {
                LOG.error("Error while evaluating JEXL expression: " + expression, (Throwable)e);
            }
        } else {
            LOG.debug("Expression not provided or invalid context");
        }
        return Optional.ofNullable(result).orElse("");
    }

    public static String evaluateTemplate(String template, JexlContext jexlContext) {
        String result = null;
        if (StringUtils.isNotBlank((CharSequence)template) && jexlContext != null) {
            try {
                StringWriter writer = new StringWriter();
                JexlUtils.getJxltEngine().createTemplate(template).evaluate(jexlContext, (Writer)writer);
                result = writer.toString();
            }
            catch (Exception e) {
                LOG.error("Error while evaluating JEXL template: " + template, (Throwable)e);
            }
        } else {
            LOG.debug("Template not provided or invalid context");
        }
        return Optional.ofNullable(result).orElse(template);
    }

    public static void addFieldsToContext(Object object, JexlContext jexlContext) {
        if (object == null) {
            return;
        }
        Set<Pair<PropertyDescriptor, Field>> cached = FIELD_CACHE.get(object.getClass());
        if (cached == null) {
            FIELD_CACHE.put(object.getClass(), Collections.synchronizedSet(new HashSet()));
            List classes = ClassUtils.getAllSuperclasses(object.getClass());
            classes.add(object.getClass());
            classes.forEach(clazz -> {
                try {
                    for (PropertyDescriptor desc : Introspector.getBeanInfo(clazz).getPropertyDescriptors()) {
                        if (desc.getName().startsWith("pc") || ArrayUtils.contains((Object[])IGNORE_FIELDS, (Object)desc.getName()) || Collection.class.isAssignableFrom(desc.getPropertyType()) || Map.class.isAssignableFrom(desc.getPropertyType()) || desc.getPropertyType().isArray()) continue;
                        Field field = null;
                        try {
                            field = clazz.getDeclaredField(desc.getName());
                        }
                        catch (NoSuchFieldException | SecurityException e) {
                            LOG.debug("Could not get field {} from {}", new Object[]{desc.getName(), clazz.getName(), e});
                        }
                        FIELD_CACHE.get(object.getClass()).add((Pair<PropertyDescriptor, Field>)Pair.of((Object)desc, (Object)field));
                    }
                }
                catch (IntrospectionException e) {
                    LOG.warn("Could not introspect {}", (Object)clazz.getName(), (Object)e);
                }
            });
            cached = FIELD_CACHE.get(object.getClass());
        }
        cached.forEach(fd -> {
            String fieldName = ((PropertyDescriptor)fd.getLeft()).getName();
            Class<?> fieldType = ((PropertyDescriptor)fd.getLeft()).getPropertyType();
            try {
                Object fieldValue = null;
                if (((PropertyDescriptor)fd.getLeft()).getReadMethod() == null) {
                    if (fd.getRight() != null) {
                        ReflectionUtils.makeAccessible((Field)((Field)fd.getRight()));
                        fieldValue = ((Field)fd.getRight()).get(object);
                    }
                } else {
                    fieldValue = ((PropertyDescriptor)fd.getLeft()).getReadMethod().invoke(object, new Object[0]);
                }
                fieldValue = fieldValue == null ? "" : (TemporalAccessor.class.isAssignableFrom(fieldType) ? FormatUtils.format((TemporalAccessor)fieldValue) : fieldValue);
                jexlContext.set(fieldName, fieldValue);
                LOG.debug("Add field {} with value {}", (Object)fieldName, fieldValue);
            }
            catch (Exception iae) {
                LOG.error("Reading '{}' value error", (Object)fieldName, (Object)iae);
            }
        });
        if (object instanceof Any && ((Any)object).getRealm() != null) {
            jexlContext.set("realm", (Object)((Any)object).getRealm().getFullPath());
        } else if (object instanceof AnyTO && ((AnyTO)object).getRealm() != null) {
            jexlContext.set("realm", (Object)((AnyTO)object).getRealm());
        } else if (object instanceof Realm) {
            jexlContext.set("fullPath", (Object)((Realm)object).getFullPath());
        } else if (object instanceof RealmTO) {
            jexlContext.set("fullPath", (Object)((RealmTO)object).getFullPath());
        }
    }

    public static void addAttrsToContext(Collection<Attr> attrs, JexlContext jexlContext) {
        attrs.stream().filter(attr -> attr.getSchema() != null).forEach(attr -> {
            Object value = attr.getValues().isEmpty() ? "" : (attr.getValues().size() == 1 ? attr.getValues().get(0) : attr.getValues());
            LOG.debug("Add attribute {} with value {}", (Object)attr.getSchema(), value);
            jexlContext.set(attr.getSchema(), value);
        });
    }

    public static void addPlainAttrsToContext(Collection<? extends PlainAttr<?>> attrs, JexlContext jexlContext) {
        attrs.stream().filter(attr -> attr.getSchema() != null).forEach(attr -> {
            List attrValues = attr.getValuesAsStrings();
            Object value = attrValues.isEmpty() ? "" : (attrValues.size() == 1 ? attrValues.get(0) : attrValues);
            LOG.debug("Add attribute {} with value {}", (Object)attr.getSchema().getKey(), value);
            jexlContext.set(attr.getSchema().getKey(), value);
        });
    }

    public static void addDerAttrsToContext(Any<?> any, DerAttrHandler derAttrHandler, JexlContext jexlContext) {
        Map<DerSchema, String> derAttrs = derAttrHandler.getValues(any);
        derAttrs.forEach((schema, value) -> jexlContext.set(schema.getKey(), value));
    }

    public static boolean evaluateMandatoryCondition(String mandatoryCondition, Any<?> any, DerAttrHandler derAttrHandler) {
        MapContext jexlContext = new MapContext();
        JexlUtils.addPlainAttrsToContext(any.getPlainAttrs(), (JexlContext)jexlContext);
        JexlUtils.addDerAttrsToContext(any, derAttrHandler, (JexlContext)jexlContext);
        return Boolean.parseBoolean(JexlUtils.evaluateExpr(mandatoryCondition, (JexlContext)jexlContext).toString());
    }

    private JexlUtils() {
    }
}

