/*
 * Decompiled with CFR 0.152.
 */
package com.okta.commons.lang;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;

public final class XdgConfig {
    private static final String OKTA = "okta";
    private static final String DOT_OKTA = ".okta";

    private XdgConfig() {
    }

    public static File getConfigFile(String relativeConfigFile) {
        return new File(XdgConfig.getConfigDirectory(), relativeConfigFile);
    }

    public static File getConfigDirectory() {
        ArrayList<File> configOptions = new ArrayList<File>();
        Map<String, String> envVars = System.getenv();
        configOptions.add(new File(envVars.getOrDefault("XDG_CONFIG_HOME", XdgConfig.userHome() + "/.config"), OKTA));
        Optional.ofNullable(envVars.getOrDefault("XDG_CONFIG_DIRS", "/etc/xdg")).map(value -> value.split(File.pathSeparator)).ifPresent(values -> Arrays.stream(values).forEachOrdered(value -> configOptions.add(new File((String)value, OKTA))));
        File defaultDirectory = new File(XdgConfig.userHome(), DOT_OKTA);
        configOptions.add(defaultDirectory);
        return configOptions.stream().filter(File::exists).findFirst().orElse(defaultDirectory);
    }

    private static String userHome() {
        return System.getProperty("user.home");
    }
}

