/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.common.lib.to;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.syncope.common.lib.to.AnyTO;
import org.apache.syncope.common.lib.to.GroupableRelatableTO;
import org.apache.syncope.common.lib.to.MembershipTO;
import org.apache.syncope.common.lib.to.RelationshipTO;

@Schema(allOf={AnyTO.class})
public class AnyObjectTO
extends AnyTO
implements GroupableRelatableTO {
    private static final long serialVersionUID = 8841697496476959639L;
    private String name;
    private final List<RelationshipTO> relationships = new ArrayList<RelationshipTO>();
    private final List<MembershipTO> memberships = new ArrayList<MembershipTO>();
    private final List<MembershipTO> dynMemberships = new ArrayList<MembershipTO>();

    @Override
    @JacksonXmlProperty(localName="_class", isAttribute=true)
    @JsonProperty(value="_class")
    @Schema(name="_class", requiredMode=Schema.RequiredMode.REQUIRED, example="org.apache.syncope.common.lib.to.AnyObjectTO")
    public String getDiscriminator() {
        return this.getClass().getName();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    @JsonIgnore
    public Optional<RelationshipTO> getRelationship(String type, String otherKey) {
        return this.relationships.stream().filter(relationship -> type.equals(relationship.getType()) && otherKey.equals(relationship.getOtherEndKey())).findFirst();
    }

    @Override
    @JacksonXmlElementWrapper(localName="relationships")
    @JacksonXmlProperty(localName="relationship")
    public List<RelationshipTO> getRelationships() {
        return this.relationships;
    }

    @Override
    @JsonIgnore
    public Optional<MembershipTO> getMembership(String groupKey) {
        return this.memberships.stream().filter(membership -> groupKey.equals(membership.getGroupKey())).findFirst();
    }

    @Override
    @JacksonXmlElementWrapper(localName="memberships")
    @JacksonXmlProperty(localName="membership")
    public List<MembershipTO> getMemberships() {
        return this.memberships;
    }

    @Override
    @JacksonXmlElementWrapper(localName="dynMemberships")
    @JacksonXmlProperty(localName="dynMembership")
    public List<MembershipTO> getDynMemberships() {
        return this.dynMemberships;
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().appendSuper(super.hashCode()).append((Object)this.name).append(this.relationships).append(this.memberships).append(this.dynMemberships).build();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AnyObjectTO other = (AnyObjectTO)obj;
        return new EqualsBuilder().appendSuper(super.equals(obj)).append((Object)this.name, (Object)other.name).append(this.relationships, other.relationships).append(this.memberships, other.memberships).append(this.dynMemberships, other.dynMemberships).build();
    }
}

