/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.framework.impl.api;

import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import org.identityconnectors.common.CollectionUtil;
import org.identityconnectors.framework.api.ConfigurationProperties;
import org.identityconnectors.framework.api.ConfigurationProperty;
import org.identityconnectors.framework.impl.api.APIConfigurationImpl;
import org.identityconnectors.framework.impl.api.ConfigurationPropertyImpl;

public class ConfigurationPropertiesImpl
implements ConfigurationProperties {
    LinkedHashMap<String, ConfigurationPropertyImpl> properties;
    private transient APIConfigurationImpl parent;
    private static final Comparator<ConfigurationPropertyImpl> COMPARATOR = new PropertyComparator();
    private static final String MSG = "Property ''{0}'' does not exist.";

    public APIConfigurationImpl getParent() {
        return this.parent;
    }

    public void setParent(APIConfigurationImpl parent) {
        this.parent = parent;
    }

    public void setProperties(Collection<ConfigurationPropertyImpl> in) {
        ArrayList<ConfigurationPropertyImpl> properties = new ArrayList<ConfigurationPropertyImpl>(in);
        Collections.sort(properties, COMPARATOR);
        LinkedHashMap<String, ConfigurationPropertyImpl> temp = new LinkedHashMap<String, ConfigurationPropertyImpl>();
        for (ConfigurationPropertyImpl property : properties) {
            temp.put(property.getName(), property);
            property.setParent(this);
        }
        this.properties = temp;
    }

    public Collection<ConfigurationPropertyImpl> getProperties() {
        return this.properties.values();
    }

    public ConfigurationProperty getProperty(String name) {
        return this.properties.get(name);
    }

    public List<String> getPropertyNames() {
        ArrayList<String> names = new ArrayList<String>(this.properties.keySet());
        return CollectionUtil.newReadOnlyList(names);
    }

    public void setPropertyValue(String name, Object value) {
        ConfigurationPropertyImpl property = this.properties.get(name);
        if (property == null) {
            throw new IllegalArgumentException(MessageFormat.format(MSG, name));
        }
        property.setValue(value);
    }

    public boolean equals(Object o) {
        if (o instanceof ConfigurationPropertiesImpl) {
            ConfigurationPropertiesImpl other = (ConfigurationPropertiesImpl)o;
            HashSet<ConfigurationPropertyImpl> set1 = new HashSet<ConfigurationPropertyImpl>(this.properties.values());
            HashSet<ConfigurationPropertyImpl> set2 = new HashSet<ConfigurationPropertyImpl>(other.properties.values());
            return set1.equals(set2);
        }
        return false;
    }

    public int hashCode() {
        HashSet<ConfigurationPropertyImpl> set1 = new HashSet<ConfigurationPropertyImpl>(this.properties.values());
        return set1.hashCode();
    }

    private static class PropertyComparator
    implements Comparator<ConfigurationPropertyImpl>,
    Serializable {
        private static final long serialVersionUID = 1L;

        private PropertyComparator() {
        }

        @Override
        public int compare(ConfigurationPropertyImpl o1, ConfigurationPropertyImpl o2) {
            int or2;
            int or1 = o1.getOrder();
            return or1 < (or2 = o2.getOrder()) ? -1 : (or1 > or2 ? 1 : 0);
        }
    }
}

