/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.pages;

import java.io.Serializable;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.List;
import org.apache.syncope.client.console.SyncopeConsoleSession;
import org.apache.syncope.client.console.SyncopeWebApplication;
import org.apache.syncope.client.ui.commons.BaseLogin;
import org.apache.syncope.client.ui.commons.BaseSession;
import org.apache.syncope.client.ui.commons.panels.BaseSSOLoginFormPanel;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.authentication.IAuthenticationStrategy;
import org.apache.wicket.authroles.authentication.AuthenticatedWebSession;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.request.mapper.parameter.PageParameters;

public class Login
extends BaseLogin {
    private static final long serialVersionUID = 5889157642852559004L;

    public Login(PageParameters parameters) {
        super(parameters);
    }

    protected BaseSession getBaseSession() {
        return SyncopeConsoleSession.get();
    }

    protected List<BaseSSOLoginFormPanel> getSSOLoginFormPanels() {
        ArrayList<BaseSSOLoginFormPanel> ssoLoginFormPanels = new ArrayList<BaseSSOLoginFormPanel>();
        SyncopeWebApplication.get().getLookup().getClasses(BaseSSOLoginFormPanel.class).forEach(ssoLoginFormPanel -> {
            try {
                ssoLoginFormPanels.add((BaseSSOLoginFormPanel)ssoLoginFormPanel.getConstructor(String.class, BaseSession.class).newInstance(new Object[]{"ssoLogin", SyncopeConsoleSession.get()}));
            }
            catch (Exception e) {
                LOG.error("Could not initialize the provided SSO login form panel", (Throwable)e);
            }
        });
        return ssoLoginFormPanels;
    }

    protected void sendError(String error) {
        SyncopeConsoleSession.get().error((Serializable)((Object)error));
    }

    protected void authenticate(String username, String password, AjaxRequestTarget target) throws AccessControlException {
        if (SyncopeWebApplication.get().getAnonymousUser().equals(username)) {
            throw new AccessControlException("Illegal username");
        }
        IAuthenticationStrategy strategy = this.getApplication().getSecuritySettings().getAuthenticationStrategy();
        if (AuthenticatedWebSession.get().signIn(username, password)) {
            this.continueToOriginalDestination();
            this.setResponsePage(this.getApplication().getHomePage());
        } else {
            SyncopeConsoleSession.get().error((Serializable)((Object)this.getString("login-error")));
            this.notificationPanel.refresh((IPartialPageRequestHandler)target);
        }
        strategy.remove();
    }
}

