/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import java.util.List;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.features.CasFeatureModule;
import org.apereo.cas.configuration.model.support.syncope.SyncopePrincipalAttributesProperties;
import org.apereo.cas.persondir.PersonDirectoryAttributeRepositoryPlan;
import org.apereo.cas.persondir.PersonDirectoryAttributeRepositoryPlanConfigurer;
import org.apereo.cas.syncope.SyncopePersonAttributeDao;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.util.spring.beans.BeanCondition;
import org.apereo.cas.util.spring.beans.BeanContainer;
import org.apereo.cas.util.spring.beans.BeanSupplier;
import org.apereo.cas.util.spring.boot.ConditionalOnFeatureEnabled;
import org.apereo.services.persondir.IPersonAttributeDao;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.core.env.PropertyResolver;

@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@ConditionalOnFeatureEnabled(feature=CasFeatureModule.FeatureCatalog.PersonDirectory, module="syncope")
@AutoConfiguration
public class SyncopePersonDirectoryConfiguration {
    private static final BeanCondition CONDITION = BeanCondition.on((String)"cas.authn.attribute-repository.syncope.url").isUrl();

    @ConditionalOnMissingBean(name={"syncopePersonAttributeDaos"})
    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    public BeanContainer<IPersonAttributeDao> syncopePersonAttributeDaos(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties) throws Exception {
        return (BeanContainer)BeanSupplier.of(BeanContainer.class).when(CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> {
            SyncopePrincipalAttributesProperties properties = casProperties.getAuthn().getAttributeRepository().getSyncope();
            SyncopePersonAttributeDao dao = new SyncopePersonAttributeDao(properties);
            dao.setOrder(properties.getOrder());
            FunctionUtils.doIfNotNull((Object)properties.getId(), xva$0 -> dao.setId(new String[]{xva$0}));
            return BeanContainer.of((List)CollectionUtils.wrapList((Object[])new SyncopePersonAttributeDao[]{dao}));
        }).otherwise(BeanContainer::empty).get();
    }

    @ConditionalOnMissingBean(name={"syncopeAttributeRepositoryPlanConfigurer"})
    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    public PersonDirectoryAttributeRepositoryPlanConfigurer syncopeAttributeRepositoryPlanConfigurer(@Qualifier(value="syncopePersonAttributeDaos") BeanContainer<IPersonAttributeDao> syncopePersonAttributeDaos) {
        return plan -> syncopePersonAttributeDaos.toList().forEach(arg_0 -> ((PersonDirectoryAttributeRepositoryPlan)plan).registerAttributeRepository(arg_0));
    }
}

