/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.pac4j;

import java.util.Optional;
import javax.servlet.http.HttpSession;
import lombok.Generated;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.jee.context.session.JEESessionStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrefixedSessionStore
extends JEESessionStore {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(PrefixedSessionStore.class);
    private String prefix = "";

    public PrefixedSessionStore() {
    }

    protected PrefixedSessionStore(HttpSession httpSession) {
        super(httpSession);
    }

    protected String computePrefixedKey(String key) {
        return this.prefix + key;
    }

    public Optional<Object> get(WebContext context, String key) {
        Optional httpSession = this.getNativeSession(context, false);
        String prefixedKey = this.computePrefixedKey(key);
        if (httpSession.isPresent()) {
            Object value = ((HttpSession)httpSession.get()).getAttribute(prefixedKey);
            LOGGER.debug("Get value: [{}] for key: [{}]", value, (Object)prefixedKey);
            return Optional.ofNullable(value);
        }
        LOGGER.debug("Can't get value for key: [{}], no session available", (Object)prefixedKey);
        return Optional.empty();
    }

    public void set(WebContext context, String key, Object value) {
        String prefixedKey = this.computePrefixedKey(key);
        if (value == null) {
            Optional httpSession = this.getNativeSession(context, false);
            if (httpSession.isPresent()) {
                LOGGER.debug("Remove value for key: [{}]", (Object)prefixedKey);
                ((HttpSession)httpSession.get()).removeAttribute(prefixedKey);
            }
        } else {
            Optional httpSession = this.getNativeSession(context, true);
            if (value instanceof Exception) {
                LOGGER.debug("Set key: [{}] for value: [{}]", (Object)prefixedKey, (Object)value.toString());
            } else {
                LOGGER.debug("Set key: [{}] for value: [{}]", (Object)prefixedKey, value);
            }
            ((HttpSession)httpSession.get()).setAttribute(prefixedKey, value);
        }
    }

    public Optional<SessionStore> buildFromTrackableSession(WebContext context, Object trackableSession) {
        if (trackableSession != null) {
            LOGGER.debug("Rebuild session from trackable session: [{}]", trackableSession);
            PrefixedSessionStore sessionStore = new PrefixedSessionStore((HttpSession)trackableSession);
            sessionStore.setPrefix(this.getPrefix());
            return Optional.of(sessionStore);
        }
        LOGGER.debug("Unable to build session from trackable session");
        return Optional.empty();
    }

    @Generated
    public String getPrefix() {
        return this.prefix;
    }

    @Generated
    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }
}

