/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.logging;

import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;
import org.apache.logging.log4j.core.filter.AbstractFilter;
import org.apache.logging.log4j.message.Message;

@Plugin(name="ExceptionOnlyFilter", category="Core", elementType="filter", printObject=true)
public class ExceptionOnlyFilter
extends AbstractFilter {
    protected ExceptionOnlyFilter() {
        super(Filter.Result.ACCEPT, Filter.Result.DENY);
    }

    public Filter.Result filter(LogEvent event) {
        if (event.getThrown() != null) {
            return this.getOnMatch();
        }
        return this.getOnMismatch();
    }

    public Filter.Result filter(Logger logger, Level level, Marker marker, Message msg, Throwable t) {
        return t != null ? this.getOnMatch() : this.getOnMismatch();
    }

    public Filter.Result filter(Logger logger, Level level, Marker marker, Object msg, Throwable t) {
        return t != null ? this.getOnMatch() : this.getOnMismatch();
    }

    public Filter.Result filter(Logger logger, Level level, Marker marker, String msg, Object ... params) {
        if (params != null && params.length > 0 && params[params.length - 1] instanceof Throwable) {
            return this.getOnMatch();
        }
        return this.getOnMismatch();
    }

    @PluginBuilderFactory
    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder
    extends AbstractFilter.AbstractFilterBuilder<Builder>
    implements org.apache.logging.log4j.core.util.Builder<ExceptionOnlyFilter> {
        public ExceptionOnlyFilter build() {
            return new ExceptionOnlyFilter();
        }
    }
}

