/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.enduser.init;

import java.io.Serializable;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.syncope.client.enduser.pages.BaseExtPage;
import org.apache.syncope.client.enduser.pages.BasePage;
import org.apache.syncope.client.ui.commons.annotations.AMPage;
import org.apache.syncope.client.ui.commons.annotations.BinaryPreview;
import org.apache.syncope.client.ui.commons.annotations.ExtPage;
import org.apache.syncope.client.ui.commons.annotations.IdMPage;
import org.apache.syncope.client.ui.commons.markup.html.form.preview.BinaryPreviewer;
import org.apache.syncope.client.ui.commons.panels.BaseSSOLoginFormPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.core.type.filter.AssignableTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.util.ClassUtils;

public class ClassPathScanImplementationLookup
implements Serializable {
    private static final long serialVersionUID = -4944986595429290116L;
    private static final Logger LOG = LoggerFactory.getLogger(ClassPathScanImplementationLookup.class);
    private static final String DEFAULT_BASE_PACKAGE = "org.apache.syncope";
    private List<Class<? extends BaseSSOLoginFormPanel>> ssoLoginFormPanels;
    private List<Class<? extends BasePage>> idmPages;
    private List<Class<? extends BasePage>> amPages;
    private List<Class<? extends BasePage>> extPages;
    private List<Class<? extends BinaryPreviewer>> previewers;

    protected static String getBasePackage() {
        return DEFAULT_BASE_PACKAGE;
    }

    public void load() {
        this.idmPages = new ArrayList<Class<? extends BasePage>>();
        this.amPages = new ArrayList<Class<? extends BasePage>>();
        this.extPages = new ArrayList<Class<? extends BasePage>>();
        this.ssoLoginFormPanels = new ArrayList<Class<? extends BaseSSOLoginFormPanel>>();
        this.previewers = new ArrayList<Class<? extends BinaryPreviewer>>();
        ClassPathScanningCandidateComponentProvider scanner = new ClassPathScanningCandidateComponentProvider(false);
        scanner.addIncludeFilter((TypeFilter)new AssignableTypeFilter(BasePage.class));
        scanner.addIncludeFilter((TypeFilter)new AssignableTypeFilter(BaseSSOLoginFormPanel.class));
        scanner.addIncludeFilter((TypeFilter)new AssignableTypeFilter(BinaryPreviewer.class));
        for (BeanDefinition bd : scanner.findCandidateComponents(ClassPathScanImplementationLookup.getBasePackage())) {
            try {
                Class clazz = ClassUtils.resolveClassName((String)Objects.requireNonNull(bd.getBeanClassName()), (ClassLoader)ClassUtils.getDefaultClassLoader());
                if (Modifier.isAbstract(clazz.getModifiers())) continue;
                if (BaseExtPage.class.isAssignableFrom(clazz)) {
                    if (clazz.isAnnotationPresent(ExtPage.class)) {
                        this.extPages.add(clazz);
                        continue;
                    }
                    LOG.error("Could not find annotation {} in {}, ignoring", (Object)ExtPage.class.getName(), (Object)clazz.getName());
                    continue;
                }
                if (BasePage.class.isAssignableFrom(clazz)) {
                    if (clazz.isAnnotationPresent(IdMPage.class)) {
                        this.idmPages.add(clazz);
                        continue;
                    }
                    if (!clazz.isAnnotationPresent(AMPage.class)) continue;
                    this.amPages.add(clazz);
                    continue;
                }
                if (BaseSSOLoginFormPanel.class.isAssignableFrom(clazz)) {
                    this.ssoLoginFormPanels.add(clazz);
                    continue;
                }
                if (!BinaryPreviewer.class.isAssignableFrom(clazz)) continue;
                this.previewers.add(clazz);
            }
            catch (Throwable t) {
                LOG.warn("Could not inspect class {}", (Object)bd.getBeanClassName(), (Object)t);
            }
        }
        this.idmPages.sort(Comparator.comparing(o -> o.getAnnotation(IdMPage.class).priority()));
        this.idmPages = Collections.unmodifiableList(this.idmPages);
        this.amPages.sort(Comparator.comparing(o -> o.getAnnotation(AMPage.class).priority()));
        this.amPages = Collections.unmodifiableList(this.amPages);
        this.ssoLoginFormPanels = Collections.unmodifiableList(this.ssoLoginFormPanels);
        LOG.debug("IdM pages found: {}", this.idmPages);
        LOG.debug("AM pages found: {}", this.amPages);
        LOG.debug("Extension pages found: {}", this.extPages);
        LOG.debug("SSO Login pages found: {}", this.ssoLoginFormPanels);
        LOG.debug("Binary previewers found: {}", this.previewers);
    }

    public List<Class<? extends BasePage>> getIdMPageClasses() {
        return this.idmPages;
    }

    public List<Class<? extends BasePage>> getAMPageClasses() {
        return this.amPages;
    }

    public List<Class<? extends BaseSSOLoginFormPanel>> getSSOLoginFormPanels() {
        return this.ssoLoginFormPanels;
    }

    public List<Class<? extends BasePage>> getExtPageClasses() {
        return this.extPages;
    }

    public Class<? extends BinaryPreviewer> getPreviewerClass(String mimeType) {
        LOG.debug("Searching for previewer class for MIME type: {}", (Object)mimeType);
        Class<? extends BinaryPreviewer> previewer = null;
        for (Class<? extends BinaryPreviewer> candidate : this.previewers) {
            LOG.debug("Evaluating previewer class {} for MIME type {}", (Object)candidate.getName(), (Object)mimeType);
            if (!candidate.isAnnotationPresent(BinaryPreview.class) || !ArrayUtils.contains((Object[])candidate.getAnnotation(BinaryPreview.class).mimeTypes(), (Object)mimeType)) continue;
            LOG.debug("Found existing previewer for MIME type {}: {}", (Object)mimeType, (Object)candidate.getName());
            previewer = candidate;
        }
        return previewer;
    }
}

