/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import org.apereo.cas.config.GoogleAuthenticatorAuthenticationComponentSerializationConfiguration;
import org.apereo.cas.config.GoogleAuthenticatorAuthenticationEventExecutionPlanConfiguration;
import org.apereo.cas.config.GoogleAuthenticatorAuthenticationMultifactorProviderBypassConfiguration;
import org.apereo.cas.config.GoogleAuthenticatorConfiguration;
import org.apereo.cas.config.GoogleAuthenticatorRestConfiguration;
import org.apereo.cas.config.MultifactorAuthnTrustConfiguration;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.features.CasFeatureModule;
import org.apereo.cas.trusted.web.flow.BasicMultifactorTrustedWebflowConfigurer;
import org.apereo.cas.util.spring.beans.BeanCondition;
import org.apereo.cas.util.spring.beans.BeanSupplier;
import org.apereo.cas.util.spring.boot.ConditionalOnFeatureEnabled;
import org.apereo.cas.web.flow.CasWebflowConfigurer;
import org.apereo.cas.web.flow.CasWebflowExecutionPlanConfigurer;
import org.apereo.cas.web.flow.util.MultifactorAuthenticationWebflowUtils;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.core.env.PropertyResolver;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.webflow.definition.registry.FlowDefinitionRegistry;
import org.springframework.webflow.engine.builder.support.FlowBuilderServices;

@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@EnableScheduling
@ConditionalOnFeatureEnabled(feature={CasFeatureModule.FeatureCatalog.GoogleAuthenticator})
@AutoConfiguration
@Import(value={GoogleAuthenticatorConfiguration.class, GoogleAuthenticatorAuthenticationEventExecutionPlanConfiguration.class, GoogleAuthenticatorAuthenticationMultifactorProviderBypassConfiguration.class, GoogleAuthenticatorAuthenticationComponentSerializationConfiguration.class, GoogleAuthenticatorRestConfiguration.class})
public class CasGoogleAuthenticatorAutoConfiguration {

    @ConditionalOnClass(value={MultifactorAuthnTrustConfiguration.class})
    @Configuration(value="GoogleAuthenticatorMultifactorTrustConfiguration", proxyBeanMethods=false)
    @DependsOn(value={"googleAuthenticatorMultifactorWebflowConfigurer"})
    @ConditionalOnFeatureEnabled(feature={CasFeatureModule.FeatureCatalog.MultifactorAuthenticationTrustedDevices}, module="gauth")
    public static class GoogleAuthenticatorMultifactorTrustConfiguration {
        private static final int WEBFLOW_CONFIGURER_ORDER = 100;
        private static final BeanCondition CONDITION = BeanCondition.on((String)"cas.authn.mfa.gauth.trusted-device-enabled").isTrue().evenIfMissing();

        @ConditionalOnMissingBean(name={"gauthMultifactorTrustWebflowConfigurer"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public CasWebflowConfigurer gauthMultifactorTrustWebflowConfigurer(@Qualifier(value="googleAuthenticatorFlowRegistry") FlowDefinitionRegistry googleAuthenticatorFlowRegistry, ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties, @Qualifier(value="flowDefinitionRegistry") FlowDefinitionRegistry flowDefinitionRegistry, @Qualifier(value="flowBuilderServices") FlowBuilderServices flowBuilderServices) {
            return (CasWebflowConfigurer)BeanSupplier.of(CasWebflowConfigurer.class).when(CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> {
                BasicMultifactorTrustedWebflowConfigurer cfg = new BasicMultifactorTrustedWebflowConfigurer(flowBuilderServices, flowDefinitionRegistry, googleAuthenticatorFlowRegistry, applicationContext, casProperties, MultifactorAuthenticationWebflowUtils.getMultifactorAuthenticationWebflowCustomizers((ConfigurableApplicationContext)applicationContext));
                cfg.setOrder(101);
                return cfg;
            }).otherwiseProxy().get();
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public CasWebflowExecutionPlanConfigurer gauthMultifactorTrustCasWebflowExecutionPlanConfigurer(ConfigurableApplicationContext applicationContext, @Qualifier(value="gauthMultifactorTrustWebflowConfigurer") CasWebflowConfigurer gauthMultifactorTrustWebflowConfigurer) {
            return (CasWebflowExecutionPlanConfigurer)BeanSupplier.of(CasWebflowExecutionPlanConfigurer.class).when(CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> plan -> plan.registerWebflowConfigurer(gauthMultifactorTrustWebflowConfigurer)).otherwiseProxy().get();
        }
    }
}

