/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import org.apereo.cas.adaptors.duo.authn.DuoSecurityAuthenticationService;
import org.apereo.cas.adaptors.duo.web.flow.DuoSecurityAuthenticationWebflowEventResolver;
import org.apereo.cas.adaptors.duo.web.flow.action.DuoSecurityAuthenticationWebflowAction;
import org.apereo.cas.adaptors.duo.web.flow.action.DuoSecurityDirectAuthenticationAction;
import org.apereo.cas.adaptors.duo.web.flow.action.DuoSecurityMultifactorAuthenticationDeviceProviderAction;
import org.apereo.cas.adaptors.duo.web.flow.action.DuoSecurityUniversalPromptPrepareLoginAction;
import org.apereo.cas.adaptors.duo.web.flow.action.DuoSecurityUniversalPromptValidateLoginAction;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.features.CasFeatureModule;
import org.apereo.cas.pac4j.BrowserWebStorageSessionStore;
import org.apereo.cas.ticket.TicketFactory;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.apereo.cas.util.crypto.CipherExecutor;
import org.apereo.cas.util.spring.beans.BeanSupplier;
import org.apereo.cas.util.spring.boot.ConditionalOnFeatureEnabled;
import org.apereo.cas.web.flow.actions.ConsumerExecutionAction;
import org.apereo.cas.web.flow.actions.MultifactorAuthenticationDeviceProviderAction;
import org.apereo.cas.web.flow.actions.WebflowActionBeanSupplier;
import org.apereo.cas.web.flow.resolver.CasWebflowEventResolver;
import org.apereo.cas.web.flow.resolver.impl.CasWebflowEventResolutionConfigurationContext;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfigureOrder;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.core.env.PropertyResolver;
import org.springframework.webflow.execution.Action;

@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@ConditionalOnFeatureEnabled(feature={CasFeatureModule.FeatureCatalog.MultifactorAuthentication}, module="duo")
@Configuration(value="DuoSecurityConfiguration", proxyBeanMethods=false)
class DuoSecurityConfiguration {
    DuoSecurityConfiguration() {
    }

    @Configuration(value="DuoSecurityAccountProfileWebflowConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    @ConditionalOnFeatureEnabled(feature={CasFeatureModule.FeatureCatalog.AccountManagement}, enabledByDefault=false)
    @AutoConfigureOrder(value=0x7FFFFFFF)
    static class DuoSecurityAccountProfileWebflowConfiguration {
        DuoSecurityAccountProfileWebflowConfiguration() {
        }

        @ConditionalOnMissingBean(name={"duoMultifactorAuthenticationDeviceProviderAction"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public MultifactorAuthenticationDeviceProviderAction duoMultifactorAuthenticationDeviceProviderAction(ConfigurableApplicationContext applicationContext) {
            return (MultifactorAuthenticationDeviceProviderAction)BeanSupplier.of(MultifactorAuthenticationDeviceProviderAction.class).when(DuoSecurityAuthenticationService.CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(DuoSecurityMultifactorAuthenticationDeviceProviderAction::new).otherwiseProxy().get();
        }
    }

    @Configuration(value="DuoSecurityCoreWebflowConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class DuoSecurityCoreWebflowConfiguration {
        DuoSecurityCoreWebflowConfiguration() {
        }

        @ConditionalOnMissingBean(name={"duoUniversalPromptSessionStore"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public BrowserWebStorageSessionStore duoUniversalPromptSessionStore(@Qualifier(value="webflowCipherExecutor") CipherExecutor webflowCipherExecutor) {
            return new BrowserWebStorageSessionStore(webflowCipherExecutor, "DuoSecuritySessionContext");
        }

        @ConditionalOnMissingBean(name={"duoNonWebAuthenticationAction"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public Action duoNonWebAuthenticationAction(CasConfigurationProperties casProperties, ConfigurableApplicationContext applicationContext) {
            return WebflowActionBeanSupplier.builder().withApplicationContext((ApplicationContext)applicationContext).withProperties(casProperties).withAction(() -> (Action)BeanSupplier.of(Action.class).when(DuoSecurityAuthenticationService.CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(DuoSecurityDirectAuthenticationAction::new).otherwise(() -> ConsumerExecutionAction.NONE).get()).withId("duoNonWebAuthenticationAction").build().get();
        }

        @ConditionalOnMissingBean(name={"duoAuthenticationWebflowAction"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public Action duoAuthenticationWebflowAction(CasConfigurationProperties casProperties, ConfigurableApplicationContext applicationContext, @Qualifier(value="duoAuthenticationWebflowEventResolver") CasWebflowEventResolver duoAuthenticationWebflowEventResolver) {
            return WebflowActionBeanSupplier.builder().withApplicationContext((ApplicationContext)applicationContext).withProperties(casProperties).withAction(() -> new DuoSecurityAuthenticationWebflowAction(duoAuthenticationWebflowEventResolver)).withId("duoAuthenticationWebflowAction").build().get();
        }

        @ConditionalOnMissingBean(name={"duoUniversalPromptPrepareLoginAction"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public Action duoUniversalPromptPrepareLoginAction(@Qualifier(value="duoUniversalPromptSessionStore") BrowserWebStorageSessionStore duoUniversalPromptSessionStore, @Qualifier(value="defaultTicketFactory") TicketFactory ticketFactory, @Qualifier(value="ticketRegistry") TicketRegistry ticketRegistry, CasConfigurationProperties casProperties, ConfigurableApplicationContext applicationContext) {
            return WebflowActionBeanSupplier.builder().withApplicationContext((ApplicationContext)applicationContext).withProperties(casProperties).withAction(() -> (Action)BeanSupplier.of(Action.class).when(DuoSecurityAuthenticationService.CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> new DuoSecurityUniversalPromptPrepareLoginAction(duoUniversalPromptSessionStore, ticketRegistry, ticketFactory)).otherwise(() -> ConsumerExecutionAction.NONE).get()).withId("duoUniversalPromptPrepareLoginAction").build().get();
        }

        @ConditionalOnMissingBean(name={"duoUniversalPromptValidateLoginAction"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public Action duoUniversalPromptValidateLoginAction(CasConfigurationProperties casProperties, ConfigurableApplicationContext applicationContext, @Qualifier(value="duoAuthenticationWebflowEventResolver") CasWebflowEventResolver duoAuthenticationWebflowEventResolver, @Qualifier(value="duoUniversalPromptSessionStore") BrowserWebStorageSessionStore duoUniversalPromptSessionStore, @Qualifier(value="ticketRegistry") TicketRegistry ticketRegistry) {
            return WebflowActionBeanSupplier.builder().withApplicationContext((ApplicationContext)applicationContext).withProperties(casProperties).withAction(() -> (Action)BeanSupplier.of(Action.class).when(DuoSecurityAuthenticationService.CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> new DuoSecurityUniversalPromptValidateLoginAction(duoAuthenticationWebflowEventResolver, duoUniversalPromptSessionStore, ticketRegistry)).otherwise(() -> ConsumerExecutionAction.NONE).get()).withId("duoUniversalPromptValidateLoginAction").build().get();
        }

        @ConditionalOnMissingBean(name={"duoAuthenticationWebflowEventResolver"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public CasWebflowEventResolver duoAuthenticationWebflowEventResolver(ConfigurableApplicationContext applicationContext, @Qualifier(value="casWebflowConfigurationContext") CasWebflowEventResolutionConfigurationContext casWebflowConfigurationContext) {
            return (CasWebflowEventResolver)BeanSupplier.of(CasWebflowEventResolver.class).when(DuoSecurityAuthenticationService.CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> new DuoSecurityAuthenticationWebflowEventResolver(casWebflowConfigurationContext)).otherwiseProxy().get();
        }
    }
}

