/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.adaptors.x509.authentication.CRLFetcher;
import org.apereo.cas.adaptors.x509.authentication.ResourceCRLFetcher;
import org.apereo.cas.adaptors.x509.authentication.handler.support.X509CredentialsAuthenticationHandler;
import org.apereo.cas.adaptors.x509.authentication.ldap.LdaptiveResourceCRLFetcher;
import org.apereo.cas.adaptors.x509.authentication.principal.DefaultX509AttributeExtractor;
import org.apereo.cas.adaptors.x509.authentication.principal.EDIPIX509AttributeExtractor;
import org.apereo.cas.adaptors.x509.authentication.principal.X509AttributeExtractor;
import org.apereo.cas.adaptors.x509.authentication.principal.X509CertificateCredential;
import org.apereo.cas.adaptors.x509.authentication.principal.X509CommonNameEDIPIPrincipalResolver;
import org.apereo.cas.adaptors.x509.authentication.principal.X509SerialNumberAndIssuerDNPrincipalResolver;
import org.apereo.cas.adaptors.x509.authentication.principal.X509SerialNumberPrincipalResolver;
import org.apereo.cas.adaptors.x509.authentication.principal.X509SubjectAlternativeNameRFC822EmailPrincipalResolver;
import org.apereo.cas.adaptors.x509.authentication.principal.X509SubjectAlternativeNameUPNPrincipalResolver;
import org.apereo.cas.adaptors.x509.authentication.principal.X509SubjectDNPrincipalResolver;
import org.apereo.cas.adaptors.x509.authentication.principal.X509SubjectPrincipalResolver;
import org.apereo.cas.adaptors.x509.authentication.revocation.checker.CRLDistributionPointRevocationChecker;
import org.apereo.cas.adaptors.x509.authentication.revocation.checker.NoOpRevocationChecker;
import org.apereo.cas.adaptors.x509.authentication.revocation.checker.ResourceCRLRevocationChecker;
import org.apereo.cas.adaptors.x509.authentication.revocation.checker.RevocationChecker;
import org.apereo.cas.adaptors.x509.authentication.revocation.policy.AllowRevocationPolicy;
import org.apereo.cas.adaptors.x509.authentication.revocation.policy.DenyRevocationPolicy;
import org.apereo.cas.adaptors.x509.authentication.revocation.policy.RevocationPolicy;
import org.apereo.cas.adaptors.x509.authentication.revocation.policy.ThresholdExpiredCRLRevocationPolicy;
import org.apereo.cas.adaptors.x509.util.X509AuthenticationUtils;
import org.apereo.cas.authentication.AuthenticationEventExecutionPlanConfigurer;
import org.apereo.cas.authentication.AuthenticationHandler;
import org.apereo.cas.authentication.CoreAuthenticationUtils;
import org.apereo.cas.authentication.attribute.AttributeDefinitionStore;
import org.apereo.cas.authentication.attribute.AttributeRepositoryResolver;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.authentication.principal.PrincipalFactoryUtils;
import org.apereo.cas.authentication.principal.PrincipalResolver;
import org.apereo.cas.authentication.principal.attribute.PersonAttributeDao;
import org.apereo.cas.authentication.principal.merger.AttributeMerger;
import org.apereo.cas.authentication.principal.resolvers.PersonDirectoryPrincipalResolver;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.features.CasFeatureModule;
import org.apereo.cas.configuration.model.core.authentication.PersonDirectoryPrincipalResolverProperties;
import org.apereo.cas.configuration.model.core.authentication.PrincipalAttributesCoreProperties;
import org.apereo.cas.configuration.model.support.ldap.AbstractLdapProperties;
import org.apereo.cas.configuration.model.support.x509.CnEdipiPrincipalResolverProperties;
import org.apereo.cas.configuration.model.support.x509.Rfc822EmailPrincipalResolverProperties;
import org.apereo.cas.configuration.model.support.x509.SerialNoDnPrincipalResolverProperties;
import org.apereo.cas.configuration.model.support.x509.SerialNoPrincipalResolverProperties;
import org.apereo.cas.configuration.model.support.x509.SubjectAltNamePrincipalResolverProperties;
import org.apereo.cas.configuration.model.support.x509.SubjectDnPrincipalResolverProperties;
import org.apereo.cas.configuration.model.support.x509.X509Properties;
import org.apereo.cas.configuration.support.Beans;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.util.LdapUtils;
import org.apereo.cas.util.RegexUtils;
import org.apereo.cas.util.serialization.ComponentSerializationPlanConfigurer;
import org.apereo.cas.util.spring.boot.ConditionalOnFeatureEnabled;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ScopedProxyMode;

@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@ConditionalOnFeatureEnabled(feature={CasFeatureModule.FeatureCatalog.X509})
@AutoConfiguration
public class CasX509AuthenticationAutoConfiguration {
    private static final int HEX = 16;

    private static X509SerialNumberPrincipalResolver getX509SerialNumberPrincipalResolver(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties, PersonAttributeDao attributeRepository, X509AttributeExtractor x509AttributeExtractor, PrincipalFactory x509PrincipalFactory, ServicesManager servicesManager, AttributeDefinitionStore attributeDefinitionStore, AttributeRepositoryResolver attributeRepositoryResolver) {
        X509Properties x509 = casProperties.getAuthn().getX509();
        SerialNoPrincipalResolverProperties serialNoProperties = x509.getSerialNo();
        PersonDirectoryPrincipalResolverProperties personDirectory = casProperties.getPersonDirectory();
        int radix = serialNoProperties.getPrincipalSNRadix();
        PersonDirectoryPrincipalResolverProperties principal = x509.getPrincipal();
        X509SerialNumberPrincipalResolver resolver = (X509SerialNumberPrincipalResolver)PersonDirectoryPrincipalResolver.newPersonDirectoryPrincipalResolver((ConfigurableApplicationContext)applicationContext, (PrincipalFactory)x509PrincipalFactory, (PersonAttributeDao)attributeRepository, (AttributeMerger)CoreAuthenticationUtils.getAttributeMerger((PrincipalAttributesCoreProperties.MergingStrategyTypes)casProperties.getAuthn().getAttributeRepository().getCore().getMerger()), X509SerialNumberPrincipalResolver.class, (ServicesManager)servicesManager, (AttributeDefinitionStore)attributeDefinitionStore, (AttributeRepositoryResolver)attributeRepositoryResolver, (PersonDirectoryPrincipalResolverProperties[])new PersonDirectoryPrincipalResolverProperties[]{principal, personDirectory});
        resolver.setX509AttributeExtractor(x509AttributeExtractor);
        if (2 <= radix && radix <= 36) {
            if (radix == 16) {
                resolver.setRadix(radix);
                resolver.setZeroPadding(serialNoProperties.isPrincipalHexSNZeroPadding());
                return resolver;
            }
            resolver.setRadix(radix);
            return resolver;
        }
        return resolver;
    }

    private static RevocationChecker getRevocationCheckerFrom(X509Properties x509, RevocationChecker resourceCrlRevocationChecker, RevocationChecker crlDistributionPointRevocationChecker, RevocationChecker noOpRevocationChecker) {
        String checker = x509.getRevocationChecker().trim();
        if ("resource".equalsIgnoreCase(checker)) {
            return resourceCrlRevocationChecker;
        }
        if ("crl".equalsIgnoreCase(checker)) {
            return crlDistributionPointRevocationChecker;
        }
        return noOpRevocationChecker;
    }

    private static RevocationPolicy getRevocationPolicy(String policy, RevocationPolicy allowRevocationPolicy, RevocationPolicy thresholdExpiredCRLRevocationPolicy, RevocationPolicy denyRevocationPolicy) {
        return switch (policy.trim().toLowerCase(Locale.ENGLISH)) {
            case "allow" -> allowRevocationPolicy;
            case "threshold" -> thresholdExpiredCRLRevocationPolicy;
            default -> denyRevocationPolicy;
        };
    }

    private static PrincipalResolver getPrincipalResolver(CasConfigurationProperties casProperties, PrincipalResolver x509SerialNumberPrincipalResolver, PrincipalResolver x509SerialNumberAndIssuerDNPrincipalResolver, PrincipalResolver x509SubjectPrincipalResolver, PrincipalResolver x509SubjectAlternativeNameUPNPrincipalResolver, PrincipalResolver x509SubjectAlternativeNameRFC822EmailPrincipalResolver, PrincipalResolver x509SubjectDNPrincipalResolver, PrincipalResolver x509CommonNameEDIPIPrincipalResolver) {
        X509Properties.PrincipalTypes type = casProperties.getAuthn().getX509().getPrincipalType();
        if (type == X509Properties.PrincipalTypes.SERIAL_NO) {
            return x509SerialNumberPrincipalResolver;
        }
        if (type == X509Properties.PrincipalTypes.SERIAL_NO_DN) {
            return x509SerialNumberAndIssuerDNPrincipalResolver;
        }
        if (type == X509Properties.PrincipalTypes.SUBJECT) {
            return x509SubjectPrincipalResolver;
        }
        if (type == X509Properties.PrincipalTypes.SUBJECT_ALT_NAME) {
            return x509SubjectAlternativeNameUPNPrincipalResolver;
        }
        if (type == X509Properties.PrincipalTypes.RFC822_EMAIL) {
            return x509SubjectAlternativeNameRFC822EmailPrincipalResolver;
        }
        if (type == X509Properties.PrincipalTypes.CN_EDIPI) {
            return x509CommonNameEDIPIPrincipalResolver;
        }
        return x509SubjectDNPrincipalResolver;
    }

    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    @ConditionalOnMissingBean(name={"allowRevocationPolicy"})
    public RevocationPolicy allowRevocationPolicy() {
        return new AllowRevocationPolicy();
    }

    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    @ConditionalOnMissingBean(name={"thresholdExpiredCRLRevocationPolicy"})
    public RevocationPolicy thresholdExpiredCRLRevocationPolicy(CasConfigurationProperties casProperties) {
        return new ThresholdExpiredCRLRevocationPolicy(casProperties.getAuthn().getX509().getRevocationPolicyThreshold());
    }

    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    @ConditionalOnMissingBean(name={"denyRevocationPolicy"})
    public RevocationPolicy denyRevocationPolicy() {
        return new DenyRevocationPolicy();
    }

    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    @ConditionalOnMissingBean(name={"crlDistributionPointRevocationChecker"})
    public RevocationChecker crlDistributionPointRevocationChecker(CasConfigurationProperties casProperties, @Qualifier(value="crlFetcher") CRLFetcher crlFetcher, @Qualifier(value="allowRevocationPolicy") RevocationPolicy allowRevocationPolicy, @Qualifier(value="thresholdExpiredCRLRevocationPolicy") RevocationPolicy thresholdExpiredCRLRevocationPolicy, @Qualifier(value="denyRevocationPolicy") RevocationPolicy denyRevocationPolicy) {
        X509Properties x509 = casProperties.getAuthn().getX509();
        Cache cache = Caffeine.newBuilder().maximumSize((long)x509.getCacheMaxElementsInMemory()).expireAfterWrite(Beans.newDuration((String)x509.getCacheTimeToLiveSeconds())).build();
        return new CRLDistributionPointRevocationChecker(x509.isCheckAll(), CasX509AuthenticationAutoConfiguration.getRevocationPolicy(x509.getCrlUnavailablePolicy(), allowRevocationPolicy, thresholdExpiredCRLRevocationPolicy, denyRevocationPolicy), CasX509AuthenticationAutoConfiguration.getRevocationPolicy(x509.getCrlExpiredPolicy(), allowRevocationPolicy, thresholdExpiredCRLRevocationPolicy, denyRevocationPolicy), cache, crlFetcher, x509.isThrowOnFetchFailure());
    }

    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    @ConditionalOnMissingBean(name={"noOpRevocationChecker"})
    public RevocationChecker noOpRevocationChecker() {
        return new NoOpRevocationChecker();
    }

    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    @ConditionalOnMissingBean(name={"resourceCrlRevocationChecker"})
    public RevocationChecker resourceCrlRevocationChecker(CasConfigurationProperties casProperties, ConfigurableApplicationContext applicationContext, @Qualifier(value="allowRevocationPolicy") RevocationPolicy allowRevocationPolicy, @Qualifier(value="thresholdExpiredCRLRevocationPolicy") RevocationPolicy thresholdExpiredCRLRevocationPolicy, @Qualifier(value="denyRevocationPolicy") RevocationPolicy denyRevocationPolicy, @Qualifier(value="crlFetcher") CRLFetcher crlFetcher) {
        X509Properties x509 = casProperties.getAuthn().getX509();
        Set x509CrlResources = x509.getCrlResources().stream().map(arg_0 -> ((ConfigurableApplicationContext)applicationContext).getResource(arg_0)).collect(Collectors.toSet());
        return new ResourceCRLRevocationChecker(x509.isCheckAll(), CasX509AuthenticationAutoConfiguration.getRevocationPolicy(x509.getCrlResourceUnavailablePolicy(), allowRevocationPolicy, thresholdExpiredCRLRevocationPolicy, denyRevocationPolicy), CasX509AuthenticationAutoConfiguration.getRevocationPolicy(x509.getCrlResourceExpiredPolicy(), allowRevocationPolicy, thresholdExpiredCRLRevocationPolicy, denyRevocationPolicy), x509.getRefreshIntervalSeconds(), crlFetcher, x509CrlResources);
    }

    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    @ConditionalOnMissingBean(name={"crlFetcher"})
    public CRLFetcher crlFetcher(CasConfigurationProperties casProperties) {
        X509Properties x509 = casProperties.getAuthn().getX509();
        return switch (x509.getCrlFetcher().toLowerCase(Locale.ENGLISH)) {
            case "ldap" -> new LdaptiveResourceCRLFetcher(LdapUtils.newLdaptiveConnectionConfig((AbstractLdapProperties)x509.getLdap()), LdapUtils.newLdaptiveSearchOperation((String)x509.getLdap().getBaseDn(), (String)x509.getLdap().getSearchFilter()), x509.getLdap().getCertificateAttribute());
            default -> new ResourceCRLFetcher();
        };
    }

    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    @ConditionalOnMissingBean(name={"x509CredentialsAuthenticationHandler"})
    public AuthenticationHandler x509CredentialsAuthenticationHandler(CasConfigurationProperties casProperties, @Qualifier(value="resourceCrlRevocationChecker") RevocationChecker resourceCrlRevocationChecker, @Qualifier(value="x509PrincipalFactory") PrincipalFactory x509PrincipalFactory, @Qualifier(value="crlDistributionPointRevocationChecker") RevocationChecker crlDistributionPointRevocationChecker, @Qualifier(value="noOpRevocationChecker") RevocationChecker noOpRevocationChecker, @Qualifier(value="servicesManager") ServicesManager servicesManager) {
        X509Properties x509 = casProperties.getAuthn().getX509();
        RevocationChecker revChecker = CasX509AuthenticationAutoConfiguration.getRevocationCheckerFrom(x509, resourceCrlRevocationChecker, crlDistributionPointRevocationChecker, noOpRevocationChecker);
        Pattern subjectDnPattern = StringUtils.isNotBlank((CharSequence)x509.getRegExSubjectDnPattern()) ? RegexUtils.createPattern((String)x509.getRegExSubjectDnPattern()) : null;
        Pattern trustedIssuerDnPattern = StringUtils.isNotBlank((CharSequence)x509.getRegExTrustedIssuerDnPattern()) ? RegexUtils.createPattern((String)x509.getRegExTrustedIssuerDnPattern()) : null;
        return new X509CredentialsAuthenticationHandler(x509.getName(), servicesManager, x509PrincipalFactory, trustedIssuerDnPattern, x509.getMaxPathLength(), x509.isMaxPathLengthAllowUnspecified(), x509.isCheckKeyUsage(), x509.isRequireKeyUsage(), subjectDnPattern, revChecker, Integer.valueOf(x509.getOrder()));
    }

    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    @ConditionalOnMissingBean(name={"x509SubjectPrincipalResolver"})
    public PrincipalResolver x509SubjectPrincipalResolver(ConfigurableApplicationContext applicationContext, @Qualifier(value="attributeDefinitionStore") AttributeDefinitionStore attributeDefinitionStore, @Qualifier(value="servicesManager") ServicesManager servicesManager, CasConfigurationProperties casProperties, @Qualifier(value="x509PrincipalFactory") PrincipalFactory x509PrincipalFactory, @Qualifier(value="x509AttributeExtractor") X509AttributeExtractor x509AttributeExtractor, @Qualifier(value="attributeRepository") PersonAttributeDao attributeRepository, @Qualifier(value="attributeRepositoryResolver") AttributeRepositoryResolver attributeRepositoryResolver) {
        PersonDirectoryPrincipalResolverProperties personDirectory = casProperties.getPersonDirectory();
        X509Properties x509 = casProperties.getAuthn().getX509();
        PersonDirectoryPrincipalResolverProperties principal = x509.getPrincipal();
        X509SubjectPrincipalResolver resolver = (X509SubjectPrincipalResolver)PersonDirectoryPrincipalResolver.newPersonDirectoryPrincipalResolver((ConfigurableApplicationContext)applicationContext, (PrincipalFactory)x509PrincipalFactory, (PersonAttributeDao)attributeRepository, (AttributeMerger)CoreAuthenticationUtils.getAttributeMerger((PrincipalAttributesCoreProperties.MergingStrategyTypes)casProperties.getAuthn().getAttributeRepository().getCore().getMerger()), X509SubjectPrincipalResolver.class, (ServicesManager)servicesManager, (AttributeDefinitionStore)attributeDefinitionStore, (AttributeRepositoryResolver)attributeRepositoryResolver, (PersonDirectoryPrincipalResolverProperties[])new PersonDirectoryPrincipalResolverProperties[]{principal, personDirectory});
        resolver.setPrincipalDescriptor(x509.getPrincipalDescriptor());
        resolver.setX509AttributeExtractor(x509AttributeExtractor);
        return resolver;
    }

    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    @ConditionalOnMissingBean(name={"x509SubjectDNPrincipalResolver"})
    public PrincipalResolver x509SubjectDNPrincipalResolver(ConfigurableApplicationContext applicationContext, @Qualifier(value="attributeDefinitionStore") AttributeDefinitionStore attributeDefinitionStore, @Qualifier(value="servicesManager") ServicesManager servicesManager, CasConfigurationProperties casProperties, @Qualifier(value="x509PrincipalFactory") PrincipalFactory x509PrincipalFactory, @Qualifier(value="x509AttributeExtractor") X509AttributeExtractor x509AttributeExtractor, @Qualifier(value="attributeRepository") PersonAttributeDao attributeRepository, @Qualifier(value="attributeRepositoryResolver") AttributeRepositoryResolver attributeRepositoryResolver) {
        X509Properties x509 = casProperties.getAuthn().getX509();
        SubjectDnPrincipalResolverProperties subjectDn = x509.getSubjectDn();
        PersonDirectoryPrincipalResolverProperties personDirectory = casProperties.getPersonDirectory();
        PersonDirectoryPrincipalResolverProperties principal = x509.getPrincipal();
        X509SubjectDNPrincipalResolver resolver = (X509SubjectDNPrincipalResolver)PersonDirectoryPrincipalResolver.newPersonDirectoryPrincipalResolver((ConfigurableApplicationContext)applicationContext, (PrincipalFactory)x509PrincipalFactory, (PersonAttributeDao)attributeRepository, (AttributeMerger)CoreAuthenticationUtils.getAttributeMerger((PrincipalAttributesCoreProperties.MergingStrategyTypes)casProperties.getAuthn().getAttributeRepository().getCore().getMerger()), X509SubjectDNPrincipalResolver.class, (ServicesManager)servicesManager, (AttributeDefinitionStore)attributeDefinitionStore, (AttributeRepositoryResolver)attributeRepositoryResolver, (PersonDirectoryPrincipalResolverProperties[])new PersonDirectoryPrincipalResolverProperties[]{principal, personDirectory});
        resolver.setSubjectDnFormat(X509AuthenticationUtils.getSubjectDnFormat((SubjectDnPrincipalResolverProperties.SubjectDnFormat)subjectDn.getFormat()));
        resolver.setX509AttributeExtractor(x509AttributeExtractor);
        return resolver;
    }

    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    @ConditionalOnMissingBean(name={"x509SubjectAlternativeNameUPNPrincipalResolver"})
    public PrincipalResolver x509SubjectAlternativeNameUPNPrincipalResolver(ConfigurableApplicationContext applicationContext, @Qualifier(value="attributeDefinitionStore") AttributeDefinitionStore attributeDefinitionStore, @Qualifier(value="servicesManager") ServicesManager servicesManager, CasConfigurationProperties casProperties, @Qualifier(value="x509PrincipalFactory") PrincipalFactory x509PrincipalFactory, @Qualifier(value="x509AttributeExtractor") X509AttributeExtractor x509AttributeExtractor, @Qualifier(value="attributeRepository") PersonAttributeDao attributeRepository, @Qualifier(value="attributeRepositoryResolver") AttributeRepositoryResolver attributeRepositoryResolver) {
        X509Properties x509 = casProperties.getAuthn().getX509();
        PersonDirectoryPrincipalResolverProperties personDirectory = casProperties.getPersonDirectory();
        SubjectAltNamePrincipalResolverProperties subjectAltNameProperties = x509.getSubjectAltName();
        PersonDirectoryPrincipalResolverProperties principal = x509.getPrincipal();
        X509SubjectAlternativeNameUPNPrincipalResolver resolver = (X509SubjectAlternativeNameUPNPrincipalResolver)PersonDirectoryPrincipalResolver.newPersonDirectoryPrincipalResolver((ConfigurableApplicationContext)applicationContext, (PrincipalFactory)x509PrincipalFactory, (PersonAttributeDao)attributeRepository, (AttributeMerger)CoreAuthenticationUtils.getAttributeMerger((PrincipalAttributesCoreProperties.MergingStrategyTypes)casProperties.getAuthn().getAttributeRepository().getCore().getMerger()), X509SubjectAlternativeNameUPNPrincipalResolver.class, (ServicesManager)servicesManager, (AttributeDefinitionStore)attributeDefinitionStore, (AttributeRepositoryResolver)attributeRepositoryResolver, (PersonDirectoryPrincipalResolverProperties[])new PersonDirectoryPrincipalResolverProperties[]{principal, personDirectory});
        resolver.setAlternatePrincipalAttribute(subjectAltNameProperties.getAlternatePrincipalAttribute());
        resolver.setX509AttributeExtractor(x509AttributeExtractor);
        return resolver;
    }

    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    @ConditionalOnMissingBean(name={"x509SubjectAlternativeNameRFC822EmailPrincipalResolver"})
    public PrincipalResolver x509SubjectAlternativeNameRFC822EmailPrincipalResolver(ConfigurableApplicationContext applicationContext, @Qualifier(value="attributeDefinitionStore") AttributeDefinitionStore attributeDefinitionStore, @Qualifier(value="servicesManager") ServicesManager servicesManager, CasConfigurationProperties casProperties, @Qualifier(value="x509PrincipalFactory") PrincipalFactory x509PrincipalFactory, @Qualifier(value="x509AttributeExtractor") X509AttributeExtractor x509AttributeExtractor, @Qualifier(value="attributeRepository") PersonAttributeDao attributeRepository, @Qualifier(value="attributeRepositoryResolver") AttributeRepositoryResolver attributeRepositoryResolver) {
        X509Properties x509 = casProperties.getAuthn().getX509();
        PersonDirectoryPrincipalResolverProperties personDirectory = casProperties.getPersonDirectory();
        Rfc822EmailPrincipalResolverProperties rfc822EmailProperties = x509.getRfc822Email();
        PersonDirectoryPrincipalResolverProperties principal = x509.getPrincipal();
        X509SubjectAlternativeNameRFC822EmailPrincipalResolver resolver = (X509SubjectAlternativeNameRFC822EmailPrincipalResolver)PersonDirectoryPrincipalResolver.newPersonDirectoryPrincipalResolver((ConfigurableApplicationContext)applicationContext, (PrincipalFactory)x509PrincipalFactory, (PersonAttributeDao)attributeRepository, (AttributeMerger)CoreAuthenticationUtils.getAttributeMerger((PrincipalAttributesCoreProperties.MergingStrategyTypes)casProperties.getAuthn().getAttributeRepository().getCore().getMerger()), X509SubjectAlternativeNameRFC822EmailPrincipalResolver.class, (ServicesManager)servicesManager, (AttributeDefinitionStore)attributeDefinitionStore, (AttributeRepositoryResolver)attributeRepositoryResolver, (PersonDirectoryPrincipalResolverProperties[])new PersonDirectoryPrincipalResolverProperties[]{principal, personDirectory});
        resolver.setAlternatePrincipalAttribute(rfc822EmailProperties.getAlternatePrincipalAttribute());
        resolver.setX509AttributeExtractor(x509AttributeExtractor);
        return resolver;
    }

    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    @ConditionalOnMissingBean(name={"x509SerialNumberPrincipalResolver"})
    public PrincipalResolver x509SerialNumberPrincipalResolver(ConfigurableApplicationContext applicationContext, @Qualifier(value="attributeDefinitionStore") AttributeDefinitionStore attributeDefinitionStore, @Qualifier(value="servicesManager") ServicesManager servicesManager, CasConfigurationProperties casProperties, @Qualifier(value="x509PrincipalFactory") PrincipalFactory x509PrincipalFactory, @Qualifier(value="x509AttributeExtractor") X509AttributeExtractor x509AttributeExtractor, @Qualifier(value="attributeRepository") PersonAttributeDao attributeRepository, @Qualifier(value="attributeRepositoryResolver") AttributeRepositoryResolver attributeRepositoryResolver) {
        return CasX509AuthenticationAutoConfiguration.getX509SerialNumberPrincipalResolver(applicationContext, casProperties, attributeRepository, x509AttributeExtractor, x509PrincipalFactory, servicesManager, attributeDefinitionStore, attributeRepositoryResolver);
    }

    @ConditionalOnMissingBean(name={"x509PrincipalFactory"})
    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    public PrincipalFactory x509PrincipalFactory() {
        return PrincipalFactoryUtils.newPrincipalFactory();
    }

    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    @ConditionalOnMissingBean(name={"x509SerialNumberAndIssuerDNPrincipalResolver"})
    public PrincipalResolver x509SerialNumberAndIssuerDNPrincipalResolver(ConfigurableApplicationContext applicationContext, @Qualifier(value="attributeDefinitionStore") AttributeDefinitionStore attributeDefinitionStore, @Qualifier(value="servicesManager") ServicesManager servicesManager, CasConfigurationProperties casProperties, @Qualifier(value="x509PrincipalFactory") PrincipalFactory x509PrincipalFactory, @Qualifier(value="x509AttributeExtractor") X509AttributeExtractor x509AttributeExtractor, @Qualifier(value="attributeRepositoryResolver") AttributeRepositoryResolver attributeRepositoryResolver, @Qualifier(value="attributeRepository") PersonAttributeDao attributeRepository) {
        X509Properties x509 = casProperties.getAuthn().getX509();
        SerialNoDnPrincipalResolverProperties serialNoDnProperties = x509.getSerialNoDn();
        PersonDirectoryPrincipalResolverProperties principal = x509.getPrincipal();
        PersonDirectoryPrincipalResolverProperties personDirectory = casProperties.getPersonDirectory();
        X509SerialNumberAndIssuerDNPrincipalResolver resolver = (X509SerialNumberAndIssuerDNPrincipalResolver)PersonDirectoryPrincipalResolver.newPersonDirectoryPrincipalResolver((ConfigurableApplicationContext)applicationContext, (PrincipalFactory)x509PrincipalFactory, (PersonAttributeDao)attributeRepository, (AttributeMerger)CoreAuthenticationUtils.getAttributeMerger((PrincipalAttributesCoreProperties.MergingStrategyTypes)casProperties.getAuthn().getAttributeRepository().getCore().getMerger()), X509SerialNumberAndIssuerDNPrincipalResolver.class, (ServicesManager)servicesManager, (AttributeDefinitionStore)attributeDefinitionStore, (AttributeRepositoryResolver)attributeRepositoryResolver, (PersonDirectoryPrincipalResolverProperties[])new PersonDirectoryPrincipalResolverProperties[]{principal, personDirectory});
        resolver.setSerialNumberPrefix(serialNoDnProperties.getSerialNumberPrefix());
        resolver.setValueDelimiter(serialNoDnProperties.getValueDelimiter());
        resolver.setX509AttributeExtractor(x509AttributeExtractor);
        return resolver;
    }

    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    @ConditionalOnMissingBean(name={"x509CommonNameEDIPIPrincipalResolver"})
    public PrincipalResolver x509CommonNameEDIPIPrincipalResolver(ConfigurableApplicationContext applicationContext, @Qualifier(value="attributeDefinitionStore") AttributeDefinitionStore attributeDefinitionStore, @Qualifier(value="servicesManager") ServicesManager servicesManager, CasConfigurationProperties casProperties, @Qualifier(value="x509PrincipalFactory") PrincipalFactory x509PrincipalFactory, @Qualifier(value="x509AttributeExtractor") X509AttributeExtractor x509AttributeExtractor, @Qualifier(value="attributeRepository") PersonAttributeDao attributeRepository, @Qualifier(value="attributeRepositoryResolver") AttributeRepositoryResolver attributeRepositoryResolver) {
        X509Properties x509 = casProperties.getAuthn().getX509();
        CnEdipiPrincipalResolverProperties cnEdipiProperties = x509.getCnEdipi();
        PersonDirectoryPrincipalResolverProperties principal = x509.getPrincipal();
        PersonDirectoryPrincipalResolverProperties personDirectory = casProperties.getPersonDirectory();
        X509CommonNameEDIPIPrincipalResolver resolver = (X509CommonNameEDIPIPrincipalResolver)PersonDirectoryPrincipalResolver.newPersonDirectoryPrincipalResolver((ConfigurableApplicationContext)applicationContext, (PrincipalFactory)x509PrincipalFactory, (PersonAttributeDao)attributeRepository, (AttributeMerger)CoreAuthenticationUtils.getAttributeMerger((PrincipalAttributesCoreProperties.MergingStrategyTypes)casProperties.getAuthn().getAttributeRepository().getCore().getMerger()), X509CommonNameEDIPIPrincipalResolver.class, (ServicesManager)servicesManager, (AttributeDefinitionStore)attributeDefinitionStore, (AttributeRepositoryResolver)attributeRepositoryResolver, (PersonDirectoryPrincipalResolverProperties[])new PersonDirectoryPrincipalResolverProperties[]{principal, personDirectory});
        resolver.setAlternatePrincipalAttribute(cnEdipiProperties.getAlternatePrincipalAttribute());
        resolver.setX509AttributeExtractor(x509AttributeExtractor);
        return resolver;
    }

    @ConditionalOnMissingBean(name={"x509AuthenticationEventExecutionPlanConfigurer"})
    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    public AuthenticationEventExecutionPlanConfigurer x509AuthenticationEventExecutionPlanConfigurer(@Qualifier(value="x509SerialNumberPrincipalResolver") PrincipalResolver x509SerialNumberPrincipalResolver, @Qualifier(value="x509SerialNumberAndIssuerDNPrincipalResolver") PrincipalResolver x509SerialNumberAndIssuerDNPrincipalResolver, @Qualifier(value="x509SubjectPrincipalResolver") PrincipalResolver x509SubjectPrincipalResolver, @Qualifier(value="x509SubjectAlternativeNameUPNPrincipalResolver") PrincipalResolver x509SubjectAlternativeNameUPNPrincipalResolver, @Qualifier(value="x509SubjectAlternativeNameRFC822EmailPrincipalResolver") PrincipalResolver x509SubjectAlternativeNameRFC822EmailPrincipalResolver, @Qualifier(value="x509SubjectDNPrincipalResolver") PrincipalResolver x509SubjectDNPrincipalResolver, @Qualifier(value="x509CommonNameEDIPIPrincipalResolver") PrincipalResolver x509CommonNameEDIPIPrincipalResolver, CasConfigurationProperties casProperties, @Qualifier(value="x509CredentialsAuthenticationHandler") AuthenticationHandler x509CredentialsAuthenticationHandler) {
        return plan -> plan.registerAuthenticationHandlerWithPrincipalResolver(x509CredentialsAuthenticationHandler, CasX509AuthenticationAutoConfiguration.getPrincipalResolver(casProperties, x509SerialNumberPrincipalResolver, x509SerialNumberAndIssuerDNPrincipalResolver, x509SubjectPrincipalResolver, x509SubjectAlternativeNameUPNPrincipalResolver, x509SubjectAlternativeNameRFC822EmailPrincipalResolver, x509SubjectDNPrincipalResolver, x509CommonNameEDIPIPrincipalResolver));
    }

    @ConditionalOnMissingBean(name={"x509AttributeExtractor"})
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    @Bean
    public X509AttributeExtractor x509AttributeExtractor(CasConfigurationProperties casProperties) {
        X509Properties x509 = casProperties.getAuthn().getX509();
        if (x509.getCnEdipi().isExtractEdipiAsAttribute()) {
            return new EDIPIX509AttributeExtractor();
        }
        return new DefaultX509AttributeExtractor();
    }

    @Bean
    @ConditionalOnMissingBean(name={"x509ComponentSerializationPlanConfigurer"})
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    public ComponentSerializationPlanConfigurer x509ComponentSerializationPlanConfigurer() {
        return plan -> plan.registerSerializableClass(X509CertificateCredential.class);
    }
}

