/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.egrid.provider;

import java.io.Serializable;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.wicket.core.util.lang.PropertyResolver;
import org.apache.wicket.extensions.markup.html.repeater.data.sort.SortOrder;
import org.apache.wicket.extensions.markup.html.repeater.util.SortableDataProvider;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.wicketstuff.egrid.provider.IEditableDataProvider;

public class EditableListDataProvider<T extends Serializable>
extends SortableDataProvider<T, String>
implements IEditableDataProvider<T, String> {
    private static final long serialVersionUID = 1L;
    private final List<T> list;

    public EditableListDataProvider(String sortProperty) {
        this(sortProperty, null);
    }

    public EditableListDataProvider(String sortProperty, SortOrder sortOrder) {
        this(Collections.emptyList(), sortProperty, sortOrder);
    }

    public EditableListDataProvider(List<T> list, String sortProperty) {
        this(list, sortProperty, null);
    }

    public EditableListDataProvider(List<T> list, String sortProperty, SortOrder sortOrder) {
        if (list == null) {
            throw new IllegalArgumentException("argument [list] cannot be null");
        }
        this.list = list;
        SortOrder sortOrd = sortOrder != null ? sortOrder : SortOrder.ASCENDING;
        this.setSort(sortProperty, sortOrd);
    }

    protected List<T> getData() {
        return this.list;
    }

    public Iterator<? extends T> iterator(long first, long count) {
        List<T> data = this.getData();
        data.sort((o1, o2) -> {
            Comparable v1 = (Comparable)PropertyResolver.getValue((String)((String)this.getSort().getProperty()), (Object)o1);
            Comparable v2 = (Comparable)PropertyResolver.getValue((String)((String)this.getSort().getProperty()), (Object)o2);
            int result = v1 == null && v2 == null ? 0 : (v1 == null ? 1 : (v2 == null ? -1 : v1.compareTo(v2)));
            return this.getSort().isAscending() ? result : -result;
        });
        long toIndex = first + count;
        if (toIndex > (long)data.size()) {
            toIndex = data.size();
        }
        return data.subList((int)first, (int)toIndex).listIterator();
    }

    public long size() {
        return this.getData().size();
    }

    public IModel<T> model(T object) {
        return new Model(object);
    }

    @Override
    public void add(T item) {
        this.list.add(item);
    }

    @Override
    public void remove(T item) {
        this.list.remove(item);
    }
}

