/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.memory;

import java.nio.ByteBuffer;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.common.memory.GarbageCollectedMemoryPool;
import org.apache.kafka.common.utils.Utils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class GarbageCollectedMemoryPoolTest {
    private GarbageCollectedMemoryPool pool;

    @AfterEach
    public void releasePool() {
        if (this.pool != null) {
            this.pool.close();
        }
    }

    @Test
    public void testZeroSize() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new GarbageCollectedMemoryPool(0L, 7, true, null));
    }

    @Test
    public void testNegativeSize() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new GarbageCollectedMemoryPool(-1L, 7, false, null));
    }

    @Test
    public void testZeroMaxAllocation() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new GarbageCollectedMemoryPool(100L, 0, true, null));
    }

    @Test
    public void testNegativeMaxAllocation() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new GarbageCollectedMemoryPool(100L, -1, false, null));
    }

    @Test
    public void testMaxAllocationLargerThanSize() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new GarbageCollectedMemoryPool(100L, 101, true, null));
    }

    @Test
    public void testAllocationOverMaxAllocation() {
        this.pool = new GarbageCollectedMemoryPool(1000L, 10, false, null);
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.pool.tryAllocate(11));
    }

    @Test
    public void testAllocationZero() {
        this.pool = new GarbageCollectedMemoryPool(1000L, 10, true, null);
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.pool.tryAllocate(0));
    }

    @Test
    public void testAllocationNegative() {
        this.pool = new GarbageCollectedMemoryPool(1000L, 10, false, null);
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.pool.tryAllocate(-1));
    }

    @Test
    public void testReleaseNull() {
        this.pool = new GarbageCollectedMemoryPool(1000L, 10, true, null);
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.pool.release(null));
    }

    @Test
    public void testReleaseForeignBuffer() {
        this.pool = new GarbageCollectedMemoryPool(1000L, 10, true, null);
        ByteBuffer fellOffATruck = ByteBuffer.allocate(1);
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.pool.release(fellOffATruck));
    }

    @Test
    public void testDoubleFree() {
        this.pool = new GarbageCollectedMemoryPool(1000L, 10, false, null);
        ByteBuffer buffer = this.pool.tryAllocate(5);
        Assertions.assertNotNull((Object)buffer);
        this.pool.release(buffer);
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.pool.release(buffer));
    }

    @Test
    public void testAllocationBound() {
        this.pool = new GarbageCollectedMemoryPool(21L, 10, false, null);
        ByteBuffer buf1 = this.pool.tryAllocate(10);
        Assertions.assertNotNull((Object)buf1);
        Assertions.assertEquals((int)10, (int)buf1.capacity());
        ByteBuffer buf2 = this.pool.tryAllocate(10);
        Assertions.assertNotNull((Object)buf2);
        Assertions.assertEquals((int)10, (int)buf2.capacity());
        ByteBuffer buf3 = this.pool.tryAllocate(10);
        Assertions.assertNotNull((Object)buf3);
        Assertions.assertEquals((int)10, (int)buf3.capacity());
        Assertions.assertNull((Object)this.pool.tryAllocate(1));
        this.pool.release(buf3);
        ByteBuffer buf4 = this.pool.tryAllocate(10);
        Assertions.assertNotNull((Object)buf4);
        Assertions.assertEquals((int)10, (int)buf4.capacity());
        Assertions.assertNull((Object)this.pool.tryAllocate(1));
    }

    @Test
    public void testBuffersGarbageCollected() throws Exception {
        Runtime runtime = Runtime.getRuntime();
        long maxHeap = runtime.maxMemory();
        long maxPool = maxHeap / 2L;
        long maxSingleAllocation = maxPool / 10L;
        Assertions.assertTrue((maxSingleAllocation < 0x3FFFFFFFL ? 1 : 0) != 0);
        this.pool = new GarbageCollectedMemoryPool(maxPool, (int)maxSingleAllocation, false, null);
        int timeoutSeconds = 30;
        long giveUp = System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(timeoutSeconds);
        boolean success = false;
        int buffersAllocated = 0;
        while (System.currentTimeMillis() < giveUp) {
            ByteBuffer buffer = this.pool.tryAllocate((int)maxSingleAllocation);
            if (buffer == null) {
                System.gc();
                Thread.sleep(10L);
                continue;
            }
            if (++buffersAllocated < 30) continue;
            success = true;
            break;
        }
        Assertions.assertTrue((boolean)success, (String)("failed to allocate 30 buffers in " + timeoutSeconds + " seconds. buffers allocated: " + buffersAllocated + " heap " + Utils.formatBytes((long)maxHeap) + " pool " + Utils.formatBytes((long)maxPool) + " single allocation " + Utils.formatBytes((long)maxSingleAllocation)));
    }
}

