/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.oauth.profile.linkedin2;

import com.github.scribejava.core.model.Token;
import com.github.scribejava.core.oauth.OAuth20Service;
import com.github.scribejava.core.oauth.OAuthService;
import java.io.IOException;
import java.util.Optional;
import org.pac4j.core.client.IndirectClient;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.exception.HttpCommunicationException;
import org.pac4j.core.profile.UserProfile;
import org.pac4j.oauth.config.OAuth20Configuration;
import org.pac4j.oauth.profile.JsonHelper;
import org.pac4j.oauth.profile.creator.OAuth20ProfileCreator;
import org.pac4j.oauth.profile.linkedin2.LinkedIn2Configuration;
import org.pac4j.oauth.profile.linkedin2.LinkedIn2Profile;
import org.pac4j.oauth.profile.linkedin2.LinkedIn2ProfileDefinition;
import org.pac4j.oauth.profile.linkedin2.LinkedIn2ProfileEmails;

public class LinkedIn2ProfileCreator
extends OAuth20ProfileCreator {
    private static final String EMAIL_URL = "https://api.linkedin.com/v2/emailAddress?q=members&projection=(elements*(handle~))";

    public LinkedIn2ProfileCreator(OAuth20Configuration configuration, IndirectClient client) {
        super(configuration, client);
    }

    @Override
    protected Optional<UserProfile> retrieveUserProfileFromToken(WebContext context, Token accessToken) {
        super.retrieveUserProfileFromToken(context, accessToken);
        LinkedIn2ProfileDefinition profileDefinition = (LinkedIn2ProfileDefinition)this.configuration.getProfileDefinition();
        LinkedIn2Configuration linkedin2Configuration = (LinkedIn2Configuration)this.configuration;
        String profileUrl = profileDefinition.getProfileUrl(accessToken, linkedin2Configuration);
        OAuth20Service service = (OAuth20Service)this.configuration.buildService(context, this.client);
        String body = this.sendRequestForData((OAuthService)service, accessToken, profileUrl, profileDefinition.getProfileVerb());
        if (body == null) {
            throw new HttpCommunicationException("Not data found for accessToken: " + accessToken);
        }
        LinkedIn2Profile profile = profileDefinition.extractUserProfile(body);
        this.addTokenToProfile((UserProfile)profile, accessToken);
        if (profile == null || !linkedin2Configuration.getScope().contains("r_emailaddress")) {
            return Optional.ofNullable(profile);
        }
        body = this.sendRequestForData((OAuthService)service, accessToken, EMAIL_URL, profileDefinition.getProfileVerb());
        if (body == null) {
            throw new HttpCommunicationException("Not email data found for accessToken: " + accessToken);
        }
        try {
            LinkedIn2ProfileEmails profileEmails = (LinkedIn2ProfileEmails)JsonHelper.getMapper().readValue(body, LinkedIn2ProfileEmails.class);
            profile.addAttribute("profileEmails", profileEmails);
        }
        catch (IOException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        return Optional.of(profile);
    }
}

