/*
 * Decompiled with CFR 0.152.
 */
package com.giffing.wicket.spring.boot.starter.web.servlet.websocket;

import com.giffing.wicket.spring.boot.starter.web.servlet.websocket.WebSocketMessageBroadcaster;
import com.giffing.wicket.spring.boot.starter.web.servlet.websocket.WicketSessionResolver;
import java.util.Collection;
import org.apache.wicket.Application;
import org.apache.wicket.protocol.ws.WebSocketSettings;
import org.apache.wicket.protocol.ws.api.IWebSocketConnection;
import org.apache.wicket.protocol.ws.api.message.IWebSocketPushMessage;
import org.apache.wicket.protocol.ws.api.registry.IWebSocketConnectionRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketMessageSenderDefault
implements WebSocketMessageBroadcaster {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private Application application;
    private WicketSessionResolver wicketSessionResolver;

    public WebSocketMessageSenderDefault(Application application, WicketSessionResolver wicketSessionResolver) {
        this.application = application;
        this.wicketSessionResolver = wicketSessionResolver;
    }

    @Override
    public void sendToAll(IWebSocketPushMessage event) {
        WebSocketSettings webSocketSettings = WebSocketSettings.Holder.get((Application)this.application);
        IWebSocketConnectionRegistry connectionRegistry = webSocketSettings.getConnectionRegistry();
        Collection connections = connectionRegistry.getConnections(this.application);
        this.log.trace("sending event to {} connections", (Object)connections.size());
        for (IWebSocketConnection connection : connections) {
            connection.sendMessage(event);
        }
    }

    @Override
    public void sendTo(Object identifier, IWebSocketPushMessage event) {
        if (identifier == null) {
            return;
        }
        WebSocketSettings webSocketSettings = WebSocketSettings.Holder.get((Application)this.application);
        IWebSocketConnectionRegistry connectionRegistry = webSocketSettings.getConnectionRegistry();
        this.wicketSessionResolver.resolve(identifier).forEach(sessionId -> {
            Collection connections = connectionRegistry.getConnections(this.application, sessionId);
            this.log.trace("sending event to {} connections", (Object)connections.size());
            for (IWebSocketConnection connection : connections) {
                connection.sendMessage(event);
            }
        });
    }
}

