/*
 * Decompiled with CFR 0.152.
 */
package net.tirasa.connid.bundles.ldap;

import java.util.Set;
import net.tirasa.connid.bundles.ldap.LdapAuthenticate;
import net.tirasa.connid.bundles.ldap.LdapConfiguration;
import net.tirasa.connid.bundles.ldap.LdapConnection;
import net.tirasa.connid.bundles.ldap.modify.LdapCreate;
import net.tirasa.connid.bundles.ldap.modify.LdapDelete;
import net.tirasa.connid.bundles.ldap.modify.LdapUpdate;
import net.tirasa.connid.bundles.ldap.search.LdapFilter;
import net.tirasa.connid.bundles.ldap.search.LdapFilterTranslator;
import net.tirasa.connid.bundles.ldap.search.LdapSearch;
import net.tirasa.connid.bundles.ldap.sync.LdapSyncStrategy;
import net.tirasa.connid.bundles.ldap.sync.sunds.SunDSChangeLogSyncStrategy;
import org.identityconnectors.common.logging.Log;
import org.identityconnectors.common.security.GuardedString;
import org.identityconnectors.framework.common.objects.Attribute;
import org.identityconnectors.framework.common.objects.AttributeDelta;
import org.identityconnectors.framework.common.objects.ObjectClass;
import org.identityconnectors.framework.common.objects.OperationOptions;
import org.identityconnectors.framework.common.objects.ResultsHandler;
import org.identityconnectors.framework.common.objects.Schema;
import org.identityconnectors.framework.common.objects.SyncResultsHandler;
import org.identityconnectors.framework.common.objects.SyncToken;
import org.identityconnectors.framework.common.objects.Uid;
import org.identityconnectors.framework.common.objects.filter.FilterTranslator;
import org.identityconnectors.framework.spi.Configuration;
import org.identityconnectors.framework.spi.ConnectorClass;
import org.identityconnectors.framework.spi.PoolableConnector;
import org.identityconnectors.framework.spi.operations.AuthenticateOp;
import org.identityconnectors.framework.spi.operations.CreateOp;
import org.identityconnectors.framework.spi.operations.DeleteOp;
import org.identityconnectors.framework.spi.operations.ResolveUsernameOp;
import org.identityconnectors.framework.spi.operations.SchemaOp;
import org.identityconnectors.framework.spi.operations.SearchOp;
import org.identityconnectors.framework.spi.operations.SyncOp;
import org.identityconnectors.framework.spi.operations.TestOp;
import org.identityconnectors.framework.spi.operations.UpdateAttributeValuesOp;
import org.identityconnectors.framework.spi.operations.UpdateDeltaOp;
import org.identityconnectors.framework.spi.operations.UpdateOp;

@ConnectorClass(configurationClass=LdapConfiguration.class, displayNameKey="LdapConnector")
public class LdapConnector
implements TestOp,
PoolableConnector,
SchemaOp,
SearchOp<LdapFilter>,
AuthenticateOp,
ResolveUsernameOp,
CreateOp,
UpdateOp,
UpdateDeltaOp,
UpdateAttributeValuesOp,
DeleteOp,
SyncOp {
    private static final Log LOG = Log.getLog(LdapConnector.class);
    protected LdapConfiguration config;
    protected LdapConnection conn;
    protected LdapSyncStrategy syncStrategy;

    public Configuration getConfiguration() {
        return this.config;
    }

    public void init(Configuration cfg) {
        this.config = (LdapConfiguration)cfg;
        this.config.validate();
        Class<? extends LdapSyncStrategy> syncStrategyClass = this.config.getSyncStrategyClass();
        Class<? extends LdapConnection> connectionClass = this.config.getConnectionClass();
        try {
            this.conn = connectionClass.getConstructor(LdapConfiguration.class).newInstance(new Object[]{this.config});
        }
        catch (Exception e) {
            LOG.error((Throwable)e, "Could not instantiate the configured connection class implementation {0}, reverting to {1}", new Object[]{connectionClass.getName(), LdapConnection.class.getName()});
            this.conn = new LdapConnection(this.config);
        }
        try {
            this.syncStrategy = syncStrategyClass.getConstructor(connectionClass).newInstance(this.conn);
        }
        catch (Exception e) {
            Class<? extends LdapSyncStrategy> fallbackSyncStrategyClass = this.config.getFallbackSyncStrategyClass();
            LOG.error((Throwable)e, "Could not instantiate the configured {0} implementation, reverting to {1}", new Object[]{LdapSyncStrategy.class.getName(), fallbackSyncStrategyClass.getName()});
            try {
                this.syncStrategy = this.config.getFallbackSyncStrategyClass().getConstructor(connectionClass).newInstance(this.conn);
            }
            catch (Exception ex) {
                LOG.error((Throwable)e, "Could not instantiate the configured fallback {0} imeplementation, falling back to {1}", new Object[]{LdapSyncStrategy.class.getName(), SunDSChangeLogSyncStrategy.class});
                this.syncStrategy = new SunDSChangeLogSyncStrategy(this.conn);
            }
        }
    }

    public void dispose() {
        this.conn.close();
    }

    public void test() {
        this.conn.test();
    }

    public void checkAlive() {
        this.conn.checkAlive();
    }

    public Schema schema() {
        return this.conn.getSchema().schema();
    }

    public Uid authenticate(ObjectClass objectClass, String username, GuardedString password, OperationOptions options) {
        return new LdapAuthenticate(this.conn, objectClass, username, options).authenticate(password);
    }

    public Uid resolveUsername(ObjectClass objectClass, String username, OperationOptions options) {
        return new LdapAuthenticate(this.conn, objectClass, username, options).resolveUsername();
    }

    public FilterTranslator<LdapFilter> createFilterTranslator(ObjectClass oclass, OperationOptions options) {
        return new LdapFilterTranslator(this.conn.getSchema(), oclass);
    }

    public void executeQuery(ObjectClass oclass, LdapFilter query, ResultsHandler handler, OperationOptions options) {
        new LdapSearch(this.conn, oclass, query, handler, options).execute();
    }

    public Uid create(ObjectClass oclass, Set<Attribute> attrs, OperationOptions options) {
        return new LdapCreate(this.conn, oclass, attrs, options).execute();
    }

    public void delete(ObjectClass oclass, Uid uid, OperationOptions options) {
        new LdapDelete(this.conn, oclass, uid).execute();
    }

    public Uid update(ObjectClass oclass, Uid uid, Set<Attribute> replaceAttributes, OperationOptions options) {
        return new LdapUpdate(this.conn, oclass, uid).update(replaceAttributes);
    }

    public Set<AttributeDelta> updateDelta(ObjectClass oclass, Uid uid, Set<AttributeDelta> modifications, OperationOptions options) {
        return new LdapUpdate(this.conn, oclass, uid).updateDelta(modifications);
    }

    public Uid addAttributeValues(ObjectClass oclass, Uid uid, Set<Attribute> valuesToAdd, OperationOptions options) {
        return new LdapUpdate(this.conn, oclass, uid).addAttributeValues(valuesToAdd);
    }

    public Uid removeAttributeValues(ObjectClass oclass, Uid uid, Set<Attribute> valuesToRemove, OperationOptions options) {
        return new LdapUpdate(this.conn, oclass, uid).removeAttributeValues(valuesToRemove);
    }

    public SyncToken getLatestSyncToken(ObjectClass oclass) {
        return this.syncStrategy.getLatestSyncToken(oclass);
    }

    public void sync(ObjectClass oclass, SyncToken token, SyncResultsHandler handler, OperationOptions options) {
        this.syncStrategy.sync(token, handler, options, oclass);
    }
}

