/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.okta;

import com.okta.sdk.client.Client;
import com.okta.sdk.resource.user.CreateUserRequest;
import com.okta.sdk.resource.user.User;
import com.okta.sdk.resource.user.UserNextLogin;
import com.okta.sdk.resource.user.UserProfile;
import java.util.List;
import java.util.function.Consumer;
import lombok.Generated;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.principal.PrincipalProvisioner;
import org.apereo.cas.configuration.model.support.okta.OktaPrincipalProvisioningProperties;
import org.apereo.cas.util.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OktaPrincipalProvisioner
implements PrincipalProvisioner {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OktaPrincipalProvisioner.class);
    private final Client oktaClient;
    private final OktaPrincipalProvisioningProperties properties;

    public boolean provision(Principal principal, Credential credential) {
        return this.provision(credential, principal);
    }

    protected boolean provision(Credential credential, Principal principal) {
        LOGGER.debug("Searching to find [{}]", (Object)principal.getId());
        User existingUser = this.oktaClient.getUser(principal.getId());
        return existingUser == null || existingUser.getProfile().isEmpty() ? this.createUser(principal, credential) : this.updateUser(existingUser, principal);
    }

    protected boolean updateUser(User user, Principal principal) {
        UserProfile userProfile = this.mapPrincipalToUserProfile(user.getProfile(), principal, null);
        user.setProfile(userProfile);
        User updatedUser = this.oktaClient.partialUpdateUser(user, user.getId(), Boolean.valueOf(true));
        LOGGER.debug("Updated Okta user [{}]", (Object)updatedUser);
        return updatedUser != null;
    }

    protected boolean createUser(Principal principal, Credential credential) {
        CreateUserRequest createUserRequest = (CreateUserRequest)this.oktaClient.instantiate(CreateUserRequest.class);
        UserProfile initialUserProfile = (UserProfile)this.oktaClient.instantiate(UserProfile.class);
        initialUserProfile.setLogin(principal.getId());
        UserProfile userProfile = this.mapPrincipalToUserProfile(initialUserProfile, principal, credential);
        createUserRequest.setProfile(userProfile);
        User createdUser = this.oktaClient.createUser(createUserRequest, Boolean.valueOf(true), Boolean.valueOf(true), UserNextLogin.SDK_UNKNOWN);
        LOGGER.debug("Created Okta user [{}]", (Object)createdUser);
        return createdUser != null;
    }

    protected UserProfile mapPrincipalToUserProfile(UserProfile userProfile, Principal principal, Credential credential) {
        this.updateUserProfileWithAttribute(userProfile, principal, "department", arg_0 -> ((UserProfile)userProfile).setDepartment(arg_0));
        this.updateUserProfileWithAttribute(userProfile, principal, "city", arg_0 -> ((UserProfile)userProfile).setCity(arg_0));
        this.updateUserProfileWithAttribute(userProfile, principal, "costCenter", arg_0 -> ((UserProfile)userProfile).setCostCenter(arg_0));
        this.updateUserProfileWithAttribute(userProfile, principal, "countryCode", arg_0 -> ((UserProfile)userProfile).setCountryCode(arg_0));
        this.updateUserProfileWithAttribute(userProfile, principal, "displayName", arg_0 -> ((UserProfile)userProfile).setDisplayName(arg_0));
        this.updateUserProfileWithAttribute(userProfile, principal, "division", arg_0 -> ((UserProfile)userProfile).setDivision(arg_0));
        this.updateUserProfileWithAttribute(userProfile, principal, "email", arg_0 -> ((UserProfile)userProfile).setEmail(arg_0));
        this.updateUserProfileWithAttribute(userProfile, principal, "employeeNumber", arg_0 -> ((UserProfile)userProfile).setEmployeeNumber(arg_0));
        this.updateUserProfileWithAttribute(userProfile, principal, "honorificPrefix", arg_0 -> ((UserProfile)userProfile).setHonorificPrefix(arg_0));
        this.updateUserProfileWithAttribute(userProfile, principal, "honorificSuffix", arg_0 -> ((UserProfile)userProfile).setHonorificSuffix(arg_0));
        this.updateUserProfileWithAttribute(userProfile, principal, "lastName", arg_0 -> ((UserProfile)userProfile).setLastName(arg_0));
        this.updateUserProfileWithAttribute(userProfile, principal, "locale", arg_0 -> ((UserProfile)userProfile).setLocale(arg_0));
        this.updateUserProfileWithAttribute(userProfile, principal, "manager", arg_0 -> ((UserProfile)userProfile).setManager(arg_0));
        this.updateUserProfileWithAttribute(userProfile, principal, "managerId", arg_0 -> ((UserProfile)userProfile).setManagerId(arg_0));
        this.updateUserProfileWithAttribute(userProfile, principal, "middleName", arg_0 -> ((UserProfile)userProfile).setMiddleName(arg_0));
        this.updateUserProfileWithAttribute(userProfile, principal, "mobilePhone", arg_0 -> ((UserProfile)userProfile).setMobilePhone(arg_0));
        this.updateUserProfileWithAttribute(userProfile, principal, "nickName", arg_0 -> ((UserProfile)userProfile).setNickName(arg_0));
        this.updateUserProfileWithAttribute(userProfile, principal, "firstName", arg_0 -> ((UserProfile)userProfile).setFirstName(arg_0));
        this.updateUserProfileWithAttribute(userProfile, principal, "organization", arg_0 -> ((UserProfile)userProfile).setOrganization(arg_0));
        this.updateUserProfileWithAttribute(userProfile, principal, "postalAddress", arg_0 -> ((UserProfile)userProfile).setPostalAddress(arg_0));
        this.updateUserProfileWithAttribute(userProfile, principal, "preferredLanguage", arg_0 -> ((UserProfile)userProfile).setPreferredLanguage(arg_0));
        this.updateUserProfileWithAttribute(userProfile, principal, "primaryPhone", arg_0 -> ((UserProfile)userProfile).setPrimaryPhone(arg_0));
        this.updateUserProfileWithAttribute(userProfile, principal, "secondEmail", arg_0 -> ((UserProfile)userProfile).setSecondEmail(arg_0));
        this.updateUserProfileWithAttribute(userProfile, principal, "state", arg_0 -> ((UserProfile)userProfile).setState(arg_0));
        this.updateUserProfileWithAttribute(userProfile, principal, "streetAddress", arg_0 -> ((UserProfile)userProfile).setStreetAddress(arg_0));
        this.updateUserProfileWithAttribute(userProfile, principal, "timezone", arg_0 -> ((UserProfile)userProfile).setTimezone(arg_0));
        this.updateUserProfileWithAttribute(userProfile, principal, "title", arg_0 -> ((UserProfile)userProfile).setTitle(arg_0));
        this.updateUserProfileWithAttribute(userProfile, principal, "zipCode", arg_0 -> ((UserProfile)userProfile).setZipCode(arg_0));
        return userProfile;
    }

    protected void updateUserProfileWithAttribute(UserProfile userProfile, Principal principal, String attributeName, Consumer<String> profileUpdater) {
        String mappedAttributeName = this.properties.getAttributeMappings().getOrDefault(attributeName, attributeName);
        if (principal.getAttributes().containsKey(mappedAttributeName)) {
            List values = (List)principal.getAttributes().get(mappedAttributeName);
            LOGGER.trace("Setting Okta user profile attribute [{}] to [{}]", (Object)mappedAttributeName, (Object)values);
            CollectionUtils.firstElement((Object)values).ifPresent(value -> profileUpdater.accept(value.toString()));
        }
    }

    @Generated
    public OktaPrincipalProvisioner(Client oktaClient, OktaPrincipalProvisioningProperties properties) {
        this.oktaClient = oktaClient;
        this.properties = properties;
    }
}

