/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.cqengine.persistence.support.serialization;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.esotericsoftware.kryo.util.DefaultInstantiatorStrategy;
import com.googlecode.cqengine.persistence.support.serialization.PersistenceConfig;
import com.googlecode.cqengine.persistence.support.serialization.PojoSerializer;
import de.javakaffee.kryoserializers.ArraysAsListSerializer;
import de.javakaffee.kryoserializers.SynchronizedCollectionsSerializer;
import de.javakaffee.kryoserializers.UnmodifiableCollectionsSerializer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import org.objenesis.strategy.InstantiatorStrategy;
import org.objenesis.strategy.StdInstantiatorStrategy;

public class KryoSerializer<O>
implements PojoSerializer<O> {
    protected final Class<O> objectType;
    protected final boolean polymorphic;
    protected final ThreadLocal<Kryo> kryoCache = new ThreadLocal<Kryo>(){

        @Override
        protected Kryo initialValue() {
            return KryoSerializer.this.createKryo(KryoSerializer.this.objectType);
        }
    };

    public KryoSerializer(Class<O> objectType, PersistenceConfig persistenceConfig) {
        this.objectType = objectType;
        this.polymorphic = persistenceConfig.polymorphic();
    }

    protected Kryo createKryo(Class<?> objectType) {
        Kryo kryo = new Kryo();
        kryo.setInstantiatorStrategy((InstantiatorStrategy)new DefaultInstantiatorStrategy((InstantiatorStrategy)new StdInstantiatorStrategy()));
        kryo.register(objectType);
        kryo.setRegistrationRequired(false);
        kryo.register(Arrays.asList(new Object[0]).getClass(), (Serializer)new ArraysAsListSerializer());
        UnmodifiableCollectionsSerializer.registerSerializers((Kryo)kryo);
        SynchronizedCollectionsSerializer.registerSerializers((Kryo)kryo);
        return kryo;
    }

    @Override
    public byte[] serialize(O object) {
        if (object == null) {
            throw new NullPointerException("Object was null");
        }
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            Output output = new Output((OutputStream)baos);
            Kryo kryo = this.kryoCache.get();
            if (this.polymorphic) {
                kryo.writeClassAndObject(output, object);
            } else {
                kryo.writeObject(output, object);
            }
            output.close();
            return baos.toByteArray();
        }
        catch (Throwable e) {
            throw new IllegalStateException("Failed to serialize object, object type: " + this.objectType + ". Configure @PersistenceConfig.polymorphic if the collection will contain a mix of object types. Use the KryoSerializer.validateObjectIsRoundTripSerializable() method to test your object is compatible with CQEngine.", e);
        }
    }

    @Override
    public O deserialize(byte[] bytes) {
        try {
            Input input = new Input((InputStream)new ByteArrayInputStream(bytes));
            Kryo kryo = this.kryoCache.get();
            Object object = this.polymorphic ? kryo.readClassAndObject(input) : kryo.readObject(input, this.objectType);
            input.close();
            return (O)object;
        }
        catch (Throwable e) {
            throw new IllegalStateException("Failed to deserialize object, object type: " + this.objectType + ". Configure @PersistenceConfig.polymorphic if the collection will contain a mix of object types. Use the KryoSerializer.validateObjectIsRoundTripSerializable() method to test your object is compatible with CQEngine.", e);
        }
    }

    public static <O> void validateObjectIsRoundTripSerializable(O candidatePojo) {
        Class<?> objectType = candidatePojo.getClass();
        KryoSerializer.validateObjectIsRoundTripSerializable(candidatePojo, objectType, PersistenceConfig.DEFAULT_CONFIG);
    }

    static <O> void validateObjectIsRoundTripSerializable(O candidatePojo, Class<O> objectType, PersistenceConfig persistenceConfig) {
        try {
            KryoSerializer<O> serializer = new KryoSerializer<O>(objectType, persistenceConfig);
            byte[] serialized = serializer.serialize(candidatePojo);
            O deserializedPojo = serializer.deserialize(serialized);
            serializer.kryoCache.remove();
            KryoSerializer.validateObjectEquality(candidatePojo, deserializedPojo);
            KryoSerializer.validateHashCodeEquality(candidatePojo, deserializedPojo);
        }
        catch (Exception e) {
            throw new IllegalStateException("POJO object failed round trip serialization-deserialization test, object type: " + objectType + ", object: " + candidatePojo, e);
        }
    }

    static void validateObjectEquality(Object candidate, Object deserializedPojo) {
        if (!deserializedPojo.equals(candidate)) {
            throw new IllegalStateException("The POJO after round trip serialization is not equal to the original POJO");
        }
    }

    static void validateHashCodeEquality(Object candidate, Object deserializedPojo) {
        if (deserializedPojo.hashCode() != candidate.hashCode()) {
            throw new IllegalStateException("The POJO's hashCode after round trip serialization differs from its original hashCode");
        }
    }
}

